/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Comparators;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.Helpers;
import com.google.common.testing.CollectorTester;
import com.google.common.testing.EqualsTester;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.stream.Collector;
import junit.framework.TestCase;

@GwtCompatible
public class ComparatorsTest
extends TestCase {
    public void testLexicographical() {
        Ordering comparator = Ordering.natural();
        Comparator lexy = Comparators.lexicographical((Comparator)comparator);
        ImmutableList empty = ImmutableList.of();
        ImmutableList a = ImmutableList.of((Object)"a");
        ImmutableList aa = ImmutableList.of((Object)"a", (Object)"a");
        ImmutableList ab = ImmutableList.of((Object)"a", (Object)"b");
        ImmutableList b = ImmutableList.of((Object)"b");
        Helpers.testComparator((Comparator)lexy, (Object[])new ImmutableList[]{empty, a, aa, ab, b});
        new EqualsTester().addEqualityGroup(new Object[]{lexy, Comparators.lexicographical((Comparator)comparator)}).addEqualityGroup(new Object[]{Comparators.lexicographical((Comparator)String.CASE_INSENSITIVE_ORDER)}).addEqualityGroup(new Object[]{Ordering.natural()}).testEquals();
    }

    public void testIsInOrder() {
        ComparatorsTest.assertFalse((boolean)Comparators.isInOrder(Arrays.asList(5, 3, 0, 9), (Comparator)Ordering.natural()));
        ComparatorsTest.assertFalse((boolean)Comparators.isInOrder(Arrays.asList(0, 5, 3, 9), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInOrder(Arrays.asList(0, 3, 5, 9), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInOrder(Arrays.asList(0, 0, 3, 3), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInOrder(Arrays.asList(0, 3), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInOrder(Collections.singleton(1), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInOrder(Collections.emptyList(), (Comparator)Ordering.natural()));
    }

    public void testIsInStrictOrder() {
        ComparatorsTest.assertFalse((boolean)Comparators.isInStrictOrder(Arrays.asList(5, 3, 0, 9), (Comparator)Ordering.natural()));
        ComparatorsTest.assertFalse((boolean)Comparators.isInStrictOrder(Arrays.asList(0, 5, 3, 9), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInStrictOrder(Arrays.asList(0, 3, 5, 9), (Comparator)Ordering.natural()));
        ComparatorsTest.assertFalse((boolean)Comparators.isInStrictOrder(Arrays.asList(0, 0, 3, 3), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInStrictOrder(Arrays.asList(0, 3), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInStrictOrder(Collections.singleton(1), (Comparator)Ordering.natural()));
        ComparatorsTest.assertTrue((boolean)Comparators.isInStrictOrder(Collections.emptyList(), (Comparator)Ordering.natural()));
    }

    public void testLeastCollector() {
        CollectorTester.of((Collector)Comparators.least((int)2, Comparator.naturalOrder())).expectCollects(Arrays.asList(1, 2), (Object[])new Integer[]{1, 2, 3, 4, 5, 6}).expectCollects(Arrays.asList(1), (Object[])new Integer[]{1}).expectCollects(Collections.emptyList(), (Object[])new Integer[0]);
    }

    public void testGreatestCollector() {
        CollectorTester.of((Collector)Comparators.greatest((int)2, Comparator.naturalOrder())).expectCollects(Arrays.asList(6, 5), (Object[])new Integer[]{1, 2, 3, 4, 5, 6}).expectCollects(Arrays.asList(1), (Object[])new Integer[]{1}).expectCollects(Collections.emptyList(), (Object[])new Integer[0]);
    }

    public void testEmptiesFirst() {
        Optional empty = Optional.empty();
        Optional<String> abc = Optional.of("abc");
        Optional<String> z = Optional.of("z");
        Comparator comparator = Comparators.emptiesFirst(Comparator.comparing(String::length));
        Helpers.testComparator((Comparator)comparator, (Object[])new Optional[]{empty, z, abc});
    }
}

