/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.DiscreteDomain;
import com.google.common.testing.SerializableTester;
import java.math.BigInteger;
import junit.framework.TestCase;

@GwtIncompatible
public class DiscreteDomainTest
extends TestCase {
    public void testSerialization() {
        SerializableTester.reserializeAndAssert((Object)DiscreteDomain.integers());
        SerializableTester.reserializeAndAssert((Object)DiscreteDomain.longs());
        SerializableTester.reserializeAndAssert((Object)DiscreteDomain.bigIntegers());
    }

    public void testIntegersOffset() {
        DiscreteDomainTest.assertEquals((int)1, (int)((Integer)DiscreteDomain.integers().offset((Comparable)Integer.valueOf(0), 1L)));
        DiscreteDomainTest.assertEquals((int)Integer.MAX_VALUE, (int)((Integer)DiscreteDomain.integers().offset((Comparable)Integer.valueOf(Integer.MIN_VALUE), 0xFFFFFFFFL)));
    }

    public void testIntegersOffsetExceptions() {
        try {
            DiscreteDomain.integers().offset((Comparable)Integer.valueOf(0), -1L);
            DiscreteDomainTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DiscreteDomain.integers().offset((Comparable)Integer.valueOf(Integer.MAX_VALUE), 1L);
            DiscreteDomainTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testLongsOffset() {
        DiscreteDomainTest.assertEquals((long)1L, (long)((Long)DiscreteDomain.longs().offset((Comparable)Long.valueOf(0L), 1L)));
        DiscreteDomainTest.assertEquals((long)Long.MAX_VALUE, (long)((Long)DiscreteDomain.longs().offset((Comparable)Long.valueOf(0L), Long.MAX_VALUE)));
    }

    public void testLongsOffsetExceptions() {
        try {
            DiscreteDomain.longs().offset((Comparable)Long.valueOf(0L), -1L);
            DiscreteDomainTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DiscreteDomain.longs().offset((Comparable)Long.valueOf(Long.MAX_VALUE), 1L);
            DiscreteDomainTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBigIntegersOffset() {
        DiscreteDomainTest.assertEquals((Object)BigInteger.ONE, (Object)DiscreteDomain.bigIntegers().offset((Comparable)BigInteger.ZERO, 1L));
        DiscreteDomainTest.assertEquals((Object)BigInteger.valueOf(Long.MAX_VALUE), (Object)DiscreteDomain.bigIntegers().offset((Comparable)BigInteger.ZERO, Long.MAX_VALUE));
    }

    public void testBigIntegersOffsetExceptions() {
        try {
            DiscreteDomain.bigIntegers().offset((Comparable)BigInteger.ZERO, -1L);
            DiscreteDomainTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

