/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BiMap;
import com.google.common.collect.EnumBiMap;
import com.google.common.collect.EnumHashBiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.BiMapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestBiMapGenerator;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class EnumBiMapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((BiMapTestSuiteBuilder)((BiMapTestSuiteBuilder)BiMapTestSuiteBuilder.using((TestBiMapGenerator)new EnumBiMapGenerator()).named("EnumBiMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.GENERAL_PURPOSE, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        suite.addTestSuite(EnumBiMapTest.class);
        return suite;
    }

    public void testCreate() {
        EnumBiMap bimap = EnumBiMap.create(Currency.class, Country.class);
        EnumBiMapTest.assertTrue((boolean)bimap.isEmpty());
        EnumBiMapTest.assertEquals((String)"{}", (String)bimap.toString());
        EnumBiMapTest.assertEquals((Object)HashBiMap.create(), (Object)bimap);
        bimap.put((Object)Currency.DOLLAR, (Object)Country.CANADA);
        EnumBiMapTest.assertEquals((Object)((Object)Country.CANADA), (Object)bimap.get((Object)Currency.DOLLAR));
        EnumBiMapTest.assertEquals((Object)((Object)Currency.DOLLAR), (Object)bimap.inverse().get((Object)Country.CANADA));
    }

    public void testCreateFromMap() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA), (Object)((Object)Currency.PESO), (Object)((Object)Country.CHILE), (Object)((Object)Currency.FRANC), (Object)((Object)Country.SWITZERLAND));
        EnumBiMap bimap = EnumBiMap.create((Map)map);
        EnumBiMapTest.assertEquals((Object)((Object)Country.CANADA), (Object)bimap.get((Object)Currency.DOLLAR));
        EnumBiMapTest.assertEquals((Object)((Object)Currency.DOLLAR), (Object)bimap.inverse().get((Object)Country.CANADA));
        try {
            EnumBiMap.create(Collections.emptyMap());
            EnumBiMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            EnumBiMap.create((Map)EnumHashBiMap.create(Currency.class));
            EnumBiMapTest.fail((String)"IllegalArgumentException expected");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        EnumBiMap emptyBimap = EnumBiMap.create(Currency.class, Country.class);
        bimap = EnumBiMap.create((Map)emptyBimap);
        EnumBiMapTest.assertTrue((boolean)bimap.isEmpty());
    }

    public void testEnumBiMapConstructor() {
        EnumBiMap bimap1 = EnumBiMap.create(Currency.class, Country.class);
        bimap1.put((Object)Currency.DOLLAR, (Object)Country.CANADA);
        EnumBiMap bimap2 = EnumBiMap.create((Map)bimap1);
        EnumBiMapTest.assertEquals((Object)((Object)Country.CANADA), (Object)bimap2.get((Object)Currency.DOLLAR));
        EnumBiMapTest.assertEquals((Object)bimap1, (Object)bimap2);
        bimap2.inverse().put((Object)Country.SWITZERLAND, (Object)Currency.FRANC);
        EnumBiMapTest.assertEquals((Object)((Object)Country.SWITZERLAND), (Object)bimap2.get((Object)Currency.FRANC));
        EnumBiMapTest.assertNull((Object)bimap1.get((Object)Currency.FRANC));
        EnumBiMapTest.assertFalse((boolean)bimap2.equals((Object)bimap1));
        EnumBiMap emptyBimap = EnumBiMap.create(Currency.class, Country.class);
        EnumBiMap bimap3 = EnumBiMap.create((Map)emptyBimap);
        EnumBiMapTest.assertEquals((Object)bimap3, (Object)emptyBimap);
    }

    public void testKeyType() {
        EnumBiMap bimap = EnumBiMap.create(Currency.class, Country.class);
        EnumBiMapTest.assertEquals(Currency.class, (Object)bimap.keyType());
    }

    public void testValueType() {
        EnumBiMap bimap = EnumBiMap.create(Currency.class, Country.class);
        EnumBiMapTest.assertEquals(Country.class, (Object)bimap.valueType());
    }

    public void testIterationOrder() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA), (Object)((Object)Currency.PESO), (Object)((Object)Country.CHILE), (Object)((Object)Currency.FRANC), (Object)((Object)Country.SWITZERLAND));
        EnumBiMap bimap = EnumBiMap.create((Map)map);
        Truth.assertThat((Iterable)bimap.keySet()).containsExactly(new Object[]{Currency.DOLLAR, Currency.FRANC, Currency.PESO}).inOrder();
        Truth.assertThat((Iterable)bimap.values()).containsExactly(new Object[]{Country.CANADA, Country.SWITZERLAND, Country.CHILE}).inOrder();
        Truth.assertThat((Iterable)bimap.inverse().keySet()).containsExactly(new Object[]{Country.CANADA, Country.CHILE, Country.SWITZERLAND}).inOrder();
        Truth.assertThat((Iterable)bimap.inverse().values()).containsExactly(new Object[]{Currency.DOLLAR, Currency.PESO, Currency.FRANC}).inOrder();
    }

    public void testKeySetIteratorRemove() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA), (Object)((Object)Currency.PESO), (Object)((Object)Country.CHILE), (Object)((Object)Currency.FRANC), (Object)((Object)Country.SWITZERLAND));
        EnumBiMap bimap = EnumBiMap.create((Map)map);
        Iterator iter = bimap.keySet().iterator();
        EnumBiMapTest.assertEquals((Object)((Object)Currency.DOLLAR), iter.next());
        iter.remove();
        Truth.assertThat((Iterable)bimap.keySet()).containsExactly(new Object[]{Currency.FRANC, Currency.PESO}).inOrder();
        Truth.assertThat((Iterable)bimap.values()).containsExactly(new Object[]{Country.SWITZERLAND, Country.CHILE}).inOrder();
        Truth.assertThat((Iterable)bimap.inverse().keySet()).containsExactly(new Object[]{Country.CHILE, Country.SWITZERLAND}).inOrder();
        Truth.assertThat((Iterable)bimap.inverse().values()).containsExactly(new Object[]{Currency.PESO, Currency.FRANC}).inOrder();
    }

    public void testValuesIteratorRemove() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA), (Object)((Object)Currency.PESO), (Object)((Object)Country.CHILE), (Object)((Object)Currency.FRANC), (Object)((Object)Country.SWITZERLAND));
        EnumBiMap bimap = EnumBiMap.create((Map)map);
        Iterator iter = bimap.keySet().iterator();
        EnumBiMapTest.assertEquals((Object)((Object)Currency.DOLLAR), iter.next());
        EnumBiMapTest.assertEquals((Object)((Object)Currency.FRANC), iter.next());
        iter.remove();
        Truth.assertThat((Iterable)bimap.keySet()).containsExactly(new Object[]{Currency.DOLLAR, Currency.PESO}).inOrder();
        Truth.assertThat((Iterable)bimap.values()).containsExactly(new Object[]{Country.CANADA, Country.CHILE}).inOrder();
        Truth.assertThat((Iterable)bimap.inverse().keySet()).containsExactly(new Object[]{Country.CANADA, Country.CHILE}).inOrder();
        Truth.assertThat((Iterable)bimap.inverse().values()).containsExactly(new Object[]{Currency.DOLLAR, Currency.PESO}).inOrder();
    }

    public void testEntrySet() {
        ImmutableMap map = ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA), (Object)((Object)Currency.PESO), (Object)((Object)Country.CHILE), (Object)((Object)Currency.FRANC), (Object)((Object)Country.SWITZERLAND));
        EnumBiMap bimap = EnumBiMap.create((Map)map);
        Set uniqueEntries = Sets.newIdentityHashSet();
        uniqueEntries.addAll(bimap.entrySet());
        EnumBiMapTest.assertEquals((int)3, (int)uniqueEntries.size());
    }

    @GwtIncompatible
    public void testSerializable() {
        SerializableTester.reserializeAndAssert((Object)EnumBiMap.create((Map)ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA))));
    }

    @GwtIncompatible
    public void testNulls() {
        new NullPointerTester().testAllPublicStaticMethods(EnumBiMap.class);
        new NullPointerTester().testAllPublicInstanceMethods((Object)EnumBiMap.create((Map)ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CHILE))));
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{EnumBiMap.create((Map)ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA))), EnumBiMap.create((Map)ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CANADA)))}).addEqualityGroup(new Object[]{EnumBiMap.create((Map)ImmutableMap.of((Object)((Object)Currency.DOLLAR), (Object)((Object)Country.CHILE)))}).addEqualityGroup(new Object[]{EnumBiMap.create((Map)ImmutableMap.of((Object)((Object)Currency.FRANC), (Object)((Object)Country.CANADA)))}).testEquals();
    }

    public static final class EnumBiMapGenerator
    implements TestBiMapGenerator<Country, Currency> {
        public BiMap<Country, Currency> create(Object ... entries) {
            EnumBiMap result = EnumBiMap.create(Country.class, Currency.class);
            for (Object object : entries) {
                Map.Entry entry = (Map.Entry)object;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        public SampleElements<Map.Entry<Country, Currency>> samples() {
            return new SampleElements((Object)Helpers.mapEntry((Object)((Object)Country.CANADA), (Object)((Object)Currency.DOLLAR)), (Object)Helpers.mapEntry((Object)((Object)Country.CHILE), (Object)((Object)Currency.PESO)), (Object)Helpers.mapEntry((Object)((Object)Country.UK), (Object)((Object)Currency.POUND)), (Object)Helpers.mapEntry((Object)((Object)Country.JAPAN), (Object)((Object)Currency.YEN)), (Object)Helpers.mapEntry((Object)((Object)Country.SWITZERLAND), (Object)((Object)Currency.FRANC)));
        }

        public Map.Entry<Country, Currency>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public Iterable<Map.Entry<Country, Currency>> order(List<Map.Entry<Country, Currency>> insertionOrder) {
            return Helpers.orderEntriesByKey(insertionOrder);
        }

        public Country[] createKeyArray(int length) {
            return new Country[length];
        }

        public Currency[] createValueArray(int length) {
            return new Currency[length];
        }
    }

    private static enum Country {
        CANADA,
        CHILE,
        JAPAN,
        SWITZERLAND,
        UK;

    }

    private static enum Currency {
        DOLLAR,
        FRANC,
        PESO,
        POUND,
        YEN;

    }
}

