/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.CollectionTestSuiteBuilder;
import com.google.common.collect.testing.MinimalCollection;
import com.google.common.collect.testing.TestCollectionGenerator;
import com.google.common.collect.testing.TestStringCollectionGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingCollectionTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingCollectionTest.class);
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                return new StandardImplForwardingCollection(Lists.newLinkedList(Arrays.asList(elements)));
            }
        }).named("ForwardingCollection[LinkedList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((CollectionTestSuiteBuilder)((CollectionTestSuiteBuilder)CollectionTestSuiteBuilder.using((TestCollectionGenerator)new TestStringCollectionGenerator(){

            protected Collection<String> create(String[] elements) {
                return new StandardImplForwardingCollection(MinimalCollection.of((Object[])elements));
            }
        }).named("ForwardingCollection[MinimalCollection] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(Collection.class, (Function)new Function<Collection, Collection>(){

            public Collection apply(Collection delegate) {
                return ForwardingCollectionTest.wrap(delegate);
            }
        });
    }

    private static <T> Collection<T> wrap(final Collection<T> delegate) {
        return new ForwardingCollection<T>(){

            protected Collection<T> delegate() {
                return delegate;
            }
        };
    }

    static final class StandardImplForwardingCollection<T>
    extends ForwardingCollection<T> {
        private final Collection<T> backingCollection;

        StandardImplForwardingCollection(Collection<T> backingCollection) {
            this.backingCollection = backingCollection;
        }

        protected Collection<T> delegate() {
            return this.backingCollection;
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }
    }
}

