/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingListMultimap;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import junit.framework.TestCase;

public class ForwardingListMultimapTest
extends TestCase {
    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(ListMultimap.class, (Function)new Function<ListMultimap, ListMultimap>(){

            public ListMultimap apply(ListMultimap delegate) {
                return ForwardingListMultimapTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableListMultimap map1 = ImmutableListMultimap.of((Object)1, (Object)"one");
        ImmutableListMultimap map2 = ImmutableListMultimap.of((Object)2, (Object)"two");
        new EqualsTester().addEqualityGroup(new Object[]{map1, ForwardingListMultimapTest.wrap(map1), ForwardingListMultimapTest.wrap(map1)}).addEqualityGroup(new Object[]{map2, ForwardingListMultimapTest.wrap(map2)}).testEquals();
    }

    private static <K, V> ListMultimap<K, V> wrap(final ListMultimap<K, V> delegate) {
        return new ForwardingListMultimap<K, V>(){

            protected ListMultimap<K, V> delegate() {
                return delegate;
            }
        };
    }
}

