/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingList;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestStringListGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.ListFeature;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingListTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingListTest.class);
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                return new StandardImplForwardingList(Lists.newArrayList((Object[])elements));
            }
        }).named("ForwardingList[ArrayList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, ListFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new TestStringListGenerator(){

            protected List<String> create(String[] elements) {
                return new StandardImplForwardingList(ImmutableList.copyOf((Object[])elements));
            }
        }).named("ForwardingList[ImmutableList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(List.class, (Function)new Function<List, List>(){

            public List apply(List delegate) {
                return ForwardingListTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableList list1 = ImmutableList.of((Object)"one");
        ImmutableList list2 = ImmutableList.of((Object)"two");
        new EqualsTester().addEqualityGroup(new Object[]{list1, ForwardingListTest.wrap(list1), ForwardingListTest.wrap(list1)}).addEqualityGroup(new Object[]{list2, ForwardingListTest.wrap(list2)}).testEquals();
    }

    private static <T> List<T> wrap(final List<T> delegate) {
        return new ForwardingList<T>(){

            protected List<T> delegate() {
                return delegate;
            }
        };
    }

    static final class StandardImplForwardingList<T>
    extends ForwardingList<T> {
        private final List<T> backingList;

        StandardImplForwardingList(List<T> backingList) {
            this.backingList = backingList;
        }

        protected List<T> delegate() {
            return this.backingList;
        }

        public boolean add(T element) {
            return this.standardAdd(element);
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public boolean addAll(int index, Collection<? extends T> elements) {
            return this.standardAddAll(index, elements);
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public int indexOf(Object element) {
            return this.standardIndexOf(element);
        }

        public int lastIndexOf(Object element) {
            return this.standardLastIndexOf(element);
        }

        public Iterator<T> iterator() {
            return this.listIterator();
        }

        public ListIterator<T> listIterator() {
            return this.listIterator(0);
        }

        public ListIterator<T> listIterator(int index) {
            return this.standardListIterator(index);
        }

        public List<T> subList(int fromIndex, int toIndex) {
            return this.standardSubList(fromIndex, toIndex);
        }
    }
}

