/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.TestStringMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Reflection;
import com.google.common.testing.ArbitraryInstances;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ForwardingMapTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                LinkedHashMap map = Maps.newLinkedHashMap();
                for (Map.Entry<String, String> entry : entries) {
                    map.put(entry.getKey(), entry.getValue());
                }
                return new StandardImplForwardingMap(map);
            }
        }).named("ForwardingMap[LinkedHashMap] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_ANY_NULL_QUERIES, MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestStringMapGenerator(){

            protected Map<String, String> create(Map.Entry<String, String>[] entries) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (Map.Entry<String, String> entry : entries) {
                    builder.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return new StandardImplForwardingMap(builder.build());
            }
        }).named("ForwardingMap[ImmutableMap] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(Map.class, (Function)new Function<Map, Map>(){

            public Map apply(Map delegate) {
                return ForwardingMapTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableMap map1 = ImmutableMap.of((Object)1, (Object)"one");
        ImmutableMap map2 = ImmutableMap.of((Object)2, (Object)"two");
        new EqualsTester().addEqualityGroup(new Object[]{map1, ForwardingMapTest.wrap(map1), ForwardingMapTest.wrap(map1)}).addEqualityGroup(new Object[]{map2, ForwardingMapTest.wrap(map2)}).testEquals();
    }

    public void testStandardEntrySet() throws InvocationTargetException {
        final Map map = (Map)Mockito.mock(Map.class);
        ForwardingMap<String, Boolean> forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }

            public Set<Map.Entry<String, Boolean>> entrySet() {
                return new ForwardingMap.StandardEntrySet(){

                    public Iterator<Map.Entry<String, Boolean>> iterator() {
                        return Iterators.emptyIterator();
                    }
                };
            }
        };
        ForwardingMapTest.callAllPublicMethods(Set.class, forward.entrySet());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).clear();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).containsKey(Mockito.anyObject());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).get(Mockito.anyObject());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).isEmpty();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).remove(Mockito.anyObject());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).size();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
    }

    public void testStandardKeySet() throws InvocationTargetException {
        final Map map = (Map)Mockito.mock(Map.class);
        ForwardingMap<String, Boolean> forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }

            public Set<String> keySet() {
                return new ForwardingMap.StandardKeySet((ForwardingMap)this);
            }
        };
        ForwardingMapTest.callAllPublicMethods(Set.class, forward.keySet());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).clear();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).containsKey(Mockito.anyObject());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).isEmpty();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).remove(Mockito.anyObject());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).size();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).entrySet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
    }

    public void testStandardValues() throws InvocationTargetException {
        final Map map = (Map)Mockito.mock(Map.class);
        ForwardingMap<String, Boolean> forward = new ForwardingMap<String, Boolean>(){

            protected Map<String, Boolean> delegate() {
                return map;
            }

            public Collection<Boolean> values() {
                return new ForwardingMap.StandardValues((ForwardingMap)this);
            }
        };
        ForwardingMapTest.callAllPublicMethods(Collection.class, forward.values());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).clear();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).containsValue(Mockito.anyObject());
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).isEmpty();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).size();
        ((Map)Mockito.verify((Object)map, (VerificationMode)Mockito.atLeast((int)0))).entrySet();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{map});
    }

    public void testToStringWithNullKeys() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put(null, "baz");
        StandardImplForwardingMap forwardingMap = new StandardImplForwardingMap(Maps.newHashMap());
        forwardingMap.put("foo", "bar");
        forwardingMap.put(null, "baz");
        ForwardingMapTest.assertEquals((String)((Object)hashmap).toString(), (String)forwardingMap.toString());
    }

    public void testToStringWithNullValues() throws Exception {
        HashMap hashmap = Maps.newHashMap();
        hashmap.put("foo", "bar");
        hashmap.put("baz", null);
        StandardImplForwardingMap forwardingMap = new StandardImplForwardingMap(Maps.newHashMap());
        forwardingMap.put("foo", "bar");
        forwardingMap.put("baz", null);
        ForwardingMapTest.assertEquals((String)((Object)hashmap).toString(), (String)forwardingMap.toString());
    }

    private static <K, V> Map<K, V> wrap(final Map<K, V> delegate) {
        return new ForwardingMap<K, V>(){

            protected Map<K, V> delegate() {
                return delegate;
            }
        };
    }

    private static Object getDefaultValue(Class<?> returnType) {
        Object defaultValue = ArbitraryInstances.get(returnType);
        if (defaultValue != null) {
            return defaultValue;
        }
        if ("java.util.function.Predicate".equals(returnType.getCanonicalName()) || "java.util.function.Consumer".equals(returnType.getCanonicalName())) {
            return Reflection.newProxy(returnType, (InvocationHandler)new AbstractInvocationHandler(){

                public Object handleInvocation(Object proxy, Method method, Object[] args) {
                    if ("test".equals(method.getName()) || "accept".equals(method.getName())) {
                        return ForwardingMapTest.getDefaultValue(method.getReturnType());
                    }
                    throw new IllegalStateException("Unexpected " + method + " invoked on " + proxy);
                }
            });
        }
        return null;
    }

    private static <T> void callAllPublicMethods(Class<T> theClass, T object) throws InvocationTargetException {
        for (Method method : theClass.getMethods()) {
            if ((method.getModifiers() & 8) != 0) continue;
            Class<?>[] parameterTypes = method.getParameterTypes();
            Object[] parameters = new Object[parameterTypes.length];
            for (int i = 0; i < parameterTypes.length; ++i) {
                parameters[i] = ForwardingMapTest.getDefaultValue(parameterTypes[i]);
            }
            try {
                try {
                    method.invoke(object, parameters);
                }
                catch (InvocationTargetException ex) {
                    try {
                        throw ex.getCause();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {}
                }
            }
            catch (Throwable cause) {
                throw new InvocationTargetException(cause, method + " with args: " + Arrays.toString(parameters));
            }
        }
    }

    static class StandardImplForwardingMap<K, V>
    extends ForwardingMap<K, V> {
        private final Map<K, V> backingMap;

        StandardImplForwardingMap(Map<K, V> backingMap) {
            this.backingMap = backingMap;
        }

        protected Map<K, V> delegate() {
            return this.backingMap;
        }

        public boolean containsKey(Object key) {
            return this.standardContainsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.standardContainsValue(value);
        }

        public void putAll(Map<? extends K, ? extends V> map) {
            this.standardPutAll(map);
        }

        public V remove(Object object) {
            return (V)this.standardRemove(object);
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public Set<K> keySet() {
            return new ForwardingMap.StandardKeySet((ForwardingMap)this);
        }

        public Collection<V> values() {
            return new ForwardingMap.StandardValues((ForwardingMap)this);
        }

        public String toString() {
            return this.standardToString();
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return new ForwardingMap.StandardEntrySet(){

                public Iterator<Map.Entry<K, V>> iterator() {
                    return this.delegate().entrySet().iterator();
                }
            };
        }

        public void clear() {
            this.standardClear();
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }
    }
}

