/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import junit.framework.TestCase;

public class ForwardingMultimapTest
extends TestCase {
    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(Multimap.class, (Function)new Function<Multimap, Multimap>(){

            public Multimap apply(Multimap delegate) {
                return ForwardingMultimapTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableMultimap map1 = ImmutableMultimap.of((Object)1, (Object)"one");
        ImmutableMultimap map2 = ImmutableMultimap.of((Object)2, (Object)"two");
        new EqualsTester().addEqualityGroup(new Object[]{map1, ForwardingMultimapTest.wrap(map1), ForwardingMultimapTest.wrap(map1)}).addEqualityGroup(new Object[]{map2, ForwardingMultimapTest.wrap(map2)}).testEquals();
    }

    private static <K, V> Multimap<K, V> wrap(final Multimap<K, V> delegate) {
        return new ForwardingMultimap<K, V>(){

            protected Multimap<K, V> delegate() {
                return delegate;
            }
        };
    }
}

