/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.SafeTreeSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableSet;
import java.util.Set;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingNavigableSetTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingNavigableSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new StandardImplForwardingNavigableSet(new SafeTreeSet(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).named("ForwardingNavigableSet[SafeTreeSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                SafeTreeSet set = new SafeTreeSet((Comparator)Ordering.natural().nullsFirst());
                Collections.addAll(set, elements);
                return new StandardImplForwardingNavigableSet(set);
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).named("ForwardingNavigableSet[SafeTreeSet[Ordering.natural.nullsFirst]] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(NavigableSet.class, (Function)new Function<NavigableSet, NavigableSet>(){

            public NavigableSet apply(NavigableSet delegate) {
                return ForwardingNavigableSetTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableSortedSet set1 = ImmutableSortedSet.of((Comparable)((Object)"one"));
        ImmutableSortedSet set2 = ImmutableSortedSet.of((Comparable)((Object)"two"));
        new EqualsTester().addEqualityGroup(new Object[]{set1, ForwardingNavigableSetTest.wrap(set1), ForwardingNavigableSetTest.wrap(set1)}).addEqualityGroup(new Object[]{set2, ForwardingNavigableSetTest.wrap(set2)}).testEquals();
    }

    private static <T> NavigableSet<T> wrap(final NavigableSet<T> delegate) {
        return new ForwardingNavigableSet<T>(){

            protected NavigableSet<T> delegate() {
                return delegate;
            }
        };
    }

    static class StandardImplForwardingNavigableSet<T>
    extends ForwardingNavigableSet<T> {
        private final NavigableSet<T> backingSet;

        StandardImplForwardingNavigableSet(NavigableSet<T> backingSet) {
            this.backingSet = backingSet;
        }

        protected NavigableSet<T> delegate() {
            return this.backingSet;
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public SortedSet<T> subSet(T fromElement, T toElement) {
            return this.standardSubSet(fromElement, toElement);
        }

        public T lower(T e) {
            return (T)this.standardLower(e);
        }

        public T floor(T e) {
            return (T)this.standardFloor(e);
        }

        public T ceiling(T e) {
            return (T)this.standardCeiling(e);
        }

        public T higher(T e) {
            return (T)this.standardHigher(e);
        }

        public T pollFirst() {
            return (T)this.standardPollFirst();
        }

        public T pollLast() {
            return (T)this.standardPollLast();
        }

        public SortedSet<T> headSet(T toElement) {
            return this.standardHeadSet(toElement);
        }

        public SortedSet<T> tailSet(T fromElement) {
            return this.standardTailSet(fromElement);
        }
    }
}

