/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingQueue;
import com.google.common.collect.Lists;
import com.google.common.collect.testing.QueueTestSuiteBuilder;
import com.google.common.collect.testing.TestQueueGenerator;
import com.google.common.collect.testing.TestStringQueueGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Queue;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingQueueTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingQueueTest.class);
        suite.addTest((Test)((QueueTestSuiteBuilder)((QueueTestSuiteBuilder)QueueTestSuiteBuilder.using((TestQueueGenerator)new TestStringQueueGenerator(){

            protected Queue<String> create(String[] elements) {
                return new StandardImplForwardingQueue(Lists.newLinkedList(Arrays.asList(elements)));
            }
        }).named("ForwardingQueue[LinkedList] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(Queue.class, (Function)new Function<Queue, Queue>(){

            public Queue apply(Queue delegate) {
                return ForwardingQueueTest.wrap(delegate);
            }
        });
    }

    private static <T> Queue<T> wrap(final Queue<T> delegate) {
        return new ForwardingQueue<T>(){

            protected Queue<T> delegate() {
                return delegate;
            }
        };
    }

    static final class StandardImplForwardingQueue<T>
    extends ForwardingQueue<T> {
        private final Queue<T> backingQueue;

        StandardImplForwardingQueue(Queue<T> backingQueue) {
            this.backingQueue = backingQueue;
        }

        protected Queue<T> delegate() {
            return this.backingQueue;
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public boolean offer(T o) {
            return this.standardOffer(o);
        }

        public T peek() {
            return (T)this.standardPeek();
        }

        public T poll() {
            return (T)this.standardPoll();
        }
    }
}

