/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.MinimalSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingSetTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new StandardImplForwardingSet(Sets.newLinkedHashSet(Arrays.asList(elements)));
            }
        }).named("ForwardingSet[LinkedHashSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                return new StandardImplForwardingSet(MinimalSet.of((Object[])elements));
            }
        }).named("ForwardingSet[MinimalSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(Set.class, (Function)new Function<Set, Set>(){

            public Set apply(Set delegate) {
                return ForwardingSetTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableSet set1 = ImmutableSet.of((Object)"one");
        ImmutableSet set2 = ImmutableSet.of((Object)"two");
        new EqualsTester().addEqualityGroup(new Object[]{set1, ForwardingSetTest.wrap(set1), ForwardingSetTest.wrap(set1)}).addEqualityGroup(new Object[]{set2, ForwardingSetTest.wrap(set2)}).testEquals();
    }

    private static <T> Set<T> wrap(final Set<T> delegate) {
        return new ForwardingSet<T>(){

            protected Set<T> delegate() {
                return delegate;
            }
        };
    }

    static class StandardImplForwardingSet<T>
    extends ForwardingSet<T> {
        private final Set<T> backingSet;

        StandardImplForwardingSet(Set<T> backingSet) {
            this.backingSet = backingSet;
        }

        protected Set<T> delegate() {
            return this.backingSet;
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }
    }
}

