/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.Ordering;
import com.google.common.collect.testing.SortedMapInterfaceTest;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

@GwtCompatible
public class ForwardingSortedMapImplementsMapTest
extends SortedMapInterfaceTest<String, Integer> {
    public ForwardingSortedMapImplementsMapTest() {
        super(true, true, true, true, true);
    }

    protected SortedMap<String, Integer> makeEmptyMap() {
        return new SimpleForwardingSortedMap(new TreeMap(Ordering.natural().nullsFirst()));
    }

    protected SortedMap<String, Integer> makePopulatedMap() {
        Map sortedMap = this.makeEmptyMap();
        sortedMap.put("one", 1);
        sortedMap.put("two", 2);
        sortedMap.put("three", 3);
        return sortedMap;
    }

    protected String getKeyNotInPopulatedMap() throws UnsupportedOperationException {
        return "minus one";
    }

    protected Integer getValueNotInPopulatedMap() throws UnsupportedOperationException {
        return -1;
    }

    public void testContainsKey() {
        try {
            super.testContainsKey();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testEntrySetContainsEntryIncompatibleKey() {
        try {
            super.testEntrySetContainsEntryIncompatibleKey();
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void testEntrySetRemoveAllNullFromEmpty() {
        try {
            super.testEntrySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testEntrySetRetainAllNullFromEmpty() {
        try {
            super.testEntrySetRetainAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testKeySetRemoveAllNullFromEmpty() {
        try {
            super.testKeySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testKeySetRetainAllNullFromEmpty() {
        try {
            super.testKeySetRetainAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testValuesRemoveAllNullFromEmpty() {
        try {
            super.testValuesRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testValuesRetainAllNullFromEmpty() {
        try {
            super.testValuesRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static class SimpleForwardingSortedMap<K, V>
    extends ForwardingSortedMap<K, V> {
        final SortedMap<K, V> delegate;

        SimpleForwardingSortedMap(SortedMap<K, V> delegate) {
            this.delegate = delegate;
        }

        protected SortedMap<K, V> delegate() {
            return this.delegate;
        }
    }
}

