/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ForwardingSortedMultiset;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.SortedMultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingSortedMultisetTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSortedMultisetTest.class);
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using((TestMultisetGenerator)new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return new StandardImplForwardingSortedMultiset(TreeMultiset.create(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).named("ForwardingSortedMultiset with standard impls")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(SortedMultiset.class, (Function)new Function<SortedMultiset, SortedMultiset>(){

            public SortedMultiset apply(SortedMultiset delegate) {
                return ForwardingSortedMultisetTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableSortedMultiset set1 = ImmutableSortedMultiset.of((Comparable)((Object)"one"));
        ImmutableSortedMultiset set2 = ImmutableSortedMultiset.of((Comparable)((Object)"two"));
        new EqualsTester().addEqualityGroup(new Object[]{set1, ForwardingSortedMultisetTest.wrap(set1), ForwardingSortedMultisetTest.wrap(set1)}).addEqualityGroup(new Object[]{set2, ForwardingSortedMultisetTest.wrap(set2)}).testEquals();
    }

    private static <T> SortedMultiset<T> wrap(final SortedMultiset<T> delegate) {
        return new ForwardingSortedMultiset<T>(){

            protected SortedMultiset<T> delegate() {
                return delegate;
            }
        };
    }

    static class StandardImplForwardingSortedMultiset<E>
    extends ForwardingSortedMultiset<E> {
        private final SortedMultiset<E> backingMultiset;

        StandardImplForwardingSortedMultiset(SortedMultiset<E> backingMultiset) {
            this.backingMultiset = backingMultiset;
        }

        protected SortedMultiset<E> delegate() {
            return this.backingMultiset;
        }

        public SortedMultiset<E> descendingMultiset() {
            return new ForwardingSortedMultiset.StandardDescendingMultiset(){

                Iterator<Multiset.Entry<E>> entryIterator() {
                    return backingMultiset.descendingMultiset().entrySet().iterator();
                }
            };
        }

        public NavigableSet<E> elementSet() {
            return new ForwardingSortedMultiset.StandardElementSet((ForwardingSortedMultiset)this);
        }

        public Multiset.Entry<E> firstEntry() {
            return this.standardFirstEntry();
        }

        public Multiset.Entry<E> lastEntry() {
            return this.standardLastEntry();
        }

        public Multiset.Entry<E> pollFirstEntry() {
            return this.standardPollFirstEntry();
        }

        public Multiset.Entry<E> pollLastEntry() {
            return this.standardPollLastEntry();
        }

        public SortedMultiset<E> subMultiset(E lowerBound, BoundType lowerBoundType, E upperBound, BoundType upperBoundType) {
            return this.standardSubMultiset(lowerBound, lowerBoundType, upperBound, upperBoundType);
        }

        public int count(@Nullable Object element) {
            return this.standardCount(element);
        }

        public boolean equals(@Nullable Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean add(E element) {
            return this.standardAdd(element);
        }

        public boolean addAll(Collection<? extends E> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(@Nullable Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean isEmpty() {
            return this.standardIsEmpty();
        }

        public Iterator<E> iterator() {
            return this.standardIterator();
        }

        public boolean remove(@Nullable Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public int size() {
            return this.standardSize();
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }
    }
}

