/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.testing.SafeTreeSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.SortedSetTestSuiteBuilder;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ForwardingSortedSetTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ForwardingSortedSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SortedSetTestSuiteBuilder.using((TestSortedSetGenerator)new TestStringSortedSetGenerator(){

            protected SortedSet<String> create(String[] elements) {
                return new StandardImplForwardingSortedSet(new SafeTreeSet(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)Sets.newTreeSet(insertionOrder));
            }
        }).named("ForwardingSortedSet[SafeTreeSet] with standard implementations")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE})).createTestSuite());
        return suite;
    }

    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(SortedSet.class, (Function)new Function<SortedSet, SortedSet>(){

            public SortedSet apply(SortedSet delegate) {
                return ForwardingSortedSetTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableSortedSet set1 = ImmutableSortedSet.of((Comparable)((Object)"one"));
        ImmutableSortedSet set2 = ImmutableSortedSet.of((Comparable)((Object)"two"));
        new EqualsTester().addEqualityGroup(new Object[]{set1, ForwardingSortedSetTest.wrap(set1), ForwardingSortedSetTest.wrap(set1)}).addEqualityGroup(new Object[]{set2, ForwardingSortedSetTest.wrap(set2)}).testEquals();
    }

    private static <T> SortedSet<T> wrap(final SortedSet<T> delegate) {
        return new ForwardingSortedSet<T>(){

            protected SortedSet<T> delegate() {
                return delegate;
            }
        };
    }

    static class StandardImplForwardingSortedSet<T>
    extends ForwardingSortedSet<T> {
        private final SortedSet<T> backingSortedSet;

        StandardImplForwardingSortedSet(SortedSet<T> backingSortedSet) {
            this.backingSortedSet = backingSortedSet;
        }

        protected SortedSet<T> delegate() {
            return this.backingSortedSet;
        }

        public boolean equals(Object object) {
            return this.standardEquals(object);
        }

        public int hashCode() {
            return this.standardHashCode();
        }

        public boolean addAll(Collection<? extends T> collection) {
            return this.standardAddAll(collection);
        }

        public void clear() {
            this.standardClear();
        }

        public boolean contains(Object object) {
            return this.standardContains(object);
        }

        public boolean containsAll(Collection<?> collection) {
            return this.standardContainsAll(collection);
        }

        public boolean remove(Object object) {
            return this.standardRemove(object);
        }

        public boolean removeAll(Collection<?> collection) {
            return this.standardRemoveAll(collection);
        }

        public boolean retainAll(Collection<?> collection) {
            return this.standardRetainAll(collection);
        }

        public Object[] toArray() {
            return this.standardToArray();
        }

        public <T> T[] toArray(T[] array) {
            return this.standardToArray(array);
        }

        public String toString() {
            return this.standardToString();
        }

        public SortedSet<T> subSet(T fromElement, T toElement) {
            return this.standardSubSet(fromElement, toElement);
        }
    }
}

