/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Function;
import com.google.common.collect.ForwardingTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.ForwardingWrapperTester;
import junit.framework.TestCase;

public class ForwardingTableTest
extends TestCase {
    public void testForwarding() {
        new ForwardingWrapperTester().testForwarding(Table.class, (Function)new Function<Table, Table>(){

            public Table apply(Table delegate) {
                return ForwardingTableTest.wrap(delegate);
            }
        });
    }

    public void testEquals() {
        ImmutableTable table1 = ImmutableTable.of((Object)1, (Object)1, (Object)"one");
        ImmutableTable table2 = ImmutableTable.of((Object)2, (Object)2, (Object)"two");
        new EqualsTester().addEqualityGroup(new Object[]{table1, ForwardingTableTest.wrap(table1), ForwardingTableTest.wrap(table1)}).addEqualityGroup(new Object[]{table2, ForwardingTableTest.wrap(table2)}).testEquals();
    }

    private static <R, C, V> Table<R, C, V> wrap(final Table<R, C, V> delegate) {
        return new ForwardingTable<R, C, V>(){

            protected Table<R, C, V> delegate() {
                return delegate;
            }
        };
    }
}

