/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import com.google.common.testing.NullPointerTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;

@GwtCompatible(emulated=true)
public class HashBasedTableTest
extends AbstractTableTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)"foo", (Object)4, (Object)Character.valueOf('a'));
        table.put((Object)"cat", (Object)1, (Object)Character.valueOf('b'));
        table.clear();
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    public void testIterationOrder() {
        HashBasedTable table = HashBasedTable.create();
        for (int i = 0; i < 5; ++i) {
            table.put((Object)("r" + i), (Object)("c" + i), (Object)("v" + i));
        }
        Truth.assertThat((Iterable)table.rowKeySet()).containsExactly(new Object[]{"r0", "r1", "r2", "r3", "r4"}).inOrder();
        Truth.assertThat((Iterable)table.columnKeySet()).containsExactly(new Object[]{"c0", "c1", "c2", "c3", "c4"}).inOrder();
        Truth.assertThat((Iterable)table.values()).containsExactly(new Object[]{"v0", "v1", "v2", "v3", "v4"}).inOrder();
    }

    public void testCreateWithValidSizes() {
        HashBasedTable table1 = HashBasedTable.create((int)100, (int)20);
        table1.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table1.get((Object)"foo", (Object)1));
        HashBasedTable table2 = HashBasedTable.create((int)100, (int)0);
        table2.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table2.get((Object)"foo", (Object)1));
        HashBasedTable table3 = HashBasedTable.create((int)0, (int)20);
        table3.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table3.get((Object)"foo", (Object)1));
        HashBasedTable table4 = HashBasedTable.create((int)0, (int)0);
        table4.put((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)table4.get((Object)"foo", (Object)1));
    }

    public void testCreateWithInvalidSizes() {
        try {
            HashBasedTable.create((int)100, (int)-5);
            HashBasedTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            HashBasedTable.create((int)-5, (int)20);
            HashBasedTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testCreateCopy() {
        Table<String, Integer, Character> original = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        HashBasedTable copy = HashBasedTable.create(original);
        HashBasedTableTest.assertEquals(original, (Object)copy);
        HashBasedTableTest.assertEquals((Object)Character.valueOf('a'), (Object)copy.get((Object)"foo", (Object)1));
    }

    @GwtIncompatible
    public void testSerialization() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SerializableTester.reserializeAndAssert((Object)this.table);
    }

    @GwtIncompatible
    public void testNullPointerStatic() {
        new NullPointerTester().testAllPublicStaticMethods(HashBasedTable.class);
    }
}

