/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetFeature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class HashMultisetTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)HashMultisetTest.hashMultisetGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.FAILS_FAST_ON_CONCURRENT_MODIFICATION, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.SERIALIZABLE, CollectionFeature.GENERAL_PURPOSE, MultisetFeature.ENTRIES_ARE_VIEWS})).named("HashMultiset")).createTestSuite());
        suite.addTestSuite(HashMultisetTest.class);
        return suite;
    }

    private static TestStringMultisetGenerator hashMultisetGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return HashMultiset.create(Arrays.asList(elements));
            }
        };
    }

    public void testCreate() {
        HashMultiset multiset = HashMultiset.create();
        multiset.add((Object)"foo", 2);
        multiset.add((Object)"bar");
        HashMultisetTest.assertEquals((int)3, (int)multiset.size());
        HashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
    }

    public void testCreateWithSize() {
        HashMultiset multiset = HashMultiset.create((int)50);
        multiset.add((Object)"foo", 2);
        multiset.add((Object)"bar");
        HashMultisetTest.assertEquals((int)3, (int)multiset.size());
        HashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
    }

    public void testCreateFromIterable() {
        HashMultiset multiset = HashMultiset.create(Arrays.asList("foo", "bar", "foo"));
        HashMultisetTest.assertEquals((int)3, (int)multiset.size());
        HashMultisetTest.assertEquals((int)2, (int)multiset.count((Object)"foo"));
    }

    @GwtIncompatible
    public void testSerializationContainingSelf() {
        HashMultiset multiset = HashMultiset.create();
        multiset.add((Object)multiset, 2);
        Multiset copy = (Multiset)SerializableTester.reserialize((Object)multiset);
        HashMultisetTest.assertEquals((int)2, (int)copy.size());
        HashMultisetTest.assertSame((Object)copy, copy.iterator().next());
    }

    @GwtIncompatible
    public void testSerializationIndirectSelfReference() {
        HashMultiset multiset = HashMultiset.create();
        MultisetHolder holder = new MultisetHolder((Multiset<?>)multiset);
        multiset.add((Object)holder, 2);
        Multiset copy = (Multiset)SerializableTester.reserialize((Object)multiset);
        HashMultisetTest.assertEquals((int)2, (int)copy.size());
        HashMultisetTest.assertSame((Object)copy, ((MultisetHolder)copy.iterator().next()).member);
    }

    @GwtIncompatible
    private static class MultisetHolder
    implements Serializable {
        public Multiset<?> member;
        private static final long serialVersionUID = 1L;

        MultisetHolder(Multiset<?> multiset) {
            this.member = multiset;
        }
    }
}

