/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableClassToInstanceMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class ImmutableClassToInstanceMapTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableClassToInstanceMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestClassToInstanceMapGenerator(){

            public Map<Class, Impl> create(Object ... elements) {
                ImmutableClassToInstanceMap.Builder builder = ImmutableClassToInstanceMap.builder();
                for (Object object : elements) {
                    Map.Entry entry = (Map.Entry)object;
                    builder.put((Class)entry.getKey(), entry.getValue());
                }
                return builder.build();
            }
        }).named("ImmutableClassToInstanceMap")).withFeatures(new Feature[]{MapFeature.REJECTS_DUPLICATES_AT_CREATION, MapFeature.RESTRICTS_KEYS, CollectionFeature.KNOWN_ORDER, CollectionSize.ANY, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.SERIALIZABLE})).createTestSuite());
        return suite;
    }

    public void testSerialization_empty() {
        ImmutableClassToInstanceMapTest.assertSame((Object)ImmutableClassToInstanceMap.of(), (Object)SerializableTester.reserialize((Object)ImmutableClassToInstanceMap.of()));
    }

    public void testCopyOf_map_empty() {
        Map in = Collections.emptyMap();
        ImmutableClassToInstanceMap map = ImmutableClassToInstanceMap.copyOf(in);
        ImmutableClassToInstanceMapTest.assertTrue((boolean)map.isEmpty());
        ImmutableClassToInstanceMapTest.assertSame((Object)map, (Object)ImmutableClassToInstanceMap.of());
        ImmutableClassToInstanceMapTest.assertSame((Object)map, (Object)ImmutableClassToInstanceMap.copyOf((Map)map));
    }

    public void testOf_zero() {
        ImmutableClassToInstanceMapTest.assertTrue((boolean)ImmutableClassToInstanceMap.of().isEmpty());
    }

    public void testOf_one() {
        ImmutableClassToInstanceMap map = ImmutableClassToInstanceMap.of(Integer.TYPE, (Object)1);
        ImmutableClassToInstanceMapTest.assertEquals((int)1, (int)map.size());
    }

    public void testCopyOf_map_valid() {
        HashMap in = Maps.newHashMap();
        in.put(Number.class, 0);
        in.put(Double.class, Math.PI);
        ImmutableClassToInstanceMap map = ImmutableClassToInstanceMap.copyOf((Map)in);
        ImmutableClassToInstanceMapTest.assertEquals((int)2, (int)map.size());
        Number zero = (Number)map.getInstance(Number.class);
        ImmutableClassToInstanceMapTest.assertEquals((Object)0, (Object)zero);
        Double pi = (Double)map.getInstance(Double.class);
        ImmutableClassToInstanceMapTest.assertEquals((double)Math.PI, (double)pi, (double)0.0);
        ImmutableClassToInstanceMapTest.assertSame((Object)map, (Object)ImmutableClassToInstanceMap.copyOf((Map)map));
    }

    public void testCopyOf_map_nulls() {
        Map<Object, Double> nullKey = Collections.singletonMap(null, 1.0);
        try {
            ImmutableClassToInstanceMap.copyOf(nullKey);
            ImmutableClassToInstanceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Map<Class<Number>, Object> nullValue = Collections.singletonMap(Number.class, null);
        try {
            ImmutableClassToInstanceMap.copyOf(nullValue);
            ImmutableClassToInstanceMapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOf_imap_empty() {
        Map in = Collections.emptyMap();
        ImmutableClassToInstanceMap map = ImmutableClassToInstanceMap.copyOf(in);
        ImmutableClassToInstanceMapTest.assertTrue((boolean)map.isEmpty());
    }

    public void testCopyOf_imap_valid() {
        ImmutableMap in = ImmutableMap.of(Number.class, (Object)0, Double.class, (Object)Math.PI);
        ImmutableClassToInstanceMap map = ImmutableClassToInstanceMap.copyOf((Map)in);
        ImmutableClassToInstanceMapTest.assertEquals((int)2, (int)map.size());
        Number zero = (Number)map.getInstance(Number.class);
        ImmutableClassToInstanceMapTest.assertEquals((Object)0, (Object)zero);
        Double pi = (Double)map.getInstance(Double.class);
        ImmutableClassToInstanceMapTest.assertEquals((double)Math.PI, (double)pi, (double)0.0);
    }

    public void testPrimitiveAndWrapper() {
        ImmutableClassToInstanceMap ictim = new ImmutableClassToInstanceMap.Builder().put(Integer.class, (Object)0).put(Integer.TYPE, (Object)1).build();
        ImmutableClassToInstanceMapTest.assertEquals((int)2, (int)ictim.size());
        ImmutableClassToInstanceMapTest.assertEquals((int)0, (int)((Integer)ictim.getInstance(Integer.class)));
        ImmutableClassToInstanceMapTest.assertEquals((int)1, (int)((Integer)ictim.getInstance(Integer.TYPE)));
    }

    static final class Impl
    implements One,
    Two,
    Three,
    Four,
    Five,
    Serializable {
        final int value;

        Impl(int value) {
            this.value = value;
        }

        public boolean equals(Object obj) {
            return obj instanceof Impl && this.value == ((Impl)obj).value;
        }

        public int hashCode() {
            return this.value;
        }

        public String toString() {
            return Integer.toString(this.value);
        }
    }

    private static interface Five {
    }

    private static interface Four {
    }

    private static interface Three {
    }

    private static interface Two {
    }

    private static interface One {
    }

    static abstract class TestClassToInstanceMapGenerator
    implements TestMapGenerator<Class, Impl> {
        TestClassToInstanceMapGenerator() {
        }

        public Class[] createKeyArray(int length) {
            return new Class[length];
        }

        public Impl[] createValueArray(int length) {
            return new Impl[length];
        }

        public SampleElements<Map.Entry<Class, Impl>> samples() {
            return new SampleElements((Object)Maps.immutableEntry(One.class, (Object)new Impl(1)), (Object)Maps.immutableEntry(Two.class, (Object)new Impl(2)), (Object)Maps.immutableEntry(Three.class, (Object)new Impl(3)), (Object)Maps.immutableEntry(Four.class, (Object)new Impl(4)), (Object)Maps.immutableEntry(Five.class, (Object)new Impl(5)));
        }

        public Map.Entry<Class, Impl>[] createArray(int length) {
            return new Map.Entry[length];
        }

        public Iterable<Map.Entry<Class, Impl>> order(List<Map.Entry<Class, Impl>> insertionOrder) {
            return insertionOrder;
        }
    }
}

