/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.AnEnum;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.TestEnumMapGenerator;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.testing.CollectorTester;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableEnumMapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new ImmutableEnumMapGenerator()).named("Maps.immutableEnumMap")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(ImmutableEnumMapTest.class);
        return suite;
    }

    public void testIteratesOnce() {
        Map map = Maps.asMap((Set)ImmutableSet.of((Object)AnEnum.A), (Function)new Function<AnEnum, AnEnum>(){
            boolean used = false;

            public AnEnum apply(AnEnum ae) {
                Preconditions.checkState((!this.used ? 1 : 0) != 0, (Object)"should not be applied more than once");
                this.used = true;
                return ae;
            }
        });
        ImmutableMap copy = Maps.immutableEnumMap((Map)map);
        Truth.assertThat((Iterable)copy.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)AnEnum.A, (Object)AnEnum.A)});
    }

    public void testEmptyImmutableEnumMap() {
        ImmutableMap map = Maps.immutableEnumMap((Map)ImmutableMap.of());
        ImmutableEnumMapTest.assertEquals((Object)ImmutableMap.of(), (Object)map);
    }

    public void testImmutableEnumMapOrdering() {
        ImmutableMap map = Maps.immutableEnumMap((Map)ImmutableMap.of((Object)AnEnum.C, (Object)"c", (Object)AnEnum.A, (Object)"a", (Object)AnEnum.E, (Object)"e"));
        Truth.assertThat((Iterable)map.entrySet()).containsExactly(new Object[]{Helpers.mapEntry((Object)AnEnum.A, (Object)"a"), Helpers.mapEntry((Object)AnEnum.C, (Object)"c"), Helpers.mapEntry((Object)AnEnum.E, (Object)"e")}).inOrder();
    }

    public void testToImmutableEnumMap() {
        Collector collector = Maps.toImmutableEnumMap(Map.Entry::getKey, Map.Entry::getValue);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(ImmutableMap::entrySet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)ImmutableMap.of((Object)AnEnum.A, (Object)1, (Object)AnEnum.C, (Object)2, (Object)AnEnum.E, (Object)3), (Object[])new Map.Entry[]{Helpers.mapEntry((Object)AnEnum.A, (Object)1), Helpers.mapEntry((Object)AnEnum.C, (Object)2), Helpers.mapEntry((Object)AnEnum.E, (Object)3)});
    }

    public void testToImmutableMap_exceptionOnDuplicateKey() {
        Collector collector = Maps.toImmutableEnumMap(Map.Entry::getKey, Map.Entry::getValue);
        try {
            Stream.of(Helpers.mapEntry((Object)AnEnum.A, (Object)1), Helpers.mapEntry((Object)AnEnum.A, (Object)11)).collect(collector);
            ImmutableEnumMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToImmutableMapMerging() {
        Collector collector = Maps.toImmutableEnumMap(Map.Entry::getKey, Map.Entry::getValue, Integer::sum);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(ImmutableMap::entrySet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)ImmutableMap.of((Object)AnEnum.A, (Object)1, (Object)AnEnum.B, (Object)4, (Object)AnEnum.C, (Object)3), (Object[])new Map.Entry[]{Helpers.mapEntry((Object)AnEnum.A, (Object)1), Helpers.mapEntry((Object)AnEnum.B, (Object)2), Helpers.mapEntry((Object)AnEnum.C, (Object)3), Helpers.mapEntry((Object)AnEnum.B, (Object)2)});
    }

    public static class ImmutableEnumMapGenerator
    extends TestEnumMapGenerator {
        protected Map<AnEnum, String> create(Map.Entry<AnEnum, String>[] entries) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry<AnEnum, String> entry : entries) {
                map.put(entry.getKey(), entry.getValue());
            }
            return Maps.immutableEnumMap((Map)map);
        }
    }
}

