/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.LenientSerializableTester;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import com.google.common.collect.testing.google.UnmodifiableCollectionTests;
import com.google.common.testing.CollectorTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableSetMultimapTest
extends TestCase {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(ImmutableSetMultimapTest.class);
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new ImmutableSetMultimapGenerator()).named("ImmutableSetMultimap")).withFeatures(new Feature[]{MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY})).createTestSuite());
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new ImmutableSetMultimapCopyOfEntriesGenerator()).named("ImmutableSetMultimap.copyOf[Iterable<Entry>]")).withFeatures(new Feature[]{MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionSize.ANY})).createTestSuite());
        return suite;
    }

    public void testBuilder_withImmutableEntry() {
        ImmutableSetMultimap multimap = new ImmutableSetMultimap.Builder().put(Maps.immutableEntry((Object)"one", (Object)1)).build();
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1), (Object)multimap.get((Object)"one"));
    }

    public void testBuilder_withImmutableEntryAndNullContents() {
        ImmutableSetMultimap.Builder builder = new ImmutableSetMultimap.Builder();
        try {
            builder.put(Maps.immutableEntry((Object)"one", (Object)null));
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.put(Maps.immutableEntry((Object)null, (Object)1));
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilder_withMutableEntry() {
        ImmutableSetMultimap.Builder builder = new ImmutableSetMultimap.Builder();
        final StringHolder holder = new StringHolder();
        holder.string = "one";
        AbstractMapEntry<String, Integer> entry = new AbstractMapEntry<String, Integer>(){

            public String getKey() {
                return holder.string;
            }

            public Integer getValue() {
                return 1;
            }
        };
        builder.put((Map.Entry)entry);
        holder.string = "two";
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1), (Object)builder.build().get((Object)"one"));
    }

    public void testBuilderPutAllIterable() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll((Object)"foo", Arrays.asList(1, 2, 3));
        builder.putAll((Object)"bar", Arrays.asList(4, 5));
        builder.putAll((Object)"foo", Arrays.asList(6, 7));
        ImmutableSetMultimap multimap = builder.build();
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)6, (Object)7), (Object)multimap.get((Object)"foo"));
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)4, (Object)5), (Object)multimap.get((Object)"bar"));
        ImmutableSetMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutAllVarargs() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 2, 3});
        builder.putAll((Object)"bar", (Object[])new Integer[]{4, 5});
        builder.putAll((Object)"foo", (Object[])new Integer[]{6, 7});
        ImmutableSetMultimap multimap = builder.build();
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)6, (Object)7), (Object)multimap.get((Object)"foo"));
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)4, (Object)5), (Object)multimap.get((Object)"bar"));
        ImmutableSetMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutAllMultimap() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put((Object)"foo", (Object)1);
        toPut.put((Object)"bar", (Object)4);
        toPut.put((Object)"foo", (Object)2);
        toPut.put((Object)"foo", (Object)3);
        LinkedListMultimap moreToPut = LinkedListMultimap.create();
        moreToPut.put((Object)"foo", (Object)6);
        moreToPut.put((Object)"bar", (Object)5);
        moreToPut.put((Object)"foo", (Object)7);
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll((Multimap)toPut);
        builder.putAll((Multimap)moreToPut);
        ImmutableSetMultimap multimap = builder.build();
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3, (Object)6, (Object)7), (Object)multimap.get((Object)"foo"));
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSet.of((Object)4, (Object)5), (Object)multimap.get((Object)"bar"));
        ImmutableSetMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutAllWithDuplicates() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 2, 3});
        builder.putAll((Object)"bar", (Object[])new Integer[]{4, 5});
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 6, 7});
        ImmutableSetMultimap multimap = builder.build();
        ImmutableSetMultimapTest.assertEquals((int)7, (int)multimap.size());
    }

    public void testBuilderPutWithDuplicates() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll((Object)"foo", (Object[])new Integer[]{1, 2, 3});
        builder.putAll((Object)"bar", (Object[])new Integer[]{4, 5});
        builder.put((Object)"foo", (Object)1);
        ImmutableSetMultimap multimap = builder.build();
        ImmutableSetMultimapTest.assertEquals((int)5, (int)multimap.size());
    }

    public void testBuilderPutAllMultimapWithDuplicates() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put((Object)"foo", (Object)1);
        toPut.put((Object)"bar", (Object)4);
        toPut.put((Object)"foo", (Object)2);
        toPut.put((Object)"foo", (Object)1);
        toPut.put((Object)"bar", (Object)5);
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.putAll((Multimap)toPut);
        ImmutableSetMultimap multimap = builder.build();
        ImmutableSetMultimapTest.assertEquals((int)4, (int)multimap.size());
    }

    public void testBuilderPutNullKey() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put((Object)"foo", null);
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        try {
            builder.put(null, (Object)1);
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.putAll(null, Arrays.asList(1, 2, 3));
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.putAll(null, (Object[])new Integer[]{1, 2, 3});
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.putAll((Multimap)toPut);
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderPutNullValue() {
        LinkedListMultimap toPut = LinkedListMultimap.create();
        toPut.put(null, (Object)1);
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        try {
            builder.put((Object)"foo", null);
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.putAll((Object)"foo", Arrays.asList(1, null, 3));
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.putAll((Object)"foo", (Object[])new Integer[]{4, null, 6});
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.putAll((Multimap)toPut);
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilderOrderKeysBy() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)"b", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderKeysBy(Collections.reverseOrder());
        builder.put((Object)"c", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"b", (Object)6);
        ImmutableSetMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"d", "c", "b", "a"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{2, 4, 3, 6, 5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"b")).containsExactly(new Object[]{3, 6}).inOrder();
        ImmutableSetMultimapTest.assertFalse((boolean)(multimap.get((Object)"a") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertFalse((boolean)(multimap.get((Object)"x") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertFalse((boolean)(multimap.asMap().get((Object)"a") instanceof ImmutableSortedSet));
    }

    public void testBuilderOrderKeysByDuplicates() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)"bb", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderKeysBy((Comparator)new Ordering<String>(){

            public int compare(String left, String right) {
                return left.length() - right.length();
            }
        });
        builder.put((Object)"cc", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"bb", (Object)6);
        ImmutableSetMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"d", "a", "bb", "cc"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{2, 5, 2, 3, 6, 4}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"bb")).containsExactly(new Object[]{3, 6}).inOrder();
        ImmutableSetMultimapTest.assertFalse((boolean)(multimap.get((Object)"a") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertFalse((boolean)(multimap.get((Object)"x") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertFalse((boolean)(multimap.asMap().get((Object)"a") instanceof ImmutableSortedSet));
    }

    public void testBuilderOrderValuesBy() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)"b", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderValuesBy(Collections.reverseOrder());
        builder.put((Object)"c", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"b", (Object)6);
        ImmutableSetMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"b", "d", "a", "c"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{6, 3, 2, 5, 2, 4}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"b")).containsExactly(new Object[]{6, 3}).inOrder();
        ImmutableSetMultimapTest.assertTrue((boolean)(multimap.get((Object)"a") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertEquals(Collections.reverseOrder(), (Object)((ImmutableSortedSet)multimap.get((Object)"a")).comparator());
        ImmutableSetMultimapTest.assertTrue((boolean)(multimap.get((Object)"x") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertEquals(Collections.reverseOrder(), (Object)((ImmutableSortedSet)multimap.get((Object)"x")).comparator());
        ImmutableSetMultimapTest.assertTrue((boolean)(multimap.asMap().get((Object)"a") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertEquals(Collections.reverseOrder(), (Object)((ImmutableSortedSet)multimap.asMap().get((Object)"a")).comparator());
    }

    public void testBuilderOrderKeysAndValuesBy() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)"b", (Object)3);
        builder.put((Object)"d", (Object)2);
        builder.put((Object)"a", (Object)5);
        builder.orderKeysBy(Collections.reverseOrder());
        builder.orderValuesBy(Collections.reverseOrder());
        builder.put((Object)"c", (Object)4);
        builder.put((Object)"a", (Object)2);
        builder.put((Object)"b", (Object)6);
        ImmutableSetMultimap multimap = builder.build();
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"d", "c", "b", "a"}).inOrder();
        Truth.assertThat((Iterable)multimap.values()).containsExactly(new Object[]{2, 4, 6, 3, 5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{5, 2}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"b")).containsExactly(new Object[]{6, 3}).inOrder();
        ImmutableSetMultimapTest.assertTrue((boolean)(multimap.get((Object)"a") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertEquals(Collections.reverseOrder(), (Object)((ImmutableSortedSet)multimap.get((Object)"a")).comparator());
        ImmutableSetMultimapTest.assertTrue((boolean)(multimap.get((Object)"x") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertEquals(Collections.reverseOrder(), (Object)((ImmutableSortedSet)multimap.get((Object)"x")).comparator());
        ImmutableSetMultimapTest.assertTrue((boolean)(multimap.asMap().get((Object)"a") instanceof ImmutableSortedSet));
        ImmutableSetMultimapTest.assertEquals(Collections.reverseOrder(), (Object)((ImmutableSortedSet)multimap.asMap().get((Object)"a")).comparator());
    }

    public void testCopyOf() {
        HashMultimap input = HashMultimap.create();
        input.put((Object)"foo", (Object)1);
        input.put((Object)"bar", (Object)2);
        input.put((Object)"foo", (Object)3);
        ImmutableSetMultimap multimap = ImmutableSetMultimap.copyOf((Multimap)input);
        ImmutableSetMultimapTest.assertEquals((Object)multimap, (Object)input);
        ImmutableSetMultimapTest.assertEquals((Object)input, (Object)multimap);
    }

    public void testCopyOfWithDuplicates() {
        ArrayListMultimap input = ArrayListMultimap.create();
        input.put((Object)"foo", (Object)1);
        input.put((Object)"bar", (Object)2);
        input.put((Object)"foo", (Object)3);
        input.put((Object)"foo", (Object)1);
        ImmutableSetMultimap copy = ImmutableSetMultimap.copyOf((Multimap)input);
        ImmutableSetMultimapTest.assertEquals((int)3, (int)copy.size());
    }

    public void testCopyOfEmpty() {
        HashMultimap input = HashMultimap.create();
        ImmutableSetMultimap multimap = ImmutableSetMultimap.copyOf((Multimap)input);
        ImmutableSetMultimapTest.assertEquals((Object)multimap, (Object)input);
        ImmutableSetMultimapTest.assertEquals((Object)input, (Object)multimap);
    }

    public void testCopyOfImmutableSetMultimap() {
        ImmutableSetMultimap<String, Integer> multimap = this.createMultimap();
        ImmutableSetMultimapTest.assertSame(multimap, (Object)ImmutableSetMultimap.copyOf(multimap));
    }

    public void testCopyOfNullKey() {
        HashMultimap input = HashMultimap.create();
        input.put(null, (Object)1);
        try {
            ImmutableSetMultimap.copyOf((Multimap)input);
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testCopyOfNullValue() {
        HashMultimap input = HashMultimap.create();
        input.putAll((Object)"foo", Arrays.asList(1, null, 3));
        try {
            ImmutableSetMultimap.copyOf((Multimap)input);
            ImmutableSetMultimapTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableSetMultimap() {
        Collector collector = ImmutableSetMultimap.toImmutableSetMultimap(Map.Entry::getKey, Map.Entry::getValue);
        BiPredicate equivalence = Equivalence.equals().onResultOf(mm -> ImmutableListMultimap.copyOf((Multimap)mm).asMap().entrySet().asList()).and((BiPredicate)Equivalence.equals());
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)ImmutableSetMultimap.of(), (Object[])new Map.Entry[0]).expectCollects((Object)ImmutableSetMultimap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"a", (Object)3, (Object)"c", (Object)4), (Object[])new Map.Entry[]{Helpers.mapEntry((Object)"a", (Object)1), Helpers.mapEntry((Object)"b", (Object)2), Helpers.mapEntry((Object)"a", (Object)3), Helpers.mapEntry((Object)"c", (Object)4)});
    }

    public void testFlatteningToImmutableSetMultimap() {
        Collector collector = ImmutableSetMultimap.flatteningToImmutableSetMultimap(str -> Character.valueOf(str.charAt(0)), str -> str.substring(1).chars().mapToObj(c -> Character.valueOf((char)c)));
        BiPredicate equivalence = Equivalence.equals().onResultOf(mm -> ImmutableList.copyOf(mm.asMap().entrySet())).and((BiPredicate)Equivalence.equals());
        ImmutableSetMultimap empty = ImmutableSetMultimap.of();
        ImmutableSetMultimap filled = ImmutableSetMultimap.builder().putAll((Object)Character.valueOf('b'), Arrays.asList(Character.valueOf('a'), Character.valueOf('n'), Character.valueOf('a'), Character.valueOf('n'), Character.valueOf('a'))).putAll((Object)Character.valueOf('a'), Arrays.asList(Character.valueOf('p'), Character.valueOf('p'), Character.valueOf('l'), Character.valueOf('e'))).putAll((Object)Character.valueOf('c'), Arrays.asList(Character.valueOf('a'), Character.valueOf('r'), Character.valueOf('r'), Character.valueOf('o'), Character.valueOf('t'))).putAll((Object)Character.valueOf('a'), Arrays.asList(Character.valueOf('s'), Character.valueOf('p'), Character.valueOf('a'), Character.valueOf('r'), Character.valueOf('a'), Character.valueOf('g'), Character.valueOf('u'), Character.valueOf('s'))).putAll((Object)Character.valueOf('c'), Arrays.asList(Character.valueOf('h'), Character.valueOf('e'), Character.valueOf('r'), Character.valueOf('r'), Character.valueOf('y'))).build();
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)empty, (Object[])new String[0]).expectCollects((Object)filled, (Object[])new String[]{"banana", "apple", "carrot", "asparagus", "cherry"});
    }

    public void testEmptyMultimapReads() {
        ImmutableSetMultimap multimap = ImmutableSetMultimap.of();
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"foo"));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsValue((Object)1));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"foo", (Object)1));
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.entries().isEmpty());
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.equals((Object)HashMultimap.create()));
        ImmutableSetMultimapTest.assertEquals(Collections.emptySet(), (Object)multimap.get((Object)"foo"));
        ImmutableSetMultimapTest.assertEquals((int)0, (int)multimap.hashCode());
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.isEmpty());
        ImmutableSetMultimapTest.assertEquals((Object)HashMultiset.create(), (Object)multimap.keys());
        ImmutableSetMultimapTest.assertEquals(Collections.emptySet(), (Object)multimap.keySet());
        ImmutableSetMultimapTest.assertEquals((int)0, (int)multimap.size());
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.values().isEmpty());
        ImmutableSetMultimapTest.assertEquals((String)"{}", (String)multimap.toString());
    }

    public void testEmptyMultimapWrites() {
        ImmutableSetMultimap multimap = ImmutableSetMultimap.of();
        UnmodifiableCollectionTests.assertMultimapIsUnmodifiable((Multimap)multimap, (Object)"foo", (Object)1);
    }

    public void testMultimapReads() {
        ImmutableSetMultimap<String, Integer> multimap = this.createMultimap();
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.containsKey((Object)"foo"));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"cat"));
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.containsValue((Object)1));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsValue((Object)5));
        ImmutableSetMultimapTest.assertTrue((boolean)multimap.containsEntry((Object)"foo", (Object)1));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"cat", (Object)1));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.containsEntry((Object)"foo", (Object)5));
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.entries().isEmpty());
        ImmutableSetMultimapTest.assertEquals((int)3, (int)multimap.size());
        ImmutableSetMultimapTest.assertFalse((boolean)multimap.isEmpty());
        ImmutableSetMultimapTest.assertEquals((String)"{foo=[1, 3], bar=[2]}", (String)multimap.toString());
    }

    public void testMultimapWrites() {
        ImmutableSetMultimap<String, Integer> multimap = this.createMultimap();
        UnmodifiableCollectionTests.assertMultimapIsUnmodifiable(multimap, (Object)"bar", (Object)2);
    }

    public void testMultimapEquals() {
        ImmutableSetMultimap<String, Integer> multimap = this.createMultimap();
        HashMultimap hashMultimap = HashMultimap.create();
        hashMultimap.putAll((Object)"foo", Arrays.asList(1, 3));
        hashMultimap.put((Object)"bar", (Object)2);
        new EqualsTester().addEqualityGroup(new Object[]{multimap, this.createMultimap(), hashMultimap, ImmutableSetMultimap.builder().put((Object)"bar", (Object)2).put((Object)"foo", (Object)1).put((Object)"foo", (Object)3).build(), ImmutableSetMultimap.builder().put((Object)"bar", (Object)2).put((Object)"foo", (Object)3).put((Object)"foo", (Object)1).build()}).addEqualityGroup(new Object[]{ImmutableSetMultimap.builder().put((Object)"foo", (Object)2).put((Object)"foo", (Object)3).put((Object)"foo", (Object)1).build()}).addEqualityGroup(new Object[]{ImmutableSetMultimap.builder().put((Object)"bar", (Object)2).put((Object)"foo", (Object)3).build()}).testEquals();
    }

    public void testOf() {
        ImmutableSetMultimapTest.assertMultimapEquals(ImmutableSetMultimap.of((Object)"one", (Object)1), new Object[]{"one", 1});
        ImmutableSetMultimapTest.assertMultimapEquals(ImmutableSetMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2), new Object[]{"one", 1, "two", 2});
        ImmutableSetMultimapTest.assertMultimapEquals(ImmutableSetMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3), new Object[]{"one", 1, "two", 2, "three", 3});
        ImmutableSetMultimapTest.assertMultimapEquals(ImmutableSetMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4});
        ImmutableSetMultimapTest.assertMultimapEquals(ImmutableSetMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2, (Object)"three", (Object)3, (Object)"four", (Object)4, (Object)"five", (Object)5), new Object[]{"one", 1, "two", 2, "three", 3, "four", 4, "five", 5});
    }

    public void testInverse() {
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSetMultimap.of(), (Object)ImmutableSetMultimap.of().inverse());
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSetMultimap.of((Object)1, (Object)"one"), (Object)ImmutableSetMultimap.of((Object)"one", (Object)1).inverse());
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSetMultimap.of((Object)1, (Object)"one", (Object)2, (Object)"two"), (Object)ImmutableSetMultimap.of((Object)"one", (Object)1, (Object)"two", (Object)2).inverse());
        ImmutableSetMultimapTest.assertEquals((Object)ImmutableSetMultimap.of((Object)Character.valueOf('o'), (Object)"of", (Object)Character.valueOf('f'), (Object)"of", (Object)Character.valueOf('t'), (Object)"to", (Object)Character.valueOf('o'), (Object)"to"), (Object)ImmutableSetMultimap.of((Object)"of", (Object)Character.valueOf('o'), (Object)"of", (Object)Character.valueOf('f'), (Object)"to", (Object)Character.valueOf('t'), (Object)"to", (Object)Character.valueOf('o')).inverse());
    }

    public void testInverseMinimizesWork() {
        ImmutableSetMultimap multimap = ImmutableSetMultimap.of((Object)"of", (Object)Character.valueOf('o'), (Object)"of", (Object)Character.valueOf('f'), (Object)"to", (Object)Character.valueOf('t'), (Object)"to", (Object)Character.valueOf('o'));
        ImmutableSetMultimapTest.assertSame((Object)multimap.inverse(), (Object)multimap.inverse());
        ImmutableSetMultimapTest.assertSame((Object)multimap, (Object)multimap.inverse().inverse());
    }

    private static <K, V> void assertMultimapEquals(Multimap<K, V> multimap, Object ... alternatingKeysAndValues) {
        ImmutableSetMultimapTest.assertEquals((int)multimap.size(), (int)(alternatingKeysAndValues.length / 2));
        int i = 0;
        for (Map.Entry entry : multimap.entries()) {
            ImmutableSetMultimapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getKey());
            ImmutableSetMultimapTest.assertEquals((Object)alternatingKeysAndValues[i++], entry.getValue());
        }
    }

    @GwtIncompatible
    public void testSerialization() {
        ImmutableSetMultimap<String, Integer> multimap = this.createMultimap();
        SerializableTester.reserializeAndAssert(multimap);
        ImmutableSetMultimapTest.assertEquals((int)multimap.size(), (int)((Multimap)SerializableTester.reserialize(multimap)).size());
        SerializableTester.reserializeAndAssert((Object)multimap.get((Object)"foo"));
        LenientSerializableTester.reserializeAndAssertLenient(multimap.keySet());
        LenientSerializableTester.reserializeAndAssertLenient(multimap.keys());
        SerializableTester.reserializeAndAssert((Object)multimap.asMap());
        Collection valuesCopy = (Collection)SerializableTester.reserialize((Object)multimap.values());
        ImmutableSetMultimapTest.assertEquals((Object)HashMultiset.create((Iterable)multimap.values()), (Object)HashMultiset.create((Iterable)valuesCopy));
    }

    @GwtIncompatible
    public void testEmptySerialization() {
        ImmutableSetMultimap multimap = ImmutableSetMultimap.of();
        ImmutableSetMultimapTest.assertSame((Object)multimap, (Object)SerializableTester.reserialize((Object)multimap));
    }

    @GwtIncompatible
    public void testSortedSerialization() {
        ImmutableSetMultimap multimap = new ImmutableSetMultimap.Builder().orderKeysBy((Comparator)Ordering.natural().reverse()).orderValuesBy((Comparator)Ordering.usingToString()).put((Object)"a", (Object)2).put((Object)"a", (Object)10).put((Object)"b", (Object)1).build();
        multimap = (Multimap)SerializableTester.reserialize((Object)multimap);
        Truth.assertThat((Iterable)multimap.keySet()).containsExactly(new Object[]{"b", "a"}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"a")).containsExactly(new Object[]{10, 2}).inOrder();
        ImmutableSetMultimapTest.assertEquals((Object)Ordering.usingToString(), (Object)((ImmutableSortedSet)multimap.get((Object)"a")).comparator());
        ImmutableSetMultimapTest.assertEquals((Object)Ordering.usingToString(), (Object)((ImmutableSortedSet)multimap.get((Object)"z")).comparator());
    }

    private ImmutableSetMultimap<String, Integer> createMultimap() {
        return ImmutableSetMultimap.builder().put((Object)"foo", (Object)1).put((Object)"bar", (Object)2).put((Object)"foo", (Object)3).build();
    }

    private static class StringHolder {
        String string;

        private StringHolder() {
        }
    }

    private static final class ImmutableSetMultimapCopyOfEntriesGenerator
    extends TestStringSetMultimapGenerator {
        private ImmutableSetMultimapCopyOfEntriesGenerator() {
        }

        protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
            return ImmutableSetMultimap.copyOf(Arrays.asList(entries));
        }
    }

    private static final class ImmutableSetMultimapGenerator
    extends TestStringSetMultimapGenerator {
        private ImmutableSetMultimapGenerator() {
        }

        protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
            ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
            for (Map.Entry<String, String> entry : entries) {
                builder.put((Object)entry.getKey(), (Object)entry.getValue());
            }
            return builder.build();
        }
    }
}

