/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.collect.AbstractImmutableSetTest;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.testing.ListTestSuiteBuilder;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestListGenerator;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.SetGenerators;
import com.google.common.testing.CollectorTester;
import com.google.common.testing.EqualsTester;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ImmutableSetTest
extends AbstractImmutableSetTest {
    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetCopyOfGenerator()).named(ImmutableSetTest.class.getName())).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetUnsizedBuilderGenerator()).named(ImmutableSetTest.class.getName() + ", with unsized builder")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetSizedBuilderGenerator()).named(ImmutableSetTest.class.getName() + ", with exactly sized builder")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetTooBigBuilderGenerator()).named(ImmutableSetTest.class.getName() + ", with oversized builder")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetTooSmallBuilderGenerator()).named(ImmutableSetTest.class.getName() + ", with undersized builder")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.ImmutableSetWithBadHashesGenerator()).named(ImmutableSetTest.class.getName() + ", with bad hashes")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new SetGenerators.DegeneratedImmutableSetGenerator()).named(ImmutableSetTest.class.getName() + ", degenerate")).withFeatures(new Feature[]{CollectionSize.ONE, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTest((Test)((ListTestSuiteBuilder)((ListTestSuiteBuilder)ListTestSuiteBuilder.using((TestListGenerator)new SetGenerators.ImmutableSetAsListGenerator()).named("ImmutableSet.asList")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.REJECTS_DUPLICATES_AT_CREATION, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).createTestSuite());
        suite.addTestSuite(ImmutableSetTest.class);
        return suite;
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of() {
        return ImmutableSet.of();
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of(E e) {
        return ImmutableSet.of(e);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of(E e1, E e2) {
        return ImmutableSet.of(e1, e2);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of(E e1, E e2, E e3) {
        return ImmutableSet.of(e1, e2, e3);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of(E e1, E e2, E e3, E e4) {
        return ImmutableSet.of(e1, e2, e3, e4);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of(E e1, E e2, E e3, E e4, E e5) {
        return ImmutableSet.of(e1, e2, e3, e4, e5);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... rest) {
        return ImmutableSet.of(e1, e2, e3, e4, e5, e6, (Object[])rest);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> copyOf(E[] elements) {
        return ImmutableSet.copyOf((Object[])elements);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> copyOf(Collection<? extends E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> copyOf(Iterable<? extends E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    @Override
    protected <E extends Comparable<? super E>> Set<E> copyOf(Iterator<? extends E> elements) {
        return ImmutableSet.copyOf(elements);
    }

    public void testCreation_allDuplicates() {
        ImmutableSet set = ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new String[]{"a", "a"}));
        ImmutableSetTest.assertTrue((boolean)(set instanceof SingletonImmutableSet));
        ImmutableSetTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a"}), (Object)Lists.newArrayList((Iterable)set));
    }

    public void testCreation_oneDuplicate() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e", (Object)"f", (Object[])new String[]{"g", "h", "i", "j", "k", "l", "m", "a"});
        ImmutableSetTest.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m"}), (Object)Lists.newArrayList((Iterable)set));
    }

    public void testCreation_manyDuplicates() {
        ImmutableSet set = ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"c", (Object)"c", (Object)"c", (Object[])new String[]{"b", "b", "a", "a", "c", "c", "c", "a"});
        Truth.assertThat((Iterable)set).containsExactly(new Object[]{"a", "b", "c"}).inOrder();
    }

    @GwtIncompatible(value="Builder impl")
    public void testBuilderForceCopy() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        builder.add((Object)-1);
        Object[] prevArray = null;
        for (int i = 0; i < 10; ++i) {
            builder.add((Object)i);
            ImmutableSetTest.assertNotSame((Object)builder.contents, prevArray);
            prevArray = builder.contents;
            ImmutableSet immutableSet = builder.build();
        }
    }

    @GwtIncompatible(value="Builder impl")
    public void testPresizedBuilderDedups() {
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)4);
        builder.add((Object)"a");
        ImmutableSetTest.assertEquals((int)1, (int)builder.size);
        builder.add((Object)"a");
        ImmutableSetTest.assertEquals((int)1, (int)builder.size);
        builder.add((Object[])new String[]{"b", "c", "d"});
        ImmutableSetTest.assertEquals((int)4, (int)builder.size);
        Object[] table = builder.hashTable;
        ImmutableSetTest.assertNotNull((Object)table);
        ImmutableSetTest.assertSame((Object)table, (Object)((RegularImmutableSet)builder.build()).table);
    }

    @GwtIncompatible(value="Builder impl")
    public void testPresizedBuilderForceCopy() {
        for (int expectedSize = 1; expectedSize < 4; ++expectedSize) {
            ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)expectedSize);
            builder.add((Object)-1);
            Object[] prevArray = null;
            for (int i = 0; i < 10; ++i) {
                ImmutableSet prevBuilt = builder.build();
                builder.add((Object)i);
                ImmutableSetTest.assertFalse((boolean)prevBuilt.contains((Object)i));
                ImmutableSetTest.assertNotSame((Object)builder.contents, prevArray);
                prevArray = builder.contents;
            }
        }
    }

    public void testCreation_arrayOfArray() {
        String[] array = new String[]{"a"};
        ImmutableSet set = ImmutableSet.of((Object)array);
        ImmutableSetTest.assertEquals(Collections.singleton(array), (Object)set);
    }

    @GwtIncompatible
    public void testChooseTableSize() {
        ImmutableSetTest.assertEquals((int)8, (int)ImmutableSet.chooseTableSize((int)3));
        ImmutableSetTest.assertEquals((int)8, (int)ImmutableSet.chooseTableSize((int)4));
        ImmutableSetTest.assertEquals((int)0x20000000, (int)ImmutableSet.chooseTableSize((int)0x10000000));
        ImmutableSetTest.assertEquals((int)0x20000000, (int)ImmutableSet.chooseTableSize((int)0x13333333));
        ImmutableSetTest.assertEquals((int)0x40000000, (int)ImmutableSet.chooseTableSize((int)0x20000000));
        ImmutableSetTest.assertEquals((int)0x40000000, (int)ImmutableSet.chooseTableSize((int)0x3FFFFFFF));
        try {
            ImmutableSet.chooseTableSize((int)0x40000000);
            ImmutableSetTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @GwtIncompatible
    public void testResizeTable() {
        this.verifyTableSize(100, 2, 4);
        this.verifyTableSize(100, 5, 8);
        this.verifyTableSize(100, 33, 64);
        this.verifyTableSize(17, 17, 32);
        this.verifyTableSize(17, 16, 32);
        this.verifyTableSize(17, 15, 32);
    }

    @GwtIncompatible
    private void verifyTableSize(int inputSize, int setSize, int tableSize) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (int i = 0; i < inputSize; ++i) {
            builder.add((Object)(i % setSize));
        }
        ImmutableSet set = builder.build();
        ImmutableSetTest.assertTrue((boolean)(set instanceof RegularImmutableSet));
        ImmutableSetTest.assertEquals((String)("Input size " + inputSize + " and set size " + setSize), (int)tableSize, (int)((RegularImmutableSet)set).table.length);
    }

    public void testCopyOf_copiesImmutableSortedSet() {
        ImmutableSortedSet sortedSet = ImmutableSortedSet.of((Comparable)((Object)"a"));
        ImmutableSet copy = ImmutableSet.copyOf((Collection)sortedSet);
        ImmutableSetTest.assertNotSame((Object)sortedSet, (Object)copy);
    }

    public void testToImmutableSet() {
        Collector collector = ImmutableSet.toImmutableSet();
        Equivalence equivalence = Equivalence.equals().onResultOf(ImmutableSet::asList);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)ImmutableSet.of((Object)"a", (Object)"b", (Object)"c", (Object)"d"), (Object[])new String[]{"a", "b", "a", "c", "b", "b", "d"});
    }

    public void testToImmutableSet_duplicates() {
        class TypeWithDuplicates {
            final int a;
            final int b;

            TypeWithDuplicates(int a, int b) {
                this.a = a;
                this.b = b;
            }

            public int hashCode() {
                return this.a;
            }

            public boolean equals(Object obj) {
                return obj instanceof TypeWithDuplicates && ((TypeWithDuplicates)obj).a == this.a;
            }

            public boolean fullEquals(TypeWithDuplicates other) {
                return other != null && this.a == other.a && this.b == other.b;
            }
        }
        Collector collector = ImmutableSet.toImmutableSet();
        BiPredicate<ImmutableSet, ImmutableSet> equivalence = (set1, set2) -> {
            if (!set1.equals(set2)) {
                return false;
            }
            for (int i = 0; i < set1.size(); ++i) {
                if (((TypeWithDuplicates)set1.asList().get(i)).fullEquals((TypeWithDuplicates)set2.asList().get(i))) continue;
                return false;
            }
            return true;
        };
        TypeWithDuplicates a = new TypeWithDuplicates(1, 1);
        TypeWithDuplicates b1 = new TypeWithDuplicates(2, 1);
        TypeWithDuplicates b2 = new TypeWithDuplicates(2, 2);
        TypeWithDuplicates c = new TypeWithDuplicates(3, 1);
        CollectorTester.of((Collector)collector, equivalence).expectCollects((Object)ImmutableSet.of((Object)a, (Object)b1, (Object)c), (Object[])new TypeWithDuplicates[]{a, b1, c, b2});
    }

    @GwtIncompatible
    public void testCopyOf_threadSafe() {
        this.verifyThreadSafe();
    }

    @Override
    <E extends Comparable<E>> ImmutableSet.Builder<E> builder() {
        return ImmutableSet.builder();
    }

    @Override
    int getComplexBuilderSetLastElement() {
        return 49151;
    }

    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{ImmutableSet.of(), ImmutableSet.of()}).addEqualityGroup(new Object[]{ImmutableSet.of((Object)1), ImmutableSet.of((Object)1), ImmutableSet.of((Object)1, (Object)1)}).addEqualityGroup(new Object[]{ImmutableSet.of((Object)1, (Object)2, (Object)1), ImmutableSet.of((Object)2, (Object)1, (Object)1)}).testEquals();
    }
}

