/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.base.MoreObjects;
import com.google.common.collect.AbstractTableReadTest;
import com.google.common.collect.AndroidIncompatible;
import com.google.common.collect.DenseImmutableTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Ordering;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.collect.TreeBasedTable;
import com.google.common.testing.CollectorTester;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Comparator;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import java.util.stream.Stream;

@GwtCompatible(emulated=true)
public class ImmutableTableTest
extends AbstractTableReadTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (int i = 0; i < data.length; i += 3) {
            builder.put((Object)((String)data[i]), (Object)((Integer)data[i + 1]), (Object)((Character)data[i + 2]));
        }
        return builder.build();
    }

    public void testToImmutableTable() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(ImmutableTable::cellSet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)new ImmutableTable.Builder().put((Object)"one", (Object)"uno", (Object)1).put((Object)"two", (Object)"dos", (Object)2).put((Object)"three", (Object)"tres", (Object)3).build(), (Object[])new Table.Cell[]{Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"two", (Object)"dos", (Object)2), Tables.immutableCell((Object)"three", (Object)"tres", (Object)3)});
    }

    public void testToImmutableTableConflict() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"one", (Object)"uno", (Object)2)).collect(collector);
            ImmutableTableTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToImmutableTableNullRowKey() {
        Collector collector = ImmutableTable.toImmutableTable(t -> null, Table.Cell::getColumnKey, Table.Cell::getValue);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableTableNullColumnKey() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, t -> null, Table.Cell::getValue);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableTableNullValue() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, t -> null);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"one", (Object)"uno", (Object)null)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableTableMerging() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, Integer::sum);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(ImmutableTable::cellSet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)new ImmutableTable.Builder().put((Object)"one", (Object)"uno", (Object)1).put((Object)"two", (Object)"dos", (Object)6).put((Object)"three", (Object)"tres", (Object)3).build(), (Object[])new Table.Cell[]{Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"two", (Object)"dos", (Object)2), Tables.immutableCell((Object)"three", (Object)"tres", (Object)3), Tables.immutableCell((Object)"two", (Object)"dos", (Object)4)});
    }

    public void testToImmutableTableMergingNullRowKey() {
        Collector collector = ImmutableTable.toImmutableTable(t -> null, Table.Cell::getColumnKey, Table.Cell::getValue, Integer::sum);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableTableMergingNullColumnKey() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, t -> null, Table.Cell::getValue, Integer::sum);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableTableMergingNullValue() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, t -> null, Integer::sum);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, (i, j) -> (Integer)MoreObjects.firstNonNull((Object)i, (Object)0) + (Integer)MoreObjects.firstNonNull((Object)j, (Object)0));
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"one", (Object)"uno", (Object)null)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToImmutableTableMergingNullMerge() {
        Collector collector = ImmutableTable.toImmutableTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, (v1, v2) -> null);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"one", (Object)"uno", (Object)2)).collect(collector);
            ImmutableTableTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilder() {
        ImmutableTable.Builder builder = new ImmutableTable.Builder();
        ImmutableTableTest.assertEquals((Object)ImmutableTable.of(), (Object)builder.build());
        ImmutableTableTest.assertEquals((Object)ImmutableTable.of((Object)Character.valueOf('a'), (Object)1, (Object)"foo"), (Object)builder.put((Object)Character.valueOf('a'), (Object)1, (Object)"foo").build());
        HashBasedTable expectedTable = HashBasedTable.create();
        expectedTable.put((Object)Character.valueOf('a'), (Object)1, (Object)"foo");
        expectedTable.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        expectedTable.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        HashBasedTable otherTable = HashBasedTable.create();
        otherTable.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        otherTable.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTableTest.assertEquals((Object)expectedTable, (Object)builder.putAll((Table)otherTable).build());
    }

    public void testBuilder_withImmutableCell() {
        ImmutableTable.Builder builder = new ImmutableTable.Builder();
        ImmutableTableTest.assertEquals((Object)ImmutableTable.of((Object)Character.valueOf('a'), (Object)1, (Object)"foo"), (Object)builder.put(Tables.immutableCell((Object)Character.valueOf('a'), (Object)1, (Object)"foo")).build());
    }

    public void testBuilder_withImmutableCellAndNullContents() {
        ImmutableTable.Builder builder = new ImmutableTable.Builder();
        try {
            builder.put(Tables.immutableCell((Object)null, (Object)1, (Object)"foo"));
            ImmutableTableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.put(Tables.immutableCell((Object)Character.valueOf('a'), (Object)null, (Object)"foo"));
            ImmutableTableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.put(Tables.immutableCell((Object)Character.valueOf('a'), (Object)1, (Object)null));
            ImmutableTableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBuilder_withMutableCell() {
        ImmutableTable.Builder builder = new ImmutableTable.Builder();
        final StringHolder holder = new StringHolder();
        holder.string = "foo";
        Tables.AbstractCell<Character, Integer, String> mutableCell = new Tables.AbstractCell<Character, Integer, String>(){

            public Character getRowKey() {
                return Character.valueOf('K');
            }

            public Integer getColumnKey() {
                return 42;
            }

            public String getValue() {
                return holder.string;
            }
        };
        builder.put((Table.Cell)mutableCell);
        holder.string = "bar";
        ImmutableTableTest.assertEquals((Object)ImmutableTable.of((Object)Character.valueOf('K'), (Object)42, (Object)"foo"), (Object)builder.build());
    }

    public void testBuilder_noDuplicates() {
        ImmutableTable.Builder builder = new ImmutableTable.Builder().put((Object)Character.valueOf('a'), (Object)1, (Object)"foo").put((Object)Character.valueOf('a'), (Object)1, (Object)"bar");
        try {
            builder.build();
            ImmutableTableTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testBuilder_noNulls() {
        ImmutableTable.Builder builder = new ImmutableTable.Builder();
        try {
            builder.put(null, (Object)1, (Object)"foo");
            ImmutableTableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.put((Object)Character.valueOf('a'), null, (Object)"foo");
            ImmutableTableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            builder.put((Object)Character.valueOf('a'), (Object)1, null);
            ImmutableTableTest.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private static <R, C, V> void validateTableCopies(Table<R, C, V> original) {
        ImmutableTable copy = ImmutableTable.copyOf(original);
        ImmutableTableTest.assertEquals(original, (Object)copy);
        ImmutableTableTest.validateViewOrdering(original, copy);
        ImmutableTable built = ImmutableTable.builder().putAll(original).build();
        ImmutableTableTest.assertEquals(original, (Object)built);
        ImmutableTableTest.validateViewOrdering(original, built);
    }

    private static <R, C, V> void validateViewOrdering(Table<R, C, V> original, Table<R, C, V> copy) {
        Truth.assertThat((Iterable)copy.cellSet()).containsExactlyElementsIn((Iterable)original.cellSet()).inOrder();
        Truth.assertThat((Iterable)copy.rowKeySet()).containsExactlyElementsIn((Iterable)original.rowKeySet()).inOrder();
        Truth.assertThat((Iterable)copy.values()).containsExactlyElementsIn((Iterable)original.values()).inOrder();
    }

    public void testCopyOf() {
        TreeBasedTable table = TreeBasedTable.create();
        ImmutableTableTest.validateTableCopies(table);
        table.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        ImmutableTableTest.validateTableCopies(table);
        table.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        table.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTableTest.validateTableCopies(table);
        Truth.assertThat(table.row((Object)Character.valueOf('b')).keySet()).containsExactly(new Object[]{1, 2}).inOrder();
        Truth.assertThat((Iterable)ImmutableTable.copyOf((Table)table).row((Object)Character.valueOf('b')).keySet()).containsExactly(new Object[]{2, 1}).inOrder();
    }

    public void testCopyOfSparse() {
        TreeBasedTable table = TreeBasedTable.create();
        table.put((Object)Character.valueOf('x'), (Object)2, (Object)"foo");
        table.put((Object)Character.valueOf('r'), (Object)1, (Object)"bar");
        table.put((Object)Character.valueOf('c'), (Object)3, (Object)"baz");
        table.put((Object)Character.valueOf('b'), (Object)7, (Object)"cat");
        table.put((Object)Character.valueOf('e'), (Object)5, (Object)"dog");
        table.put((Object)Character.valueOf('c'), (Object)0, (Object)"axe");
        table.put((Object)Character.valueOf('e'), (Object)3, (Object)"tub");
        table.put((Object)Character.valueOf('r'), (Object)4, (Object)"foo");
        table.put((Object)Character.valueOf('x'), (Object)5, (Object)"bar");
        ImmutableTableTest.validateTableCopies(table);
    }

    public void testCopyOfDense() {
        TreeBasedTable table = TreeBasedTable.create();
        table.put((Object)Character.valueOf('c'), (Object)3, (Object)"foo");
        table.put((Object)Character.valueOf('c'), (Object)2, (Object)"bar");
        table.put((Object)Character.valueOf('c'), (Object)1, (Object)"baz");
        table.put((Object)Character.valueOf('b'), (Object)3, (Object)"cat");
        table.put((Object)Character.valueOf('b'), (Object)1, (Object)"dog");
        table.put((Object)Character.valueOf('a'), (Object)3, (Object)"foo");
        table.put((Object)Character.valueOf('a'), (Object)2, (Object)"bar");
        table.put((Object)Character.valueOf('a'), (Object)1, (Object)"baz");
        ImmutableTableTest.validateTableCopies(table);
    }

    public void testBuilder_orderRowsAndColumnsBy_putAll() {
        HashBasedTable table = HashBasedTable.create();
        table.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        table.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        table.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTable.Builder builder = ImmutableTable.builder();
        ImmutableTable copy = builder.orderRowsBy((Comparator)Ordering.natural()).orderColumnsBy((Comparator)Ordering.natural()).putAll((Table)table).build();
        Truth.assertThat((Iterable)copy.rowKeySet()).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('b')}).inOrder();
        Truth.assertThat((Iterable)copy.columnKeySet()).containsExactly(new Object[]{1, 2}).inOrder();
        Truth.assertThat((Iterable)copy.values()).containsExactly(new Object[]{"baz", "bar", "foo"}).inOrder();
        Truth.assertThat(copy.row((Object)Character.valueOf('b')).keySet()).containsExactly(new Object[]{1, 2}).inOrder();
    }

    public void testBuilder_orderRowsAndColumnsBy_sparse() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('x'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('r'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"baz");
        builder.put((Object)Character.valueOf('b'), (Object)7, (Object)"cat");
        builder.put((Object)Character.valueOf('e'), (Object)5, (Object)"dog");
        builder.put((Object)Character.valueOf('c'), (Object)0, (Object)"axe");
        builder.put((Object)Character.valueOf('e'), (Object)3, (Object)"tub");
        builder.put((Object)Character.valueOf('r'), (Object)4, (Object)"foo");
        builder.put((Object)Character.valueOf('x'), (Object)5, (Object)"bar");
        ImmutableTable table = builder.build();
        Truth.assertThat((Iterable)table.rowKeySet()).containsExactly(new Object[]{Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('e'), Character.valueOf('r'), Character.valueOf('x')}).inOrder();
        Truth.assertThat((Iterable)table.columnKeySet()).containsExactly(new Object[]{0, 1, 2, 3, 4, 5, 7}).inOrder();
        Truth.assertThat((Iterable)table.values()).containsExactly(new Object[]{"cat", "axe", "baz", "tub", "dog", "bar", "foo", "foo", "bar"}).inOrder();
        Truth.assertThat(table.row((Object)Character.valueOf('c')).keySet()).containsExactly(new Object[]{0, 3}).inOrder();
        Truth.assertThat(table.column((Object)5).keySet()).containsExactly(new Object[]{Character.valueOf('e'), Character.valueOf('x')}).inOrder();
    }

    public void testBuilder_orderRowsAndColumnsBy_dense() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"foo");
        builder.put((Object)Character.valueOf('c'), (Object)2, (Object)"bar");
        builder.put((Object)Character.valueOf('c'), (Object)1, (Object)"baz");
        builder.put((Object)Character.valueOf('b'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"dog");
        builder.put((Object)Character.valueOf('a'), (Object)3, (Object)"foo");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)1, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Iterable)table.rowKeySet()).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).inOrder();
        Truth.assertThat((Iterable)table.columnKeySet()).containsExactly(new Object[]{1, 2, 3}).inOrder();
        Truth.assertThat((Iterable)table.values()).containsExactly(new Object[]{"baz", "bar", "foo", "dog", "cat", "baz", "bar", "foo"}).inOrder();
        Truth.assertThat(table.row((Object)Character.valueOf('c')).keySet()).containsExactly(new Object[]{1, 2, 3}).inOrder();
        Truth.assertThat(table.column((Object)1).keySet()).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).inOrder();
    }

    public void testBuilder_orderRowsBy_sparse() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('x'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('r'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"baz");
        builder.put((Object)Character.valueOf('b'), (Object)7, (Object)"cat");
        builder.put((Object)Character.valueOf('e'), (Object)5, (Object)"dog");
        builder.put((Object)Character.valueOf('c'), (Object)0, (Object)"axe");
        builder.put((Object)Character.valueOf('e'), (Object)3, (Object)"tub");
        builder.put((Object)Character.valueOf('r'), (Object)4, (Object)"foo");
        builder.put((Object)Character.valueOf('x'), (Object)5, (Object)"bar");
        ImmutableTable table = builder.build();
        Truth.assertThat((Iterable)table.rowKeySet()).containsExactly(new Object[]{Character.valueOf('b'), Character.valueOf('c'), Character.valueOf('e'), Character.valueOf('r'), Character.valueOf('x')}).inOrder();
        Truth.assertThat(table.column((Object)5).keySet()).containsExactly(new Object[]{Character.valueOf('e'), Character.valueOf('x')}).inOrder();
    }

    public void testBuilder_orderRowsBy_dense() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"foo");
        builder.put((Object)Character.valueOf('c'), (Object)2, (Object)"bar");
        builder.put((Object)Character.valueOf('c'), (Object)1, (Object)"baz");
        builder.put((Object)Character.valueOf('b'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"dog");
        builder.put((Object)Character.valueOf('a'), (Object)3, (Object)"foo");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)1, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Iterable)table.rowKeySet()).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).inOrder();
        Truth.assertThat(table.column((Object)1).keySet()).containsExactly(new Object[]{Character.valueOf('a'), Character.valueOf('b'), Character.valueOf('c')}).inOrder();
    }

    public void testBuilder_orderColumnsBy_sparse() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('x'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('r'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"baz");
        builder.put((Object)Character.valueOf('b'), (Object)7, (Object)"cat");
        builder.put((Object)Character.valueOf('e'), (Object)5, (Object)"dog");
        builder.put((Object)Character.valueOf('c'), (Object)0, (Object)"axe");
        builder.put((Object)Character.valueOf('e'), (Object)3, (Object)"tub");
        builder.put((Object)Character.valueOf('r'), (Object)4, (Object)"foo");
        builder.put((Object)Character.valueOf('x'), (Object)5, (Object)"bar");
        ImmutableTable table = builder.build();
        Truth.assertThat((Iterable)table.columnKeySet()).containsExactly(new Object[]{0, 1, 2, 3, 4, 5, 7}).inOrder();
        Truth.assertThat(table.row((Object)Character.valueOf('c')).keySet()).containsExactly(new Object[]{0, 3}).inOrder();
    }

    public void testBuilder_orderColumnsBy_dense() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"foo");
        builder.put((Object)Character.valueOf('c'), (Object)2, (Object)"bar");
        builder.put((Object)Character.valueOf('c'), (Object)1, (Object)"baz");
        builder.put((Object)Character.valueOf('b'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"dog");
        builder.put((Object)Character.valueOf('a'), (Object)3, (Object)"foo");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)1, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Iterable)table.columnKeySet()).containsExactly(new Object[]{1, 2, 3}).inOrder();
        Truth.assertThat(table.row((Object)Character.valueOf('c')).keySet()).containsExactly(new Object[]{1, 2, 3}).inOrder();
    }

    public void testSerialization_empty() {
        ImmutableTableTest.validateReserialization(ImmutableTable.of());
    }

    public void testSerialization_singleElement() {
        ImmutableTableTest.validateReserialization(ImmutableTable.of((Object)Character.valueOf('a'), (Object)2, (Object)"foo"));
    }

    public void testDenseSerialization_manualOrder() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(DenseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testDenseSerialization_rowOrder() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(DenseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testDenseSerialization_columnOrder() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(DenseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testDenseSerialization_bothOrders() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(DenseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testSparseSerialization_manualOrder() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('d'), (Object)4, (Object)"dog");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(SparseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testSparseSerialization_rowOrder() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('d'), (Object)4, (Object)"dog");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(SparseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testSparseSerialization_columnOrder() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('d'), (Object)4, (Object)"dog");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(SparseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    public void testSparseSerialization_bothOrders() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        builder.orderRowsBy((Comparator)Ordering.natural());
        builder.orderColumnsBy((Comparator)Ordering.natural());
        builder.put((Object)Character.valueOf('b'), (Object)2, (Object)"foo");
        builder.put((Object)Character.valueOf('b'), (Object)1, (Object)"bar");
        builder.put((Object)Character.valueOf('a'), (Object)2, (Object)"baz");
        builder.put((Object)Character.valueOf('c'), (Object)3, (Object)"cat");
        builder.put((Object)Character.valueOf('d'), (Object)4, (Object)"dog");
        ImmutableTable table = builder.build();
        Truth.assertThat((Table)table).isInstanceOf(SparseImmutableTable.class);
        ImmutableTableTest.validateReserialization(table);
    }

    private static <R, C, V> void validateReserialization(Table<R, C, V> original) {
        Table copy = (Table)SerializableTester.reserializeAndAssert(original);
        Truth.assertThat((Iterable)copy.cellSet()).containsExactlyElementsIn((Iterable)original.cellSet()).inOrder();
        Truth.assertThat((Iterable)copy.rowKeySet()).containsExactlyElementsIn((Iterable)original.rowKeySet()).inOrder();
        Truth.assertThat((Iterable)copy.columnKeySet()).containsExactlyElementsIn((Iterable)original.columnKeySet()).inOrder();
    }

    @GwtIncompatible
    @AndroidIncompatible
    public void testOverflowCondition() {
        ImmutableTable.Builder builder = ImmutableTable.builder();
        for (int i = 1; i < 65536; ++i) {
            builder.put((Object)i, (Object)0, (Object)"foo");
            builder.put((Object)0, (Object)i, (Object)"bar");
        }
        ImmutableTableTest.assertTrue((boolean)(builder.build() instanceof SparseImmutableTable));
    }

    private static class StringHolder {
        String string;

        private StringHolder() {
        }
    }
}

