/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.truth.BooleanSubject;
import com.google.common.truth.IntegerSubject;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class ListsImplTest
extends TestCase {
    private ListExample example;

    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)ListsImplTest.createExampleSuite(new ArrayListExample("ArrayList")));
        suite.addTest((Test)ListsImplTest.createExampleSuite(new LinkedListExample("LinkedList")));
        suite.addTest((Test)ListsImplTest.createExampleSuite(new ArraysAsListExample("Arrays.asList")));
        suite.addTest((Test)ListsImplTest.createExampleSuite(new ImmutableListExample("ImmutableList")));
        suite.addTest((Test)ListsImplTest.createExampleSuite(new CopyOnWriteListExample("CopyOnWriteArrayList")));
        suite.addTestSuite(ListsImplTest.class);
        return suite;
    }

    @GwtIncompatible
    private static TestSuite createExampleSuite(ListExample example) {
        TestSuite resultSuite = new TestSuite(ListsImplTest.class);
        Enumeration testEnum = resultSuite.tests();
        while (testEnum.hasMoreElements()) {
            ListsImplTest test = (ListsImplTest)((Object)testEnum.nextElement());
            test.example = example;
        }
        return resultSuite;
    }

    private ListExample getExample() {
        return this.example == null ? new ImmutableListExample("test") : this.example;
    }

    public String getName() {
        return this.example == null ? super.getName() : this.buildTestName();
    }

    private String buildTestName() {
        return super.getName() + ":" + this.example.getName();
    }

    public void testHashCodeImpl() {
        List<Integer> base = this.createList(Integer.class, 1, 2, 2);
        List<Integer> copy = this.createList(Integer.class, 1, 2, 2);
        List<Integer> outOfOrder = this.createList(Integer.class, 2, 2, 1);
        List<Integer> diffValue = this.createList(Integer.class, 1, 2, 4);
        List<Integer> diffLength = this.createList(Integer.class, 1, 2);
        List<Integer> empty = this.createList(Integer.class, new Integer[0]);
        Truth.assertThat((Integer)Lists.hashCodeImpl(base)).isEqualTo((Object)Lists.hashCodeImpl(copy));
        Truth.assertThat((Integer)Lists.hashCodeImpl(base)).isNotEqualTo((Object)Lists.hashCodeImpl(outOfOrder));
        Truth.assertThat((Integer)Lists.hashCodeImpl(base)).isNotEqualTo((Object)Lists.hashCodeImpl(diffValue));
        Truth.assertThat((Integer)Lists.hashCodeImpl(base)).isNotEqualTo((Object)Lists.hashCodeImpl(diffLength));
        Truth.assertThat((Integer)Lists.hashCodeImpl(base)).isNotEqualTo((Object)Lists.hashCodeImpl(empty));
    }

    public void testEqualsImpl() {
        List<Integer> base = this.createList(Integer.class, 1, 2, 2);
        List<Integer> copy = this.createList(Integer.class, 1, 2, 2);
        ImmutableList otherType = ImmutableList.of((Object)1, (Object)2, (Object)2);
        List<Integer> outOfOrder = this.createList(Integer.class, 2, 2, 1);
        List<Integer> diffValue = this.createList(Integer.class, 1, 2, 3);
        List<Integer> diffLength = this.createList(Integer.class, 1, 2);
        List<Integer> empty = this.createList(Integer.class, new Integer[0]);
        Truth.assertThat((Boolean)Lists.equalsImpl(base, copy)).isTrue();
        Truth.assertThat((Boolean)Lists.equalsImpl(base, (Object)otherType)).isTrue();
        List<Object> unEqualItems = Arrays.asList(outOfOrder, diffValue, diffLength, empty, null, new Object());
        for (Object other : unEqualItems) {
            ((BooleanSubject)Truth.assertThat((Boolean)Lists.equalsImpl(base, (Object)other)).named("%s", new Object[]{other})).isFalse();
        }
    }

    public void testAddAllImpl() {
        if (this.getExample().modifiability() != Modifiability.ALL) {
            return;
        }
        List<String> toTest = this.createList(String.class, new String[0]);
        ImmutableList toAdd = ImmutableList.of(Collections.singleton("A"), Collections.emptyList(), (Object)ImmutableList.of((Object)"A", (Object)"B", (Object)"C"), (Object)ImmutableList.of((Object)"D", (Object)"E"));
        ImmutableList indexes = ImmutableList.of((Object)0, (Object)0, (Object)1, (Object)3);
        ImmutableList expected = ImmutableList.of((Object)ImmutableList.of((Object)"A"), (Object)ImmutableList.of((Object)"A"), (Object)ImmutableList.of((Object)"A", (Object)"A", (Object)"B", (Object)"C"), (Object)ImmutableList.of((Object)"A", (Object)"A", (Object)"D", (Object)"E", (Object)"B", (Object)"C"));
        String format = "Adding %s at %s";
        for (int i = 0; i < toAdd.size(); ++i) {
            int index = (Integer)indexes.get(i);
            Iterable iterableToAdd = (Iterable)toAdd.get(i);
            boolean expectedChanged = iterableToAdd.iterator().hasNext();
            ((BooleanSubject)Truth.assertThat((Boolean)Lists.addAllImpl(toTest, (int)index, (Iterable)iterableToAdd)).named(format, new Object[]{iterableToAdd, index})).isEqualTo((Object)expectedChanged);
            ((IterableSubject)Truth.assertThat(toTest).named(format, new Object[]{iterableToAdd, index})).containsExactlyElementsIn((Iterable)expected.get(i));
        }
    }

    public void testIndexOfImpl_nonNull() {
        List<Integer> toTest = this.createList(Integer.class, 5, 2, -1, 2, 1, 10, 5);
        int[] expected = new int[]{0, 1, 2, 1, 4, 5, 0};
        this.checkIndexOf(toTest, expected);
    }

    public void testIndexOfImpl_null() {
        List<String> toTest;
        try {
            toTest = this.createList(String.class, null, "A", "B", null, "C", null);
        }
        catch (NullPointerException e) {
            return;
        }
        int[] expected = new int[]{0, 1, 2, 0, 4, 0};
        this.checkIndexOf(toTest, expected);
    }

    public void testLastIndexOfImpl_nonNull() {
        List<Integer> toTest = this.createList(Integer.class, 1, 5, 6, 10, 1, 3, 2, 1, 6);
        int[] expected = new int[]{7, 1, 8, 3, 7, 5, 6, 7, 8};
        this.checkLastIndexOf(toTest, expected);
    }

    public void testLastIndexOfImpl_null() {
        List<String> toTest;
        try {
            toTest = this.createList(String.class, null, "A", "B", null, "C", "B");
        }
        catch (NullPointerException e) {
            return;
        }
        int[] expected = new int[]{3, 1, 5, 3, 4, 5};
        this.checkLastIndexOf(toTest, expected);
    }

    private void checkIndexOf(List<?> toTest, int[] expected) {
        int index = 0;
        for (Object obj : toTest) {
            String name = "toTest[" + index + "] (" + obj + ")";
            ((IntegerSubject)Truth.assertThat((Integer)Lists.indexOfImpl(toTest, obj)).named(name, new Object[0])).isEqualTo((Object)expected[index]);
            ++index;
        }
    }

    private void checkLastIndexOf(List<?> toTest, int[] expected) {
        int index = 0;
        for (Object obj : toTest) {
            String name = "toTest[" + index + "] (" + obj + ")";
            ((IntegerSubject)Truth.assertThat((Integer)Lists.lastIndexOfImpl(toTest, obj)).named(name, new Object[0])).isEqualTo((Object)expected[index]);
            ++index;
        }
    }

    @SafeVarargs
    private final <T> List<T> createList(Class<T> listType, T ... contents) {
        return this.getExample().createList(listType, Arrays.asList(contents));
    }

    @GwtIncompatible
    private static final class CopyOnWriteListExample
    extends ListExample {
        protected CopyOnWriteListExample(String name) {
            super(name, Modifiability.DIRECT_ONLY);
        }

        @Override
        public <T> List<T> createList(Class<T> listType, Collection<? extends T> contents) {
            return new CopyOnWriteArrayList<T>(contents);
        }
    }

    private static final class ImmutableListExample
    extends ListExample {
        protected ImmutableListExample(String name) {
            super(name, Modifiability.NONE);
        }

        @Override
        public <T> List<T> createList(Class<T> listType, Collection<? extends T> contents) {
            return ImmutableList.copyOf(contents);
        }
    }

    @GwtIncompatible
    private static final class ArraysAsListExample
    extends ListExample {
        protected ArraysAsListExample(String name) {
            super(name, Modifiability.BY_ELEMENT);
        }

        @Override
        public <T> List<T> createList(Class<T> listType, Collection<? extends T> contents) {
            Object[] array = Iterables.toArray(contents, listType);
            return Arrays.asList(array);
        }
    }

    private static final class LinkedListExample
    extends ListExample {
        protected LinkedListExample(String name) {
            super(name, Modifiability.ALL);
        }

        @Override
        public <T> List<T> createList(Class<T> listType, Collection<? extends T> contents) {
            return new LinkedList<T>(contents);
        }
    }

    private static final class ArrayListExample
    extends ListExample {
        protected ArrayListExample(String name) {
            super(name, Modifiability.ALL);
        }

        @Override
        public <T> List<T> createList(Class<T> listType, Collection<? extends T> contents) {
            return new ArrayList<T>(contents);
        }
    }

    public static abstract class ListExample {
        private final String name;
        private final Modifiability modifiability;

        protected ListExample(String name, Modifiability modifiability) {
            this.name = name;
            this.modifiability = modifiability;
        }

        public String getName() {
            return this.name;
        }

        public abstract <T> List<T> createList(Class<T> var1, Collection<? extends T> var2);

        public Modifiability modifiability() {
            return this.modifiability;
        }
    }

    public static enum Modifiability {
        NONE,
        BY_ELEMENT,
        DIRECT_ONLY,
        ALL;

    }
}

