/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.collect.MapMaker;
import com.google.common.testing.NullPointerTester;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MapMakerTest
extends TestCase {
    @GwtIncompatible
    public void testNullParameters() throws Exception {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods((Object)new MapMaker());
    }

    public static class MakerTest
    extends TestCase {
        public void testInitialCapacity_negative() {
            MapMaker maker = new MapMaker();
            try {
                maker.initialCapacity(-1);
                MakerTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void xtestInitialCapacity_setTwice() {
            MapMaker maker = new MapMaker().initialCapacity(16);
            try {
                maker.initialCapacity(16);
                MakerTest.fail();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void testReturnsPlainConcurrentHashMapWhenPossible() {
            ConcurrentMap map = new MapMaker().initialCapacity(5).makeMap();
            MakerTest.assertTrue((boolean)(map instanceof ConcurrentHashMap));
        }
    }

    @GwtIncompatible
    static final class DelayingIdentityLoader<T>
    implements Function<T, T> {
        private final CountDownLatch delayLatch;

        DelayingIdentityLoader(CountDownLatch delayLatch) {
            this.delayLatch = delayLatch;
        }

        public T apply(T key) {
            Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.delayLatch);
            return key;
        }
    }
}

