/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.testing.MapInterfaceTest;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Nullable;

@GwtCompatible
public class MapsTransformValuesUnmodifiableIteratorTest
extends MapInterfaceTest<String, String> {
    public MapsTransformValuesUnmodifiableIteratorTest() {
        super(true, true, false, true, true, false);
    }

    protected Map<String, String> makeEmptyMap() {
        HashMap underlying = Maps.newHashMap();
        return Maps.transformValues(new UnmodifiableIteratorMap(underlying), (Function)Functions.toStringFunction());
    }

    protected Map<String, String> makePopulatedMap() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", 1);
        underlying.put("b", 2);
        underlying.put("c", 3);
        return Maps.transformValues(new UnmodifiableIteratorMap(underlying), (Function)Functions.toStringFunction());
    }

    protected String getKeyNotInPopulatedMap() throws UnsupportedOperationException {
        return "z";
    }

    protected String getValueNotInPopulatedMap() throws UnsupportedOperationException {
        return "26";
    }

    private void assertMapsEqual(Map<?, ?> expected, Map<?, ?> map) {
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals(expected, map);
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((int)expected.hashCode(), (int)map.hashCode());
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals(expected.entrySet(), map.entrySet());
        Collection<?> expectedValues = expected.values();
        Collection<?> mapValues = map.values();
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((int)expectedValues.size(), (int)mapValues.size());
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)expectedValues.containsAll(mapValues));
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)mapValues.containsAll(expectedValues));
    }

    public void testTransformEmptyMapEquality() {
        Map map = Maps.transformValues((Map)ImmutableMap.of(), (Function)Functions.toStringFunction());
        this.assertMapsEqual(Maps.newHashMap(), map);
    }

    public void testTransformSingletonMapEquality() {
        Map map = Maps.transformValues((Map)ImmutableMap.of((Object)"a", (Object)1), (Function)Functions.toStringFunction());
        ImmutableMap expected = ImmutableMap.of((Object)"a", (Object)"1");
        this.assertMapsEqual((Map<?, ?>)expected, map);
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((String)((String)expected.get("a")), (String)((String)map.get("a")));
    }

    public void testTransformIdentityFunctionEquality() {
        ImmutableMap underlying = ImmutableMap.of((Object)"a", (Object)1);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.identity());
        this.assertMapsEqual((Map<?, ?>)underlying, map);
    }

    public void testTransformPutEntryIsUnsupported() {
        Map map = Maps.transformValues((Map)ImmutableMap.of((Object)"a", (Object)1), (Function)Functions.toStringFunction());
        try {
            map.put("b", "2");
            MapsTransformValuesUnmodifiableIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            map.putAll(ImmutableMap.of((Object)"b", (Object)"2"));
            MapsTransformValuesUnmodifiableIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            map.entrySet().iterator().next().setValue("one");
            MapsTransformValuesUnmodifiableIteratorTest.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testTransformRemoveEntry() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", 1);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((String)"1", (String)((String)map.remove("a")));
        MapsTransformValuesUnmodifiableIteratorTest.assertNull(map.remove("b"));
    }

    public void testTransformEqualityOfMapsWithNullValues() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", null);
        underlying.put("b", "");
        Map map = Maps.transformValues((Map)underlying, (Function)new Function<String, Boolean>(){

            public Boolean apply(@Nullable String from) {
                return from == null;
            }
        });
        ImmutableMap expected = ImmutableMap.of((Object)"a", (Object)true, (Object)"b", (Object)false);
        this.assertMapsEqual((Map<?, ?>)expected, map);
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals(expected.get("a"), map.get("a"));
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((boolean)expected.containsKey("a"), (boolean)map.containsKey("a"));
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals(expected.get("b"), map.get("b"));
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((boolean)expected.containsKey("b"), (boolean)map.containsKey("b"));
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals(expected.get("c"), map.get("c"));
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((boolean)expected.containsKey("c"), (boolean)map.containsKey("c"));
    }

    public void testTransformReflectsUnderlyingMap() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", 1);
        underlying.put("b", 2);
        underlying.put("c", 3);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((int)underlying.size(), (int)map.size());
        underlying.put("d", 4);
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((int)underlying.size(), (int)map.size());
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((String)"4", (String)((String)map.get("d")));
        underlying.remove("c");
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((int)underlying.size(), (int)map.size());
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)map.containsKey("c"));
        underlying.clear();
        MapsTransformValuesUnmodifiableIteratorTest.assertEquals((int)underlying.size(), (int)map.size());
    }

    public void testTransformChangesAreReflectedInUnderlyingMap() {
        LinkedHashMap underlying = Maps.newLinkedHashMap();
        underlying.put("a", 1);
        underlying.put("b", 2);
        underlying.put("c", 3);
        underlying.put("d", 4);
        underlying.put("e", 5);
        underlying.put("f", 6);
        underlying.put("g", 7);
        Map map = Maps.transformValues((Map)underlying, (Function)Functions.toStringFunction());
        map.remove("a");
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("a"));
        Set keys = map.keySet();
        keys.remove("b");
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("b"));
        Iterator keyIterator = keys.iterator();
        keyIterator.next();
        keyIterator.remove();
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("c"));
        Collection values = map.values();
        values.remove("4");
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("d"));
        Iterator valueIterator = values.iterator();
        valueIterator.next();
        valueIterator.remove();
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("e"));
        Set entries = map.entrySet();
        Map.Entry firstEntry = entries.iterator().next();
        entries.remove(firstEntry);
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("f"));
        Iterator entryIterator = entries.iterator();
        entryIterator.next();
        entryIterator.remove();
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)underlying.containsKey("g"));
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)underlying.isEmpty());
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)map.isEmpty());
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)keys.isEmpty());
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)values.isEmpty());
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)entries.isEmpty());
    }

    public void testTransformEquals() {
        ImmutableMap underlying = ImmutableMap.of((Object)"a", (Object)0, (Object)"b", (Object)1, (Object)"c", (Object)2);
        Map expected = Maps.transformValues((Map)underlying, (Function)Functions.identity());
        this.assertMapsEqual(expected, expected);
        TreeMap equalToUnderlying = Maps.newTreeMap();
        equalToUnderlying.putAll(underlying);
        Map map = Maps.transformValues((Map)equalToUnderlying, (Function)Functions.identity());
        this.assertMapsEqual(expected, map);
        map = Maps.transformValues((Map)ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2, (Object)"c", (Object)3), (Function)new Function<Integer, Integer>(){

            public Integer apply(Integer from) {
                return from - 1;
            }
        });
        this.assertMapsEqual(expected, map);
    }

    public void testTransformEntrySetContains() {
        HashMap underlying = Maps.newHashMap();
        underlying.put("a", null);
        underlying.put("b", true);
        underlying.put(null, true);
        Map map = Maps.transformValues((Map)underlying, (Function)new Function<Boolean, Boolean>(){

            public Boolean apply(@Nullable Boolean from) {
                return from == null ? Boolean.valueOf(true) : null;
            }
        });
        Set entries = map.entrySet();
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)"a", (Object)true)));
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)"b", (Object)null)));
        MapsTransformValuesUnmodifiableIteratorTest.assertTrue((boolean)entries.contains(Maps.immutableEntry((Object)null, (Object)null)));
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)"c", (Object)null)));
        MapsTransformValuesUnmodifiableIteratorTest.assertFalse((boolean)entries.contains(Maps.immutableEntry((Object)null, (Object)true)));
    }

    public void testKeySetRemoveAllNullFromEmpty() {
        try {
            super.testKeySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void testEntrySetRemoveAllNullFromEmpty() {
        try {
            super.testEntrySetRemoveAllNullFromEmpty();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private static class UnmodifiableIteratorMap<K, V>
    extends ForwardingMap<K, V> {
        final Map<K, V> delegate;

        UnmodifiableIteratorMap(Map<K, V> delegate) {
            this.delegate = delegate;
        }

        protected Map<K, V> delegate() {
            return this.delegate;
        }

        public Set<K> keySet() {
            return new ForwardingSet<K>(){

                protected Set<K> delegate() {
                    return delegate.keySet();
                }

                public Iterator<K> iterator() {
                    return Iterators.unmodifiableIterator(delegate.keySet().iterator());
                }

                public boolean removeAll(Collection<?> c) {
                    return delegate.keySet().removeAll(c);
                }

                public boolean retainAll(Collection<?> c) {
                    return delegate.keySet().retainAll(c);
                }
            };
        }

        public Collection<V> values() {
            return new ForwardingCollection<V>(){

                protected Collection<V> delegate() {
                    return delegate.values();
                }

                public Iterator<V> iterator() {
                    return Iterators.unmodifiableIterator(delegate.values().iterator());
                }

                public boolean removeAll(Collection<?> c) {
                    return delegate.values().removeAll(c);
                }

                public boolean retainAll(Collection<?> c) {
                    return delegate.values().retainAll(c);
                }
            };
        }

        public Set<Map.Entry<K, V>> entrySet() {
            return new ForwardingSet<Map.Entry<K, V>>(){

                protected Set<Map.Entry<K, V>> delegate() {
                    return delegate.entrySet();
                }

                public Iterator<Map.Entry<K, V>> iterator() {
                    return Iterators.unmodifiableIterator(delegate.entrySet().iterator());
                }

                public boolean removeAll(Collection<?> c) {
                    return delegate.entrySet().removeAll(c);
                }

                public boolean retainAll(Collection<?> c) {
                    return delegate.entrySet().retainAll(c);
                }
            };
        }
    }
}

