/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.MoreCollectors;
import com.google.common.truth.Truth;
import com.google.common.truth.Truth8;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Stream;
import junit.framework.TestCase;

@GwtCompatible
public class MoreCollectorsTest
extends TestCase {
    public void testToOptionalEmpty() {
        Truth8.assertThat((Optional)((Optional)Stream.empty().collect(MoreCollectors.toOptional()))).isEmpty();
    }

    public void testToOptionalSingleton() {
        Truth8.assertThat((Optional)((Optional)Stream.of(Integer.valueOf(1)).collect(MoreCollectors.toOptional()))).hasValue((Object)1);
    }

    public void testToOptionalNull() {
        Stream<Object> stream = Stream.of(null);
        try {
            stream.collect(MoreCollectors.toOptional());
            MoreCollectorsTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToOptionalMultiple() {
        try {
            Stream.of(1, 2).collect(MoreCollectors.toOptional());
            MoreCollectorsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"1, 2");
        }
    }

    public void testToOptionalMany() {
        try {
            Stream.of(1, 2, 3, 4, 5, 6).collect(MoreCollectors.toOptional());
            MoreCollectorsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"1, 2, 3, 4, 5, ...");
        }
    }

    public void testOnlyElement() {
        try {
            Stream.empty().collect(MoreCollectors.onlyElement());
            MoreCollectorsTest.fail((String)"Expected NoSuchElementException");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void testOnlyElementSingleton() {
        Truth.assertThat((Integer)((Integer)Stream.of(Integer.valueOf(1)).collect(MoreCollectors.onlyElement()))).isEqualTo((Object)1);
    }

    public void testOnlyElementNull() {
        Truth.assertThat(Stream.of(null).collect(MoreCollectors.onlyElement())).isNull();
    }

    public void testOnlyElementMultiple() {
        try {
            Stream.of(1, 2).collect(MoreCollectors.onlyElement());
            MoreCollectorsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"1, 2");
        }
    }

    public void testOnlyElementMany() {
        try {
            Stream.of(1, 2, 3, 4, 5, 6).collect(MoreCollectors.onlyElement());
            MoreCollectorsTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException expected) {
            Truth.assertThat((String)expected.getMessage()).contains((CharSequence)"1, 2, 3, 4, 5, ...");
        }
    }
}

