/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.google.MultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.SortedMultisetTestSuiteBuilder;
import com.google.common.collect.testing.google.TestMultisetGenerator;
import com.google.common.collect.testing.google.TestStringMultisetGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtIncompatible
public class MultisetsCollectionTest
extends TestCase {
    private static final ImmutableMultiset<String> ELEMENTS_TO_FILTER_OUT = ImmutableMultiset.of((Object)"foobar", (Object)"bazfoo", (Object)"foobar", (Object)"foobar");
    private static final Predicate<String> PREDICATE = Predicates.not((Predicate)Predicates.in(ELEMENTS_TO_FILTER_OUT));

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.unmodifiableMultisetGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.SERIALIZABLE, CollectionFeature.ALLOWS_NULL_QUERIES})).named("Multisets.unmodifiableMultiset[LinkedHashMultiset]")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)SortedMultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.unmodifiableSortedMultisetGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.ALLOWS_NULL_QUERIES})).named("Multisets.unmodifiableMultiset[TreeMultiset]")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.unionGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).named("Multisets.union")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.intersectionGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER})).named("Multisets.intersection")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.sumGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES})).named("Multisets.sum")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.differenceGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER})).named("Multisets.difference")).createTestSuite());
        suite.addTest((Test)((MultisetTestSuiteBuilder)((MultisetTestSuiteBuilder)MultisetTestSuiteBuilder.using((TestMultisetGenerator)MultisetsCollectionTest.filteredGenerator()).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.ALLOWS_NULL_VALUES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ADD, CollectionFeature.SUPPORTS_REMOVE})).named("Multiset.filter[Multiset, Predicate]")).createTestSuite());
        return suite;
    }

    private static TestStringMultisetGenerator unmodifiableMultisetGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return Multisets.unmodifiableMultiset((Multiset)LinkedHashMultiset.create(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                ArrayList<String> order = new ArrayList<String>();
                for (String s : insertionOrder) {
                    int index = order.indexOf(s);
                    if (index == -1) {
                        order.add(s);
                        continue;
                    }
                    order.add(index, s);
                }
                return order;
            }
        };
    }

    private static TestStringMultisetGenerator unmodifiableSortedMultisetGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                return Multisets.unmodifiableSortedMultiset((SortedMultiset)TreeMultiset.create(Arrays.asList(elements)));
            }

            public List<String> order(List<String> insertionOrder) {
                Collections.sort(insertionOrder);
                return insertionOrder;
            }
        };
    }

    private static TestStringMultisetGenerator unionGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                LinkedHashMultiset multiset1 = LinkedHashMultiset.create();
                LinkedHashMultiset multiset2 = LinkedHashMultiset.create();
                for (int i = 0; i < elements.length; ++i) {
                    String element = elements[i];
                    if (multiset1.contains((Object)element) || multiset2.contains((Object)element)) {
                        multiset1.add((Object)element);
                        multiset2.add((Object)element);
                        continue;
                    }
                    if (i % 2 == 0) {
                        multiset1.add((Object)elements[i]);
                        continue;
                    }
                    multiset2.add((Object)elements[i]);
                }
                return Multisets.union((Multiset)multiset1, (Multiset)multiset2);
            }
        };
    }

    private static TestStringMultisetGenerator intersectionGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                LinkedHashMultiset multiset1 = LinkedHashMultiset.create();
                LinkedHashMultiset multiset2 = LinkedHashMultiset.create();
                multiset1.add((Object)"only1");
                multiset2.add((Object)"only2");
                for (int i = 0; i < elements.length; ++i) {
                    multiset1.add((Object)elements[i]);
                    multiset2.add((Object)elements[elements.length - 1 - i]);
                }
                if (elements.length > 0) {
                    multiset1.add((Object)elements[0]);
                }
                if (elements.length > 1 && !Objects.equal((Object)elements[0], (Object)elements[1])) {
                    multiset2.add((Object)elements[1], 2);
                }
                return Multisets.intersection((Multiset)multiset1, (Multiset)multiset2);
            }
        };
    }

    private static TestStringMultisetGenerator sumGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                LinkedHashMultiset multiset1 = LinkedHashMultiset.create();
                LinkedHashMultiset multiset2 = LinkedHashMultiset.create();
                for (int i = 0; i < elements.length; ++i) {
                    if (i % 2 == 0) {
                        multiset1.add((Object)elements[i]);
                        continue;
                    }
                    multiset2.add((Object)elements[i]);
                }
                return Multisets.sum((Multiset)multiset1, (Multiset)multiset2);
            }
        };
    }

    private static TestStringMultisetGenerator differenceGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                LinkedHashMultiset multiset1 = LinkedHashMultiset.create();
                LinkedHashMultiset multiset2 = LinkedHashMultiset.create();
                multiset1.add((Object)"equalIn1");
                multiset1.add((Object)"fewerIn1");
                multiset2.add((Object)"equalIn1");
                multiset2.add((Object)"fewerIn1", 3);
                multiset2.add((Object)"onlyIn2", 2);
                for (int i = 0; i < elements.length; ++i) {
                    multiset1.add((Object)elements[i], i + 2);
                    multiset2.add((Object)elements[i], i + 1);
                }
                return Multisets.difference((Multiset)multiset1, (Multiset)multiset2);
            }
        };
    }

    private static TestStringMultisetGenerator filteredGenerator() {
        return new TestStringMultisetGenerator(){

            protected Multiset<String> create(String[] elements) {
                LinkedHashMultiset multiset = LinkedHashMultiset.create();
                Collections.addAll(multiset, elements);
                multiset.addAll((Collection)ELEMENTS_TO_FILTER_OUT);
                return Multisets.filter((Multiset)multiset, (Predicate)PREDICATE);
            }

            public List<String> order(List<String> insertionOrder) {
                return Lists.newArrayList((Iterable)LinkedHashMultiset.create(insertionOrder));
            }
        };
    }
}

