/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.LegacyComparable;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.testing.DerivedComparable;
import com.google.common.testing.CollectorTester;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class MultisetsTest
extends TestCase {
    public void testNewTreeMultisetDerived() {
        TreeMultiset set = TreeMultiset.create();
        MultisetsTest.assertTrue((boolean)set.isEmpty());
        set.add((Object)new DerivedComparable("foo"), 2);
        set.add((Object)new DerivedComparable("bar"), 3);
        Truth.assertThat((Multiset)set).containsExactly(new Object[]{new DerivedComparable("bar"), new DerivedComparable("bar"), new DerivedComparable("bar"), new DerivedComparable("foo"), new DerivedComparable("foo")}).inOrder();
    }

    public void testNewTreeMultisetNonGeneric() {
        TreeMultiset set = TreeMultiset.create();
        MultisetsTest.assertTrue((boolean)set.isEmpty());
        set.add((Object)new LegacyComparable("foo"), 2);
        set.add((Object)new LegacyComparable("bar"), 3);
        Truth.assertThat((Multiset)set).containsExactly(new Object[]{new LegacyComparable("bar"), new LegacyComparable("bar"), new LegacyComparable("bar"), new LegacyComparable("foo"), new LegacyComparable("foo")}).inOrder();
    }

    public void testNewTreeMultisetComparator() {
        TreeMultiset multiset = TreeMultiset.create(Collections.reverseOrder());
        multiset.add((Object)"bar", 3);
        multiset.add((Object)"foo", 2);
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"foo", "foo", "bar", "bar", "bar"}).inOrder();
    }

    public void testRetainOccurrencesEmpty() {
        HashMultiset multiset = HashMultiset.create();
        HashMultiset toRetain = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertFalse((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRetain));
        Truth.assertThat((Multiset)multiset).isEmpty();
    }

    public void testRemoveOccurrencesIterableEmpty() {
        HashMultiset multiset = HashMultiset.create();
        List<String> toRemove = Arrays.asList("a", "b", "a");
        MultisetsTest.assertFalse((boolean)Multisets.removeOccurrences((Multiset)multiset, toRemove));
        MultisetsTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testRemoveOccurrencesMultisetEmpty() {
        HashMultiset multiset = HashMultiset.create();
        HashMultiset toRemove = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertFalse((boolean)Multisets.removeOccurrences((Multiset)multiset, (Multiset)toRemove));
        MultisetsTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testUnion() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "b", "c"));
        Truth.assertThat((Multiset)Multisets.union((Multiset)ms1, (Multiset)ms2)).containsExactly(new Object[]{"a", "a", "b", "b", "c"});
    }

    public void testUnionEqualMultisets() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.union((Multiset)ms1, (Multiset)ms2));
    }

    public void testUnionEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertEquals((Object)ms2, (Object)Multisets.union((Multiset)ms1, (Multiset)ms2));
    }

    public void testUnionNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.union((Multiset)ms1, (Multiset)ms2));
    }

    public void testIntersectEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        Truth.assertThat((Multiset)Multisets.intersection((Multiset)ms1, (Multiset)ms2)).isEmpty();
    }

    public void testIntersectNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        Truth.assertThat((Multiset)Multisets.intersection((Multiset)ms1, (Multiset)ms2)).isEmpty();
    }

    public void testSum() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("b", "c"));
        Truth.assertThat((Multiset)Multisets.sum((Multiset)ms1, (Multiset)ms2)).containsExactly(new Object[]{"a", "a", "b", "b", "c"});
    }

    public void testSumEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        Truth.assertThat((Multiset)Multisets.sum((Multiset)ms1, (Multiset)ms2)).containsExactly(new Object[]{"a", "b", "a"});
    }

    public void testSumNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        Truth.assertThat((Multiset)Multisets.sum((Multiset)ms1, (Multiset)ms2)).containsExactly(new Object[]{"a", "b", "a"});
    }

    public void testDifferenceWithNoRemovedElements() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a"));
        Truth.assertThat((Multiset)Multisets.difference((Multiset)ms1, (Multiset)ms2)).containsExactly(new Object[]{"a", "b"});
    }

    public void testDifferenceWithRemovedElement() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("b"));
        Truth.assertThat((Multiset)Multisets.difference((Multiset)ms1, (Multiset)ms2)).containsExactly(new Object[]{"a", "a"});
    }

    public void testDifferenceWithMoreElementsInSecondMultiset() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "b", "b"));
        Multiset diff = Multisets.difference((Multiset)ms1, (Multiset)ms2);
        Truth.assertThat((Multiset)diff).contains((Object)"a");
        MultisetsTest.assertEquals((int)0, (int)diff.count((Object)"b"));
        MultisetsTest.assertEquals((int)1, (int)diff.count((Object)"a"));
        MultisetsTest.assertFalse((boolean)diff.contains((Object)"b"));
        MultisetsTest.assertTrue((boolean)diff.contains((Object)"a"));
    }

    public void testDifferenceEmptyNonempty() {
        HashMultiset ms1 = HashMultiset.create();
        HashMultiset ms2 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.difference((Multiset)ms1, (Multiset)ms2));
    }

    public void testDifferenceNonemptyEmpty() {
        HashMultiset ms1 = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset ms2 = HashMultiset.create();
        MultisetsTest.assertEquals((Object)ms1, (Object)Multisets.difference((Multiset)ms1, (Multiset)ms2));
    }

    public void testContainsOccurrencesEmpty() {
        HashMultiset superMultiset = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset subMultiset = HashMultiset.create();
        MultisetsTest.assertTrue((boolean)Multisets.containsOccurrences((Multiset)superMultiset, (Multiset)subMultiset));
        MultisetsTest.assertFalse((boolean)Multisets.containsOccurrences((Multiset)subMultiset, (Multiset)superMultiset));
    }

    public void testContainsOccurrences() {
        HashMultiset superMultiset = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset subMultiset = HashMultiset.create(Arrays.asList("a", "b"));
        MultisetsTest.assertTrue((boolean)Multisets.containsOccurrences((Multiset)superMultiset, (Multiset)subMultiset));
        MultisetsTest.assertFalse((boolean)Multisets.containsOccurrences((Multiset)subMultiset, (Multiset)superMultiset));
        HashMultiset diffMultiset = HashMultiset.create(Arrays.asList("a", "b", "c"));
        MultisetsTest.assertFalse((boolean)Multisets.containsOccurrences((Multiset)superMultiset, (Multiset)diffMultiset));
        MultisetsTest.assertTrue((boolean)Multisets.containsOccurrences((Multiset)diffMultiset, (Multiset)subMultiset));
    }

    public void testRetainEmptyOccurrences() {
        HashMultiset multiset = HashMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset toRetain = HashMultiset.create();
        MultisetsTest.assertTrue((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRetain));
        MultisetsTest.assertTrue((boolean)multiset.isEmpty());
    }

    public void testRetainOccurrences() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a", "c"));
        HashMultiset toRetain = HashMultiset.create(Arrays.asList("a", "b", "b"));
        MultisetsTest.assertTrue((boolean)Multisets.retainOccurrences((Multiset)multiset, (Multiset)toRetain));
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"a", "b"}).inOrder();
    }

    public void testRemoveEmptyOccurrencesMultiset() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a"));
        HashMultiset toRemove = HashMultiset.create();
        MultisetsTest.assertFalse((boolean)Multisets.removeOccurrences((Multiset)multiset, (Multiset)toRemove));
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"a", "a", "b"}).inOrder();
    }

    public void testRemoveOccurrencesMultiset() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a", "c"));
        HashMultiset toRemove = HashMultiset.create(Arrays.asList("a", "b", "b"));
        MultisetsTest.assertTrue((boolean)Multisets.removeOccurrences((Multiset)multiset, (Multiset)toRemove));
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"a", "c"}).inOrder();
    }

    public void testRemoveEmptyOccurrencesIterable() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a"));
        ImmutableList toRemove = ImmutableList.of();
        MultisetsTest.assertFalse((boolean)Multisets.removeOccurrences((Multiset)multiset, (Iterable)toRemove));
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"a", "a", "b"}).inOrder();
    }

    public void testRemoveOccurrencesMultisetIterable() {
        TreeMultiset multiset = TreeMultiset.create(Arrays.asList("a", "b", "a", "c"));
        List<String> toRemove = Arrays.asList("a", "b", "b");
        MultisetsTest.assertTrue((boolean)Multisets.removeOccurrences((Multiset)multiset, toRemove));
        Truth.assertThat((Multiset)multiset).containsExactly(new Object[]{"a", "c"}).inOrder();
    }

    public void testUnmodifiableMultisetShortCircuit() {
        HashMultiset mod = HashMultiset.create();
        Multiset unmod = Multisets.unmodifiableMultiset((Multiset)mod);
        MultisetsTest.assertNotSame((Object)mod, (Object)unmod);
        MultisetsTest.assertSame((Object)unmod, (Object)Multisets.unmodifiableMultiset((Multiset)unmod));
        ImmutableMultiset immutable = ImmutableMultiset.of((Object)"a", (Object)"a", (Object)"b", (Object)"a");
        MultisetsTest.assertSame((Object)immutable, (Object)Multisets.unmodifiableMultiset((ImmutableMultiset)immutable));
        MultisetsTest.assertSame((Object)immutable, (Object)Multisets.unmodifiableMultiset((Multiset)immutable));
    }

    public void testHighestCountFirst() {
        HashMultiset multiset = HashMultiset.create(Arrays.asList("a", "a", "a", "b", "c", "c"));
        ImmutableMultiset sortedMultiset = Multisets.copyHighestCountFirst((Multiset)multiset);
        Truth.assertThat((Iterable)sortedMultiset.entrySet()).containsExactly(new Object[]{Multisets.immutableEntry((Object)"a", (int)3), Multisets.immutableEntry((Object)"c", (int)2), Multisets.immutableEntry((Object)"b", (int)1)}).inOrder();
        Truth.assertThat((Multiset)sortedMultiset).containsExactly(new Object[]{"a", "a", "a", "c", "c", "b"}).inOrder();
        Truth.assertThat((Multiset)Multisets.copyHighestCountFirst((Multiset)ImmutableMultiset.of())).isEmpty();
    }

    public void testToMultisetCountFunction() {
        BiPredicate<Multiset, Multiset> equivalence = (ms1, ms2) -> ms1.equals(ms2) && ImmutableList.copyOf((Collection)ms1.entrySet()).equals((Object)ImmutableList.copyOf((Collection)ms2.entrySet()));
        CollectorTester.of((Collector)Multisets.toMultiset(Multiset.Entry::getElement, Multiset.Entry::getCount, LinkedHashMultiset::create), equivalence).expectCollects((Object)ImmutableMultiset.of(), (Object[])new Multiset.Entry[0]).expectCollects((Object)ImmutableMultiset.of((Object)"a", (Object)"a", (Object)"b", (Object)"c", (Object)"c", (Object)"c", (Object[])new String[0]), (Object[])new Multiset.Entry[]{Multisets.immutableEntry((Object)"a", (int)1), Multisets.immutableEntry((Object)"b", (int)1), Multisets.immutableEntry((Object)"a", (int)1), Multisets.immutableEntry((Object)"c", (int)3)});
    }

    @GwtIncompatible
    public void testNullPointers() {
        new NullPointerTester().testAllPublicStaticMethods(Multisets.class);
    }
}

