/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Queues;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;

public class QueuesTest
extends TestCase {
    private ExecutorService threadPool;

    public static List<BlockingQueue<Object>> blockingQueues() {
        return ImmutableList.of(new LinkedBlockingQueue(), new LinkedBlockingQueue(10), new SynchronousQueue(), new ArrayBlockingQueue(10), new LinkedBlockingDeque(), new LinkedBlockingDeque(10), new PriorityBlockingQueue(10, Ordering.arbitrary()));
    }

    public void setUp() {
        this.threadPool = Executors.newCachedThreadPool();
    }

    public void tearDown() throws InterruptedException {
        this.threadPool.shutdown();
        QueuesTest.assertTrue((String)"Some worker didn't finish in time", (boolean)this.threadPool.awaitTermination(1L, TimeUnit.SECONDS));
    }

    private static <T> int drain(BlockingQueue<T> q, Collection<? super T> buffer, int maxElements, long timeout, TimeUnit unit, boolean interruptibly) throws InterruptedException {
        return interruptibly ? Queues.drain(q, buffer, (int)maxElements, (long)timeout, (TimeUnit)unit) : Queues.drainUninterruptibly(q, buffer, (int)maxElements, (long)timeout, (TimeUnit)unit);
    }

    public void testMultipleProducers() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testMultipleProducers(q);
        }
    }

    private void testMultipleProducers(BlockingQueue<Object> q) throws InterruptedException {
        for (boolean interruptibly : new boolean[]{true, false}) {
            Future<Void> possiblyIgnoredError = this.threadPool.submit(new Producer(q, 20));
            Future<Void> possiblyIgnoredError1 = this.threadPool.submit(new Producer(q, 20));
            Future<Void> possiblyIgnoredError2 = this.threadPool.submit(new Producer(q, 20));
            Future<Void> possiblyIgnoredError3 = this.threadPool.submit(new Producer(q, 20));
            Future<Void> possiblyIgnoredError4 = this.threadPool.submit(new Producer(q, 20));
            ArrayList buf = Lists.newArrayList();
            int elements = QueuesTest.drain(q, buf, 100, Long.MAX_VALUE, TimeUnit.NANOSECONDS, interruptibly);
            QueuesTest.assertEquals((int)100, (int)elements);
            QueuesTest.assertEquals((int)100, (int)buf.size());
            this.assertDrained(q);
        }
    }

    public void testDrainTimesOut() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testDrainTimesOut(q);
        }
    }

    private void testDrainTimesOut(BlockingQueue<Object> q) throws Exception {
        for (boolean interruptibly : new boolean[]{true, false}) {
            QueuesTest.assertEquals((int)0, (int)Queues.drain(q, (Collection)ImmutableList.of(), (int)1, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
            Producer producer = new Producer(q, 1);
            Future<Void> producerThread = this.threadPool.submit(producer);
            producer.beganProducing.await();
            Stopwatch timer = Stopwatch.createStarted();
            int drained = QueuesTest.drain(q, Lists.newArrayList(), 2, 10L, TimeUnit.MILLISECONDS, interruptibly);
            Truth.assertThat((Integer)drained).isAtMost((Comparable)Integer.valueOf(1));
            Truth.assertThat((Long)timer.elapsed(TimeUnit.MILLISECONDS)).isAtLeast((Comparable)Long.valueOf(10L));
            producerThread.cancel(true);
            producer.doneProducing.await();
            if (drained != 0) continue;
            q.poll();
        }
    }

    public void testZeroElements() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testZeroElements(q);
        }
    }

    private void testZeroElements(BlockingQueue<Object> q) throws InterruptedException {
        for (boolean interruptibly : new boolean[]{true, false}) {
            QueuesTest.assertEquals((int)0, (int)QueuesTest.drain(q, ImmutableList.of(), 0, 10L, TimeUnit.MILLISECONDS, interruptibly));
        }
    }

    public void testEmpty() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testEmpty(q);
        }
    }

    private void testEmpty(BlockingQueue<Object> q) {
        this.assertDrained(q);
    }

    public void testNegativeMaxElements() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testNegativeMaxElements(q);
        }
    }

    private void testNegativeMaxElements(BlockingQueue<Object> q) throws InterruptedException {
        Future<Void> possiblyIgnoredError = this.threadPool.submit(new Producer(q, 1));
        ArrayList buf = Lists.newArrayList();
        int elements = Queues.drain(q, (Collection)buf, (int)-1, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
        QueuesTest.assertEquals((int)0, (int)elements);
        Truth.assertThat((Iterable)buf).isEmpty();
        q.take();
    }

    public void testDrain_throws() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testDrain_throws(q);
        }
    }

    private void testDrain_throws(BlockingQueue<Object> q) {
        Future<?> possiblyIgnoredError = this.threadPool.submit(new Interrupter(Thread.currentThread()));
        try {
            Queues.drain(q, (Collection)ImmutableList.of(), (int)100, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
            QueuesTest.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void testDrainUninterruptibly_doesNotThrow() throws Exception {
        for (BlockingQueue<Object> q : QueuesTest.blockingQueues()) {
            this.testDrainUninterruptibly_doesNotThrow(q);
        }
    }

    private void testDrainUninterruptibly_doesNotThrow(final BlockingQueue<Object> q) {
        final Thread mainThread = Thread.currentThread();
        Future<Void> possiblyIgnoredError = this.threadPool.submit(new Callable<Void>(){

            @Override
            public Void call() throws InterruptedException {
                new Producer(q, 50).call();
                new Interrupter(mainThread).run();
                new Producer(q, 50).call();
                return null;
            }
        });
        ArrayList buf = Lists.newArrayList();
        int elements = Queues.drainUninterruptibly(q, (Collection)buf, (int)100, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
        QueuesTest.assertTrue((boolean)Thread.interrupted());
        QueuesTest.assertEquals((int)100, (int)elements);
        QueuesTest.assertEquals((int)100, (int)buf.size());
    }

    public void testNewLinkedBlockingDequeCapacity() {
        try {
            Queues.newLinkedBlockingDeque((int)0);
            QueuesTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        QueuesTest.assertEquals((int)1, (int)Queues.newLinkedBlockingDeque((int)1).remainingCapacity());
        QueuesTest.assertEquals((int)11, (int)Queues.newLinkedBlockingDeque((int)11).remainingCapacity());
    }

    public void testNewLinkedBlockingQueueCapacity() {
        try {
            Queues.newLinkedBlockingQueue((int)0);
            QueuesTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        QueuesTest.assertEquals((int)1, (int)Queues.newLinkedBlockingQueue((int)1).remainingCapacity());
        QueuesTest.assertEquals((int)11, (int)Queues.newLinkedBlockingQueue((int)11).remainingCapacity());
    }

    private void assertDrained(BlockingQueue<Object> q) {
        QueuesTest.assertNull(q.peek());
        this.assertInterruptibleDrained(q);
        this.assertUninterruptibleDrained(q);
    }

    private void assertInterruptibleDrained(BlockingQueue<Object> q) {
        try {
            QueuesTest.assertEquals((int)0, (int)Queues.drain(q, (Collection)ImmutableList.of(), (int)0, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        catch (InterruptedException e) {
            throw new AssertionError();
        }
        Future<?> possiblyIgnoredError = this.threadPool.submit(new Interrupter(Thread.currentThread()));
        try {
            Queues.drain(q, (Collection)Lists.newArrayList(), (int)1, (long)Long.MAX_VALUE, (TimeUnit)TimeUnit.NANOSECONDS);
            QueuesTest.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void assertUninterruptibleDrained(BlockingQueue<Object> q) {
        QueuesTest.assertEquals((int)0, (int)Queues.drainUninterruptibly(q, (Collection)ImmutableList.of(), (int)0, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS));
        Future<?> possiblyIgnoredError = this.threadPool.submit(new Interrupter(Thread.currentThread()));
        Stopwatch timer = Stopwatch.createStarted();
        Queues.drainUninterruptibly(q, (Collection)Lists.newArrayList(), (int)1, (long)10L, (TimeUnit)TimeUnit.MILLISECONDS);
        Truth.assertThat((Long)timer.elapsed(TimeUnit.MILLISECONDS)).isAtLeast((Comparable)Long.valueOf(10L));
        while (!Thread.interrupted()) {
            Thread.yield();
        }
    }

    private static class Interrupter
    implements Runnable {
        final Thread threadToInterrupt;

        Interrupter(Thread threadToInterrupt) {
            this.threadToInterrupt = threadToInterrupt;
        }

        @Override
        public void run() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                throw new AssertionError();
            }
            finally {
                this.threadToInterrupt.interrupt();
            }
        }
    }

    private static class Producer
    implements Callable<Void> {
        final BlockingQueue<Object> q;
        final int elements;
        final CountDownLatch beganProducing = new CountDownLatch(1);
        final CountDownLatch doneProducing = new CountDownLatch(1);

        Producer(BlockingQueue<Object> q, int elements) {
            this.q = q;
            this.elements = elements;
        }

        @Override
        public Void call() throws InterruptedException {
            try {
                this.beganProducing.countDown();
                for (int i = 0; i < this.elements; ++i) {
                    this.q.put(new Object());
                }
                Void void_ = null;
                return void_;
            }
            finally {
                this.doneProducing.countDown();
            }
        }
    }
}

