/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.collect.testing.SpliteratorTester;
import com.google.common.primitives.Doubles;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.Truth;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class StreamsTest
extends TestCase {
    public void testStream_nonCollection() {
        StreamsTest.assertThat(Streams.stream((Iterable)FluentIterable.of())).isEmpty();
        StreamsTest.assertThat(Streams.stream((Iterable)FluentIterable.of((Object)"a", (Object[])new String[0]))).containsExactly(new Object[]{"a"});
        StreamsTest.assertThat(Streams.stream((Iterable)FluentIterable.of((Object)1, (Object[])new Integer[]{2, 3})).filter(n -> n > 1)).containsExactly(new Object[]{2, 3});
    }

    public void testStream_collection() {
        StreamsTest.assertThat(Streams.stream(Arrays.asList(new Object[0]))).isEmpty();
        StreamsTest.assertThat(Streams.stream(Arrays.asList("a"))).containsExactly(new Object[]{"a"});
        StreamsTest.assertThat(Streams.stream(Arrays.asList(1, 2, 3)).filter(n -> n > 1)).containsExactly(new Object[]{2, 3});
    }

    public void testStream_iterator() {
        StreamsTest.assertThat(Streams.stream(Arrays.asList(new Object[0]).iterator())).isEmpty();
        StreamsTest.assertThat(Streams.stream(Arrays.asList("a").iterator())).containsExactly(new Object[]{"a"});
        StreamsTest.assertThat(Streams.stream(Arrays.asList(1, 2, 3).iterator()).filter(n -> n > 1)).containsExactly(new Object[]{2, 3});
    }

    public void testStream_googleOptional() {
        StreamsTest.assertThat(Streams.stream((com.google.common.base.Optional)com.google.common.base.Optional.absent())).isEmpty();
        StreamsTest.assertThat(Streams.stream((com.google.common.base.Optional)com.google.common.base.Optional.of((Object)"a"))).containsExactly(new Object[]{"a"});
    }

    public void testStream_javaOptional() {
        StreamsTest.assertThat(Streams.stream(Optional.empty())).isEmpty();
        StreamsTest.assertThat(Streams.stream(Optional.of("a"))).containsExactly(new Object[]{"a"});
    }

    public void testConcat_refStream() {
        StreamsTest.assertThat(Streams.concat((Stream[])new Stream[]{Stream.of("a"), Stream.of("b"), Stream.empty(), Stream.of("c", "d")})).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
        SpliteratorTester.of(() -> Streams.concat((Stream[])new Stream[]{Stream.of("a"), Stream.of("b"), Stream.empty(), Stream.of("c", "d")}).spliterator()).expect(new Object[]{"a", "b", "c", "d"});
    }

    public void testConcat_refStream_closeIsPropagated() {
        AtomicInteger closeCountB = new AtomicInteger(0);
        Stream streamB = (Stream)Stream.of("b").onClose(closeCountB::incrementAndGet);
        Stream concatenated = Streams.concat((Stream[])new Stream[]{Stream.of("a"), streamB, Stream.empty(), Stream.of("c", "d")});
        StreamsTest.assertThat(concatenated).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
        concatenated.close();
        Truth.assertThat((Integer)closeCountB.get()).isEqualTo((Object)1);
    }

    public void testConcat_refStream_closeIsPropagated_Stream_concat() {
        AtomicInteger closeCountB = new AtomicInteger(0);
        Stream streamB = (Stream)Stream.of("b").onClose(closeCountB::incrementAndGet);
        Stream concatenated = Stream.of(Stream.of("a"), streamB, Stream.empty(), Stream.of("c", "d")).reduce(Stream.empty(), Stream::concat);
        StreamsTest.assertThat(concatenated).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
        concatenated.close();
        Truth.assertThat((Integer)closeCountB.get()).isEqualTo((Object)1);
    }

    public void testConcat_refStream_closeIsPropagated_Stream_flatMap() {
        AtomicInteger closeCountB = new AtomicInteger(0);
        Stream streamB = (Stream)Stream.of("b").onClose(closeCountB::incrementAndGet);
        Stream concatenated = Stream.of(Stream.of("a"), streamB, Stream.empty(), Stream.of("c", "d")).flatMap(x -> x);
        StreamsTest.assertThat(concatenated).containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
        concatenated.close();
        Truth.assertThat((Integer)closeCountB.get()).isEqualTo((Object)1);
    }

    public void testConcat_refStream_parallel() {
        Truth.assertThat((Object[])((Stream)Streams.concat((Stream[])new Stream[]{Stream.of("a"), Stream.of("b"), Stream.empty(), Stream.of("c", "d")}).parallel()).toArray()).asList().containsExactly(new Object[]{"a", "b", "c", "d"}).inOrder();
    }

    public void testConcat_intStream() {
        StreamsTest.assertThat(Streams.concat((IntStream[])new IntStream[]{IntStream.of(1), IntStream.of(2), IntStream.empty(), IntStream.of(3, 4)})).containsExactly(new Object[]{1, 2, 3, 4}).inOrder();
    }

    public void testConcat_longStream() {
        StreamsTest.assertThat(Streams.concat((LongStream[])new LongStream[]{LongStream.of(1L), LongStream.of(2L), LongStream.empty(), LongStream.of(3L, 4L)})).containsExactly(new Object[]{1L, 2L, 3L, 4L}).inOrder();
    }

    public void testConcat_doubleStream() {
        StreamsTest.assertThat(Streams.concat((DoubleStream[])new DoubleStream[]{DoubleStream.of(1.0), DoubleStream.of(2.0), DoubleStream.empty(), DoubleStream.of(3.0, 4.0)})).containsExactly(new Object[]{1.0, 2.0, 3.0, 4.0}).inOrder();
    }

    public void testStream_optionalInt() {
        StreamsTest.assertThat(Streams.stream((OptionalInt)OptionalInt.empty())).isEmpty();
        StreamsTest.assertThat(Streams.stream((OptionalInt)OptionalInt.of(5))).containsExactly(new Object[]{5});
    }

    public void testStream_optionalLong() {
        StreamsTest.assertThat(Streams.stream((OptionalLong)OptionalLong.empty())).isEmpty();
        StreamsTest.assertThat(Streams.stream((OptionalLong)OptionalLong.of(5L))).containsExactly(new Object[]{5L});
    }

    public void testStream_optionalDouble() {
        StreamsTest.assertThat(Streams.stream((OptionalDouble)OptionalDouble.empty())).isEmpty();
        StreamsTest.assertThat(Streams.stream((OptionalDouble)OptionalDouble.of(5.0))).containsExactly(new Object[]{5.0});
    }

    private void testMapWithIndex(Function<Collection<String>, Stream<String>> collectionImpl) {
        SpliteratorTester.of(() -> Streams.mapWithIndex((Stream)((Stream)collectionImpl.apply((Collection<String>)ImmutableList.of())), (str, i) -> str + ":" + i).spliterator()).expect((Iterable)ImmutableList.of());
        SpliteratorTester.of(() -> Streams.mapWithIndex((Stream)((Stream)collectionImpl.apply((Collection<String>)ImmutableList.of((Object)"a", (Object)"b", (Object)"c", (Object)"d", (Object)"e"))), (str, i) -> str + ":" + i).spliterator()).expect(new Object[]{"a:0", "b:1", "c:2", "d:3", "e:4"});
    }

    public void testMapWithIndex_arrayListSource() {
        this.testMapWithIndex(elems -> new ArrayList(elems).stream());
    }

    public void testMapWithIndex_linkedHashSetSource() {
        this.testMapWithIndex(elems -> new LinkedHashSet(elems).stream());
    }

    public void testMapWithIndex_unsizedSource() {
        this.testMapWithIndex(elems -> Stream.of(null).flatMap(unused -> ImmutableList.copyOf((Collection)elems).stream()));
    }

    public void testMapWithIndex_closeIsPropagated_sizedSource() {
        this.testMapWithIndex_closeIsPropagated(Stream.of("a", "b", "c"));
    }

    public void testMapWithIndex_closeIsPropagated_unsizedSource() {
        this.testMapWithIndex_closeIsPropagated(Stream.of(null).flatMap(unused -> Stream.of("a", "b", "c")));
    }

    private void testMapWithIndex_closeIsPropagated(Stream<String> source) {
        AtomicInteger stringsCloseCount = new AtomicInteger();
        Stream strings = (Stream)source.onClose(stringsCloseCount::incrementAndGet);
        Stream withIndex = Streams.mapWithIndex((Stream)strings, (str, i) -> str + ":" + i);
        withIndex.close();
        Truth.assertThat((Integer)stringsCloseCount.get()).isEqualTo((Object)1);
    }

    public void testMapWithIndex_intStream() {
        SpliteratorTester.of(() -> Streams.mapWithIndex((IntStream)IntStream.of(0, 1, 2), (x, i) -> x + ":" + i).spliterator()).expect(new Object[]{"0:0", "1:1", "2:2"});
    }

    public void testMapWithIndex_intStream_closeIsPropagated_sized() {
        this.testMapWithIndex_intStream_closeIsPropagated(IntStream.of(1, 2, 3));
    }

    public void testMapWithIndex_intStream_closeIsPropagated_unsized() {
        this.testMapWithIndex_intStream_closeIsPropagated(IntStream.of(0).flatMap(unused -> IntStream.of(1, 2, 3)));
    }

    private void testMapWithIndex_intStream_closeIsPropagated(IntStream source) {
        AtomicInteger intStreamCloseCount = new AtomicInteger();
        IntStream intStream = (IntStream)source.onClose(intStreamCloseCount::incrementAndGet);
        Stream withIndex = Streams.mapWithIndex((IntStream)intStream, (str, i) -> str + ":" + i);
        withIndex.close();
        Truth.assertThat((Integer)intStreamCloseCount.get()).isEqualTo((Object)1);
    }

    public void testMapWithIndex_longStream() {
        SpliteratorTester.of(() -> Streams.mapWithIndex((LongStream)LongStream.of(0L, 1L, 2L), (x, i) -> x + ":" + i).spliterator()).expect(new Object[]{"0:0", "1:1", "2:2"});
    }

    public void testMapWithIndex_longStream_closeIsPropagated_sized() {
        this.testMapWithIndex_longStream_closeIsPropagated(LongStream.of(1L, 2L, 3L));
    }

    public void testMapWithIndex_longStream_closeIsPropagated_unsized() {
        this.testMapWithIndex_longStream_closeIsPropagated(LongStream.of(0L).flatMap(unused -> LongStream.of(1L, 2L, 3L)));
    }

    private void testMapWithIndex_longStream_closeIsPropagated(LongStream source) {
        AtomicInteger longStreamCloseCount = new AtomicInteger();
        LongStream longStream = (LongStream)source.onClose(longStreamCloseCount::incrementAndGet);
        Stream withIndex = Streams.mapWithIndex((LongStream)longStream, (str, i) -> str + ":" + i);
        withIndex.close();
        Truth.assertThat((Integer)longStreamCloseCount.get()).isEqualTo((Object)1);
    }

    @GwtIncompatible
    public void testMapWithIndex_doubleStream() {
        SpliteratorTester.of(() -> Streams.mapWithIndex((DoubleStream)DoubleStream.of(0.0, 1.0, 2.0), (x, i) -> x + ":" + i).spliterator()).expect(new Object[]{"0.0:0", "1.0:1", "2.0:2"});
    }

    public void testMapWithIndex_doubleStream_closeIsPropagated_sized() {
        this.testMapWithIndex_doubleStream_closeIsPropagated(DoubleStream.of(1.0, 2.0, 3.0));
    }

    public void testMapWithIndex_doubleStream_closeIsPropagated_unsized() {
        this.testMapWithIndex_doubleStream_closeIsPropagated(DoubleStream.of(0.0).flatMap(unused -> DoubleStream.of(1.0, 2.0, 3.0)));
    }

    private void testMapWithIndex_doubleStream_closeIsPropagated(DoubleStream source) {
        AtomicInteger doubleStreamCloseCount = new AtomicInteger();
        DoubleStream doubleStream = (DoubleStream)source.onClose(doubleStreamCloseCount::incrementAndGet);
        Stream withIndex = Streams.mapWithIndex((DoubleStream)doubleStream, (str, i) -> str + ":" + i);
        withIndex.close();
        Truth.assertThat((Integer)doubleStreamCloseCount.get()).isEqualTo((Object)1);
    }

    public void testZip() {
        StreamsTest.assertThat(Streams.zip(Stream.of("a", "b", "c"), Stream.of(1, 2, 3), (a, b) -> a + ":" + b)).containsExactly(new Object[]{"a:1", "b:2", "c:3"}).inOrder();
    }

    public void testZip_closeIsPropagated() {
        AtomicInteger lettersCloseCount = new AtomicInteger();
        Stream letters = (Stream)Stream.of("a", "b", "c").onClose(lettersCloseCount::incrementAndGet);
        AtomicInteger numbersCloseCount = new AtomicInteger();
        Stream numbers = (Stream)Stream.of(1, 2, 3).onClose(numbersCloseCount::incrementAndGet);
        Stream zipped = Streams.zip((Stream)letters, (Stream)numbers, (a, b) -> a + ":" + b);
        zipped.close();
        Truth.assertThat((Integer)lettersCloseCount.get()).isEqualTo((Object)1);
        Truth.assertThat((Integer)numbersCloseCount.get()).isEqualTo((Object)1);
    }

    public void testZipFiniteWithInfinite() {
        StreamsTest.assertThat(Streams.zip(Stream.of("a", "b", "c"), Stream.iterate(1, i -> i + 1), (a, b) -> a + ":" + b)).containsExactly(new Object[]{"a:1", "b:2", "c:3"}).inOrder();
    }

    public void testZipInfiniteWithInfinite() {
        StreamsTest.assertThat(Streams.zip(Stream.iterate(1, i -> i + 1).map(String::valueOf), Stream.iterate(1, i -> i + 1), (str, i) -> str.equals(Integer.toString(i))).limit(100L)).doesNotContain((Object)false);
    }

    public void testZipDifferingLengths() {
        StreamsTest.assertThat(Streams.zip(Stream.of("a", "b", "c", "d"), Stream.of(1, 2, 3), (a, b) -> a + ":" + b)).containsExactly(new Object[]{"a:1", "b:2", "c:3"}).inOrder();
        StreamsTest.assertThat(Streams.zip(Stream.of("a", "b", "c"), Stream.of(1, 2, 3, 4), (a, b) -> a + ":" + b)).containsExactly(new Object[]{"a:1", "b:2", "c:3"}).inOrder();
    }

    public void testForEachPair() {
        ArrayList list = new ArrayList();
        Streams.forEachPair(Stream.of("a", "b", "c"), Stream.of(1, 2, 3), (a, b) -> list.add(a + ":" + b));
        Truth.assertThat(list).containsExactly(new Object[]{"a:1", "b:2", "c:3"});
    }

    public void testForEachPair_differingLengths1() {
        ArrayList list = new ArrayList();
        Streams.forEachPair(Stream.of("a", "b", "c", "d"), Stream.of(1, 2, 3), (a, b) -> list.add(a + ":" + b));
        Truth.assertThat(list).containsExactly(new Object[]{"a:1", "b:2", "c:3"});
    }

    public void testForEachPair_differingLengths2() {
        ArrayList list = new ArrayList();
        Streams.forEachPair(Stream.of("a", "b", "c"), Stream.of(1, 2, 3, 4), (a, b) -> list.add(a + ":" + b));
        Truth.assertThat(list).containsExactly(new Object[]{"a:1", "b:2", "c:3"});
    }

    public void testForEachPair_oneEmpty() {
        Streams.forEachPair(Stream.of("a"), Stream.empty(), (a, b) -> StreamsTest.fail());
    }

    public void testForEachPair_finiteWithInfinite() {
        ArrayList list = new ArrayList();
        Streams.forEachPair(Stream.of("a", "b", "c"), Stream.iterate(1, i -> i + 1), (a, b) -> list.add(a + ":" + b));
        Truth.assertThat(list).containsExactly(new Object[]{"a:1", "b:2", "c:3"});
    }

    public void testForEachPair_parallel() {
        Stream streamA = (Stream)IntStream.range(0, 100000).mapToObj(String::valueOf).parallel();
        Stream streamB = (Stream)IntStream.range(0, 100000).mapToObj(i -> i).parallel();
        AtomicInteger count = new AtomicInteger(0);
        Streams.forEachPair((Stream)streamA, (Stream)streamB, (a, b) -> {
            count.incrementAndGet();
            Truth.assertThat((Boolean)a.equals(String.valueOf(b))).isTrue();
        });
        Truth.assertThat((Integer)count.get()).isEqualTo((Object)100000);
    }

    private static IterableSubject assertThat(Stream<?> stream) {
        return Truth.assertThat((Object[])stream.toArray()).asList();
    }

    private static IterableSubject assertThat(IntStream stream) {
        return Truth.assertThat((int[])stream.toArray()).asList();
    }

    private static IterableSubject assertThat(LongStream stream) {
        return Truth.assertThat((long[])stream.toArray()).asList();
    }

    private static IterableSubject assertThat(DoubleStream stream) {
        return Truth.assertThat((Iterable)Doubles.asList((double[])stream.toArray()));
    }
}

