/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Synchronized;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import junit.framework.TestCase;

public class SynchronizedDequeTest
extends TestCase {
    protected Deque<String> create() {
        TestDeque inner = new TestDeque();
        Deque outer = Synchronized.deque(inner, (Object)inner.mutex);
        outer.add("foo");
        return outer;
    }

    public void testHoldsLockOnAllOperations() {
        this.create().element();
        this.create().offer("foo");
        this.create().peek();
        this.create().poll();
        this.create().remove();
        this.create().add("foo");
        this.create().addAll((Collection<String>)ImmutableList.of((Object)"foo"));
        this.create().clear();
        this.create().contains("foo");
        this.create().containsAll((Collection<?>)ImmutableList.of((Object)"foo"));
        this.create().equals(ImmutableList.of((Object)"foo"));
        this.create().hashCode();
        this.create().isEmpty();
        this.create().iterator();
        this.create().remove("foo");
        this.create().removeAll((Collection<?>)ImmutableList.of((Object)"foo"));
        this.create().retainAll((Collection<?>)ImmutableList.of((Object)"foo"));
        this.create().size();
        this.create().toArray();
        this.create().toArray(new String[]{"foo"});
        this.create().addFirst("e");
        this.create().addLast("e");
        this.create().offerFirst("e");
        this.create().offerLast("e");
        this.create().removeFirst();
        this.create().removeLast();
        this.create().pollFirst();
        this.create().pollLast();
        this.create().getFirst();
        this.create().getLast();
        this.create().peekFirst();
        this.create().peekLast();
        this.create().removeFirstOccurrence("e");
        this.create().removeLastOccurrence("e");
        this.create().push("e");
        this.create().pop();
        this.create().descendingIterator();
    }

    private static final class TestDeque<E>
    implements Deque<E> {
        private final Deque<E> delegate = Lists.newLinkedList();
        public final Object mutex = new Integer(1);
        private static final long serialVersionUID = 0L;

        private TestDeque() {
        }

        @Override
        public boolean offer(E o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.offer(o);
        }

        @Override
        public E poll() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.poll();
        }

        @Override
        public E remove() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.remove();
        }

        @Override
        public E peek() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.peek();
        }

        @Override
        public E element() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.element();
        }

        @Override
        public Iterator<E> iterator() {
            TestCase.assertFalse((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.iterator();
        }

        @Override
        public int size() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.removeAll(collection);
        }

        @Override
        public boolean isEmpty() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.contains(object);
        }

        @Override
        public boolean add(E element) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.add(element);
        }

        @Override
        public boolean remove(Object object) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.retainAll(collection);
        }

        @Override
        public void clear() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.clear();
        }

        @Override
        public Object[] toArray() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.toArray(array);
        }

        @Override
        public void addFirst(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.addFirst(e);
        }

        @Override
        public void addLast(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.addLast(e);
        }

        @Override
        public boolean offerFirst(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.offerFirst(e);
        }

        @Override
        public boolean offerLast(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.offerLast(e);
        }

        @Override
        public E removeFirst() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.removeFirst();
        }

        @Override
        public E removeLast() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.removeLast();
        }

        @Override
        public E pollFirst() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.pollFirst();
        }

        @Override
        public E pollLast() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.pollLast();
        }

        @Override
        public E getFirst() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.getFirst();
        }

        @Override
        public E getLast() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.getLast();
        }

        @Override
        public E peekFirst() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.peekFirst();
        }

        @Override
        public E peekLast() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.peekLast();
        }

        @Override
        public boolean removeFirstOccurrence(Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.removeFirstOccurrence(o);
        }

        @Override
        public boolean removeLastOccurrence(Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.removeLastOccurrence(o);
        }

        @Override
        public void push(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.push(e);
        }

        @Override
        public E pop() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.pop();
        }

        @Override
        public Iterator<E> descendingIterator() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.descendingIterator();
        }
    }
}

