/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ForwardingSetMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TreeMultimap;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.MultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.SetMultimapTestSuiteBuilder;
import com.google.common.collect.testing.google.TestSetMultimapGenerator;
import com.google.common.collect.testing.google.TestStringSetMultimapGenerator;
import com.google.common.truth.Truth;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SynchronizedMultimapTest
extends TestCase {
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SynchronizedMultimapTest.class);
        suite.addTest((Test)((MultimapTestSuiteBuilder)((MultimapTestSuiteBuilder)SetMultimapTestSuiteBuilder.using((TestSetMultimapGenerator)new TestStringSetMultimapGenerator(){

            protected SetMultimap<String, String> create(Map.Entry<String, String>[] entries) {
                TestMultimap inner = new TestMultimap();
                SetMultimap outer = Synchronized.setMultimap(inner, (Object)inner.mutex);
                for (Map.Entry<String, String> entry : entries) {
                    outer.put((Object)entry.getKey(), (Object)entry.getValue());
                }
                return outer;
            }
        }).named("Synchronized.setMultimap")).withFeatures(new Feature[]{MapFeature.GENERAL_PURPOSE, CollectionSize.ANY, CollectionFeature.SERIALIZABLE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, MapFeature.ALLOWS_NULL_KEYS, MapFeature.ALLOWS_NULL_VALUES, MapFeature.ALLOWS_ANY_NULL_QUERIES})).createTestSuite());
        return suite;
    }

    public void testSynchronizedListMultimap() {
        ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)ArrayListMultimap.create());
        multimap.putAll((Object)"foo", Arrays.asList(3, -1, 2, 4, 1));
        multimap.putAll((Object)"bar", Arrays.asList(1, 2, 3, 1));
        Truth.assertThat((Iterable)multimap.removeAll((Object)"foo")).containsExactly(new Object[]{3, -1, 2, 4, 1}).inOrder();
        SynchronizedMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"foo"));
        Truth.assertThat((Iterable)multimap.replaceValues((Object)"bar", Arrays.asList(6, 5))).containsExactly(new Object[]{1, 2, 3, 1}).inOrder();
        Truth.assertThat((Iterable)multimap.get((Object)"bar")).containsExactly(new Object[]{6, 5}).inOrder();
    }

    public void testSynchronizedSortedSetMultimap() {
        SortedSetMultimap multimap = Multimaps.synchronizedSortedSetMultimap((SortedSetMultimap)TreeMultimap.create());
        multimap.putAll((Object)"foo", Arrays.asList(3, -1, 2, 4, 1));
        multimap.putAll((Object)"bar", Arrays.asList(1, 2, 3, 1));
        Truth.assertThat((SortedSet)multimap.removeAll((Object)"foo")).containsExactly(new Object[]{-1, 1, 2, 3, 4}).inOrder();
        SynchronizedMultimapTest.assertFalse((boolean)multimap.containsKey((Object)"foo"));
        Truth.assertThat((SortedSet)multimap.replaceValues((Object)"bar", Arrays.asList(6, 5))).containsExactly(new Object[]{1, 2, 3}).inOrder();
        Truth.assertThat((SortedSet)multimap.get((Object)"bar")).containsExactly(new Object[]{5, 6}).inOrder();
    }

    public void testSynchronizedArrayListMultimapRandomAccess() {
        ArrayListMultimap delegate = ArrayListMultimap.create();
        delegate.put((Object)"foo", (Object)1);
        delegate.put((Object)"foo", (Object)3);
        ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)delegate);
        SynchronizedMultimapTest.assertTrue((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
        SynchronizedMultimapTest.assertTrue((boolean)(multimap.get((Object)"bar") instanceof RandomAccess));
    }

    public void testSynchronizedLinkedListMultimapRandomAccess() {
        LinkedListMultimap delegate = LinkedListMultimap.create();
        delegate.put((Object)"foo", (Object)1);
        delegate.put((Object)"foo", (Object)3);
        ListMultimap multimap = Multimaps.synchronizedListMultimap((ListMultimap)delegate);
        SynchronizedMultimapTest.assertFalse((boolean)(multimap.get((Object)"foo") instanceof RandomAccess));
        SynchronizedMultimapTest.assertFalse((boolean)(multimap.get((Object)"bar") instanceof RandomAccess));
    }

    private static final class TestMultimap<K, V>
    extends ForwardingSetMultimap<K, V>
    implements Serializable {
        final SetMultimap<K, V> delegate = HashMultimap.create();
        public final Object mutex = new Integer(1);
        private static final long serialVersionUID = 0L;

        private TestMultimap() {
        }

        protected SetMultimap<K, V> delegate() {
            return this.delegate;
        }

        public String toString() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.toString();
        }

        public boolean equals(@Nullable Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.equals(o);
        }

        public int hashCode() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.hashCode();
        }

        public int size() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.size();
        }

        public boolean isEmpty() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.isEmpty();
        }

        public boolean containsKey(@Nullable Object key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsKey(key);
        }

        public boolean containsValue(@Nullable Object value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsValue(value);
        }

        public boolean containsEntry(@Nullable Object key, @Nullable Object value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsEntry(key, value);
        }

        public Set<V> get(@Nullable K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.get(key);
        }

        public boolean put(K key, V value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.put(key, value);
        }

        public boolean putAll(@Nullable K key, Iterable<? extends V> values) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.putAll(key, values);
        }

        public boolean putAll(Multimap<? extends K, ? extends V> map) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.putAll(map);
        }

        public Set<V> replaceValues(@Nullable K key, Iterable<? extends V> values) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.replaceValues(key, values);
        }

        public boolean remove(@Nullable Object key, @Nullable Object value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.remove(key, value);
        }

        public Set<V> removeAll(@Nullable Object key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.removeAll(key);
        }

        public void clear() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            super.clear();
        }

        public Set<K> keySet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.keySet();
        }

        public Multiset<K> keys() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.keys();
        }

        public Collection<V> values() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.values();
        }

        public Set<Map.Entry<K, V>> entries() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.entries();
        }

        public Map<K, Collection<V>> asMap() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.asMap();
        }
    }
}

