/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.Ordering;
import com.google.common.collect.Synchronized;
import com.google.common.collect.SynchronizedMapTest;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.NavigableMapTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeMap;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.testing.SerializableTester;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SynchronizedNavigableMapTest
extends SynchronizedMapTest {
    protected <K, V> NavigableMap<K, V> create() {
        SafeTreeMap innermost = new SafeTreeMap((Comparator)Ordering.natural().nullsFirst());
        TestMap inner = new TestMap(innermost, this.mutex);
        NavigableMap outer = Synchronized.navigableMap(inner, (Object)this.mutex);
        return outer;
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SynchronizedNavigableMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)NavigableMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){
            private final Object mutex = new Integer(1);

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                SafeTreeMap innermost = new SafeTreeMap();
                for (Map.Entry<String, String> entry : entries) {
                    innermost.put(entry.getKey(), entry.getValue());
                }
                TestMap inner = new TestMap(innermost, this.mutex);
                NavigableMap outer = Synchronized.navigableMap(inner, (Object)this.mutex);
                return outer;
            }
        }).named("Maps.synchronizedNavigableMap[SafeTreeMap]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, MapFeature.GENERAL_PURPOSE, MapFeature.ALLOWS_NULL_VALUES, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        return suite;
    }

    public void testComparator() {
        this.create().comparator();
    }

    public void testCeilingEntry() {
        this.create().ceilingEntry("a");
    }

    public void testCeilingKey() {
        this.create().ceilingKey("a");
    }

    public void testDescendingKeySet() {
        Map map = this.create();
        NavigableSet descendingKeySet = map.descendingKeySet();
        SynchronizedNavigableMapTest.assertTrue((boolean)(descendingKeySet instanceof Synchronized.SynchronizedNavigableSet));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedNavigableSet)descendingKeySet).mutex);
    }

    public void testDescendingMap() {
        Map map = this.create();
        NavigableMap descendingMap = map.descendingMap();
        SynchronizedNavigableMapTest.assertTrue((boolean)(descendingMap instanceof Synchronized.SynchronizedNavigableMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedNavigableMap)descendingMap).mutex);
    }

    public void testFirstEntry() {
        this.create().firstEntry();
    }

    public void testFirstKey() {
        Map map = this.create();
        map.put("a", 1);
        map.firstKey();
    }

    public void testFloorEntry() {
        this.create().floorEntry("a");
    }

    public void testFloorKey() {
        this.create().floorKey("a");
    }

    public void testHeadMap_K() {
        Map map = this.create();
        SortedMap headMap = map.headMap("a");
        SynchronizedNavigableMapTest.assertTrue((boolean)(headMap instanceof Synchronized.SynchronizedSortedMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedSortedMap)headMap).mutex);
    }

    public void testHeadMap_K_B() {
        Map map = this.create();
        NavigableMap headMap = map.headMap("a", true);
        SynchronizedNavigableMapTest.assertTrue((boolean)(headMap instanceof Synchronized.SynchronizedNavigableMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedNavigableMap)headMap).mutex);
    }

    public void testHigherEntry() {
        this.create().higherEntry("a");
    }

    public void testHigherKey() {
        this.create().higherKey("a");
    }

    public void testLastEntry() {
        this.create().lastEntry();
    }

    public void testLastKey() {
        Map map = this.create();
        map.put("a", 1);
        map.lastKey();
    }

    public void testLowerEntry() {
        this.create().lowerEntry("a");
    }

    public void testLowerKey() {
        this.create().lowerKey("a");
    }

    public void testNavigableKeySet() {
        Map map = this.create();
        NavigableSet navigableKeySet = map.navigableKeySet();
        SynchronizedNavigableMapTest.assertTrue((boolean)(navigableKeySet instanceof Synchronized.SynchronizedNavigableSet));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedNavigableSet)navigableKeySet).mutex);
    }

    public void testPollFirstEntry() {
        this.create().pollFirstEntry();
    }

    public void testPollLastEntry() {
        this.create().pollLastEntry();
    }

    public void testSubMap_K_K() {
        Map map = this.create();
        SortedMap subMap = map.subMap("a", "b");
        SynchronizedNavigableMapTest.assertTrue((boolean)(subMap instanceof Synchronized.SynchronizedSortedMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedSortedMap)subMap).mutex);
    }

    public void testSubMap_K_B_K_B() {
        Map map = this.create();
        NavigableMap subMap = map.subMap("a", true, "b", false);
        SynchronizedNavigableMapTest.assertTrue((boolean)(subMap instanceof Synchronized.SynchronizedNavigableMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedNavigableMap)subMap).mutex);
    }

    public void testTailMap_K() {
        Map map = this.create();
        SortedMap subMap = map.tailMap("a");
        SynchronizedNavigableMapTest.assertTrue((boolean)(subMap instanceof Synchronized.SynchronizedSortedMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedSortedMap)subMap).mutex);
    }

    public void testTailMap_K_B() {
        Map map = this.create();
        NavigableMap subMap = map.tailMap("a", true);
        SynchronizedNavigableMapTest.assertTrue((boolean)(subMap instanceof Synchronized.SynchronizedNavigableMap));
        SynchronizedNavigableMapTest.assertSame((Object)this.mutex, (Object)((Synchronized.SynchronizedNavigableMap)subMap).mutex);
    }

    @Override
    public void testSerialization() {
        SerializableTester.reserializeAndAssert((Object)this.create());
    }

    static class TestMap<K, V>
    extends SynchronizedMapTest.TestMap<K, V>
    implements NavigableMap<K, V> {
        private static final long serialVersionUID = 0L;

        public TestMap(NavigableMap<K, V> delegate, Object mutex) {
            super(delegate, mutex);
        }

        @Override
        protected NavigableMap<K, V> delegate() {
            return (NavigableMap)super.delegate();
        }

        @Override
        public Map.Entry<K, V> ceilingEntry(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().ceilingEntry(key);
        }

        @Override
        public K ceilingKey(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().ceilingKey(key);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().descendingKeySet();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().descendingMap();
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().firstEntry();
        }

        @Override
        public Map.Entry<K, V> floorEntry(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().floorEntry(key);
        }

        @Override
        public K floorKey(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().floorKey(key);
        }

        @Override
        public NavigableMap<K, V> headMap(K toKey, boolean inclusive) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().headMap(toKey, inclusive);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return this.headMap(toKey, false);
        }

        @Override
        public Map.Entry<K, V> higherEntry(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().higherEntry(key);
        }

        @Override
        public K higherKey(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().higherKey(key);
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lowerEntry(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().lowerEntry(key);
        }

        @Override
        public K lowerKey(K key) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().lowerKey(key);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().navigableKeySet();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().pollFirstEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().pollLastEntry();
        }

        @Override
        public NavigableMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().subMap(fromKey, fromInclusive, toKey, toInclusive);
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return this.delegate().subMap(fromKey, true, toKey, false);
        }

        @Override
        public NavigableMap<K, V> tailMap(K fromKey, boolean inclusive) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().tailMap(fromKey, inclusive);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return this.tailMap(fromKey, true);
        }

        @Override
        public Comparator<? super K> comparator() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().comparator();
        }

        @Override
        public K firstKey() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().firstKey();
        }

        @Override
        public K lastKey() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().lastKey();
        }
    }

    static class TestEntry<K, V>
    extends ForwardingMapEntry<K, V>
    implements Serializable {
        private final Map.Entry<K, V> delegate;
        private final Object mutex;
        private static final long serialVersionUID = 0L;

        TestEntry(Map.Entry<K, V> delegate, Object mutex) {
            this.delegate = delegate;
            this.mutex = mutex;
        }

        protected Map.Entry<K, V> delegate() {
            return this.delegate;
        }

        public boolean equals(Object object) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.equals(object);
        }

        public K getKey() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (K)super.getKey();
        }

        public V getValue() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)super.getValue();
        }

        public int hashCode() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.hashCode();
        }

        public V setValue(V value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)super.setValue(value);
        }
    }
}

