/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Ordering;
import com.google.common.collect.Synchronized;
import com.google.common.collect.SynchronizedSetTest;
import com.google.common.collect.testing.NavigableSetTestSuiteBuilder;
import com.google.common.collect.testing.SafeTreeSet;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSortedSetGenerator;
import com.google.common.collect.testing.TestStringSortedSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeSet;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class SynchronizedNavigableSetTest
extends TestCase {
    protected <E> NavigableSet<E> create() {
        TestSet inner = new TestSet(new TreeSet(Ordering.natural().nullsFirst()), (Object)null);
        NavigableSet outer = Synchronized.navigableSet(inner, null);
        inner.mutex = outer;
        return outer;
    }

    public static TestSuite suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(SynchronizedNavigableSetTest.class);
        suite.addTest((Test)((SetTestSuiteBuilder)((SetTestSuiteBuilder)NavigableSetTestSuiteBuilder.using((TestSortedSetGenerator)new TestStringSortedSetGenerator(){

            protected NavigableSet<String> create(String[] elements) {
                SafeTreeSet innermost = new SafeTreeSet();
                Collections.addAll(innermost, elements);
                TestSet inner = new TestSet(innermost, (Object)null);
                NavigableSet outer = Synchronized.navigableSet(inner, null);
                inner.mutex = outer;
                return outer;
            }

            public List<String> order(List<String> insertionOrder) {
                return Ordering.natural().sortedCopy(insertionOrder);
            }
        }).named("Sets.synchronizedNavigableSet[SafeTreeSet]")).withFeatures(new Feature[]{CollectionSize.ANY, CollectionFeature.KNOWN_ORDER, CollectionFeature.GENERAL_PURPOSE, CollectionFeature.SERIALIZABLE})).createTestSuite());
        return suite;
    }

    public void testDescendingSet() {
        NavigableSet set = this.create();
        NavigableSet descendingSet = set.descendingSet();
        SynchronizedNavigableSetTest.assertTrue((boolean)(descendingSet instanceof Synchronized.SynchronizedNavigableSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedNavigableSet)descendingSet).mutex);
    }

    public void testHeadSet_E() {
        NavigableSet<String> set = this.create();
        SortedSet<String> headSet = set.headSet("a");
        SynchronizedNavigableSetTest.assertTrue((boolean)(headSet instanceof Synchronized.SynchronizedSortedSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedSortedSet)headSet).mutex);
    }

    public void testHeadSet_E_B() {
        NavigableSet<String> set = this.create();
        NavigableSet<String> headSet = set.headSet("a", true);
        SynchronizedNavigableSetTest.assertTrue((boolean)(headSet instanceof Synchronized.SynchronizedNavigableSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedNavigableSet)headSet).mutex);
    }

    public void testSubSet_E_E() {
        NavigableSet<String> set = this.create();
        SortedSet<String> subSet = set.subSet("a", "b");
        SynchronizedNavigableSetTest.assertTrue((boolean)(subSet instanceof Synchronized.SynchronizedSortedSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedSortedSet)subSet).mutex);
    }

    public void testSubSet_E_B_E_B() {
        NavigableSet<String> set = this.create();
        NavigableSet<String> subSet = set.subSet("a", false, "b", true);
        SynchronizedNavigableSetTest.assertTrue((boolean)(subSet instanceof Synchronized.SynchronizedNavigableSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedNavigableSet)subSet).mutex);
    }

    public void testTailSet_E() {
        NavigableSet<String> set = this.create();
        SortedSet<String> tailSet = set.tailSet("a");
        SynchronizedNavigableSetTest.assertTrue((boolean)(tailSet instanceof Synchronized.SynchronizedSortedSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedSortedSet)tailSet).mutex);
    }

    public void testTailSet_E_B() {
        NavigableSet<String> set = this.create();
        NavigableSet<String> tailSet = set.tailSet("a", true);
        SynchronizedNavigableSetTest.assertTrue((boolean)(tailSet instanceof Synchronized.SynchronizedNavigableSet));
        SynchronizedNavigableSetTest.assertSame(set, (Object)((Synchronized.SynchronizedNavigableSet)tailSet).mutex);
    }

    static class TestSet<E>
    extends SynchronizedSetTest.TestSet<E>
    implements NavigableSet<E> {
        private static final long serialVersionUID = 0L;

        TestSet(NavigableSet<E> delegate, Object mutex) {
            super(delegate, mutex);
        }

        @Override
        protected NavigableSet<E> delegate() {
            return (NavigableSet)super.delegate();
        }

        @Override
        public E ceiling(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().ceiling(e);
        }

        @Override
        public Iterator<E> descendingIterator() {
            return this.delegate().descendingIterator();
        }

        @Override
        public NavigableSet<E> descendingSet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().descendingSet();
        }

        @Override
        public E floor(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().floor(e);
        }

        @Override
        public NavigableSet<E> headSet(E toElement, boolean inclusive) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().headSet(toElement, inclusive);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return this.headSet(toElement, false);
        }

        @Override
        public E higher(E e) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().higher(e);
        }

        @Override
        public E lower(E e) {
            return this.delegate().lower(e);
        }

        @Override
        public E pollFirst() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().pollFirst();
        }

        @Override
        public E pollLast() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().pollLast();
        }

        @Override
        public NavigableSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().subSet(fromElement, fromInclusive, toElement, toInclusive);
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return this.subSet(fromElement, true, toElement, false);
        }

        @Override
        public NavigableSet<E> tailSet(E fromElement, boolean inclusive) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().tailSet(fromElement, inclusive);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return this.tailSet(fromElement, true);
        }

        @Override
        public Comparator<? super E> comparator() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().comparator();
        }

        @Override
        public E first() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().first();
        }

        @Override
        public E last() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate().last();
        }
    }
}

