/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Synchronized;
import java.util.Collection;
import java.util.Iterator;
import java.util.Queue;
import junit.framework.TestCase;

public class SynchronizedQueueTest
extends TestCase {
    protected Queue<String> create() {
        TestQueue inner = new TestQueue();
        Queue outer = Synchronized.queue(inner, null);
        inner.mutex = outer;
        outer.add("foo");
        return outer;
    }

    public void testHoldsLockOnAllOperations() {
        this.create().element();
        this.create().offer("foo");
        this.create().peek();
        this.create().poll();
        this.create().remove();
        this.create().add("foo");
        this.create().addAll((Collection<String>)ImmutableList.of((Object)"foo"));
        this.create().clear();
        this.create().contains("foo");
        this.create().containsAll((Collection<?>)ImmutableList.of((Object)"foo"));
        this.create().equals(ImmutableList.of((Object)"foo"));
        this.create().hashCode();
        this.create().isEmpty();
        this.create().iterator();
        this.create().remove("foo");
        this.create().removeAll((Collection<?>)ImmutableList.of((Object)"foo"));
        this.create().retainAll((Collection<?>)ImmutableList.of((Object)"foo"));
        this.create().size();
        this.create().toArray();
        this.create().toArray(new String[]{"foo"});
    }

    private static final class TestQueue<E>
    implements Queue<E> {
        private final Queue<E> delegate = Lists.newLinkedList();
        public Object mutex;
        private static final long serialVersionUID = 0L;

        private TestQueue() {
        }

        @Override
        public boolean offer(E o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.offer(o);
        }

        @Override
        public E poll() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.poll();
        }

        @Override
        public E remove() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.remove();
        }

        @Override
        public E peek() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.peek();
        }

        @Override
        public E element() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.element();
        }

        @Override
        public Iterator<E> iterator() {
            TestCase.assertFalse((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.iterator();
        }

        @Override
        public int size() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.size();
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.removeAll(collection);
        }

        @Override
        public boolean isEmpty() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.isEmpty();
        }

        @Override
        public boolean contains(Object object) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.contains(object);
        }

        @Override
        public boolean add(E element) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.add(element);
        }

        @Override
        public boolean remove(Object object) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.remove(object);
        }

        @Override
        public boolean containsAll(Collection<?> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.containsAll(collection);
        }

        @Override
        public boolean addAll(Collection<? extends E> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.addAll(collection);
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.retainAll(collection);
        }

        @Override
        public void clear() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.clear();
        }

        @Override
        public Object[] toArray() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.toArray();
        }

        @Override
        public <T> T[] toArray(T[] array) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.toArray(array);
        }
    }
}

