/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.Synchronized;
import com.google.common.collect.testing.SetTestSuiteBuilder;
import com.google.common.collect.testing.TestSetGenerator;
import com.google.common.collect.testing.TestStringSetGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import junit.framework.Test;
import junit.framework.TestCase;

public class SynchronizedSetTest
extends TestCase {
    public static final Object MUTEX = new Integer(1);

    public static Test suite() {
        return ((SetTestSuiteBuilder)((SetTestSuiteBuilder)SetTestSuiteBuilder.using((TestSetGenerator)new TestStringSetGenerator(){

            protected Set<String> create(String[] elements) {
                TestSet inner = new TestSet(new HashSet(), null);
                Set outer = Synchronized.set(inner, null);
                inner.mutex = outer;
                Collections.addAll(outer, elements);
                return outer;
            }
        }).named("Synchronized.set")).withFeatures(new Feature[]{CollectionFeature.GENERAL_PURPOSE, CollectionFeature.ALLOWS_NULL_VALUES, CollectionSize.ANY, CollectionFeature.SERIALIZABLE})).createTestSuite();
    }

    static class TestSet<E>
    extends ForwardingSet<E>
    implements Serializable {
        final Set<E> delegate;
        public Object mutex;
        private static final long serialVersionUID = 0L;

        public TestSet(Set<E> delegate, Object mutex) {
            this.delegate = delegate;
            this.mutex = mutex;
        }

        protected Set<E> delegate() {
            return this.delegate;
        }

        public String toString() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.toString();
        }

        public boolean equals(@Nullable Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.equals(o);
        }

        public int hashCode() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.hashCode();
        }

        public boolean add(@Nullable E o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.add(o);
        }

        public boolean addAll(Collection<? extends E> c) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.addAll(c);
        }

        public void clear() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            super.clear();
        }

        public boolean contains(@Nullable Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.contains(o);
        }

        public boolean containsAll(Collection<?> c) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.containsAll(c);
        }

        public boolean isEmpty() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.isEmpty();
        }

        public boolean remove(@Nullable Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.remove(o);
        }

        public boolean removeAll(Collection<?> c) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.removeAll(c);
        }

        public boolean retainAll(Collection<?> c) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.retainAll(c);
        }

        public int size() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.size();
        }

        public Object[] toArray() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.toArray();
        }

        public <T> T[] toArray(T[] a) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return super.toArray((Object[])a);
        }
    }
}

