/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Synchronized;
import com.google.common.collect.Table;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import junit.framework.TestCase;

public class SynchronizedTableTest
extends AbstractTableTest {
    @Override
    protected Table<String, Integer, Character> create(Object ... data) {
        TestTable table = new TestTable();
        Table synced = Synchronized.table(table, (Object)table.mutex);
        this.populate((Table<String, Integer, Character>)synced, data);
        return synced;
    }

    private static final class TestTable<R, C, V>
    implements Table<R, C, V>,
    Serializable {
        final Table<R, C, V> delegate = HashBasedTable.create();
        public final Object mutex = new Integer(1);
        private static final long serialVersionUID = 0L;

        private TestTable() {
        }

        public String toString() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.toString();
        }

        public boolean equals(@Nullable Object o) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.equals(o);
        }

        public int hashCode() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.hashCode();
        }

        public int size() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.size();
        }

        public boolean isEmpty() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.isEmpty();
        }

        public boolean containsValue(@Nullable Object value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.containsValue(value);
        }

        public void clear() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.clear();
        }

        public Collection<V> values() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.values();
        }

        public Set<Table.Cell<R, C, V>> cellSet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.cellSet();
        }

        public Map<R, V> column(C columnKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.column(columnKey);
        }

        public Set<C> columnKeySet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.columnKeySet();
        }

        public Map<C, Map<R, V>> columnMap() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.columnMap();
        }

        public boolean contains(Object rowKey, Object columnKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.contains(rowKey, columnKey);
        }

        public boolean containsColumn(Object columnKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.containsColumn(columnKey);
        }

        public boolean containsRow(Object rowKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.containsRow(rowKey);
        }

        public V get(Object rowKey, Object columnKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)this.delegate.get(rowKey, columnKey);
        }

        public V put(R rowKey, C columnKey, V value) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)this.delegate.put(rowKey, columnKey, value);
        }

        public void putAll(Table<? extends R, ? extends C, ? extends V> table) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            this.delegate.putAll(table);
        }

        public V remove(Object rowKey, Object columnKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return (V)this.delegate.remove(rowKey, columnKey);
        }

        public Map<C, V> row(R rowKey) {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.row(rowKey);
        }

        public Set<R> rowKeySet() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.rowKeySet();
        }

        public Map<R, Map<C, V>> rowMap() {
            TestCase.assertTrue((boolean)Thread.holdsLock(this.mutex));
            return this.delegate.rowMap();
        }
    }
}

