/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Equivalence;
import com.google.common.collect.ArrayTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import com.google.common.testing.CollectorTester;
import com.google.common.testing.EqualsTester;
import com.google.common.testing.SerializableTester;
import java.util.function.BiPredicate;
import java.util.stream.Collector;
import java.util.stream.Stream;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class TablesTest
extends TestCase {
    public void testToTable() {
        Collector collector = Tables.toTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, HashBasedTable::create);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(Table::cellSet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)new ImmutableTable.Builder().put((Object)"one", (Object)"uno", (Object)1).put((Object)"two", (Object)"dos", (Object)2).put((Object)"three", (Object)"tres", (Object)3).build(), (Object[])new Table.Cell[]{Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"two", (Object)"dos", (Object)2), Tables.immutableCell((Object)"three", (Object)"tres", (Object)3)});
    }

    public void testToTableNullMerge() {
        Collector collector = Tables.toTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, (v1, v2) -> null, HashBasedTable::create);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(Table::cellSet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)ImmutableTable.of(), (Object[])new Table.Cell[]{Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"one", (Object)"uno", (Object)2)});
    }

    public void testToTableNullValues() {
        Collector collector = Tables.toTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, () -> ArrayTable.create((Iterable)ImmutableList.of((Object)"one"), (Iterable)ImmutableList.of((Object)"uno")));
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)null)).collect(collector);
            TablesTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testToTableConflict() {
        Collector collector = Tables.toTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, HashBasedTable::create);
        try {
            Stream.of(Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"one", (Object)"uno", (Object)2)).collect(collector);
            TablesTest.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testToTableMerging() {
        Collector collector = Tables.toTable(Table.Cell::getRowKey, Table.Cell::getColumnKey, Table.Cell::getValue, Integer::sum, HashBasedTable::create);
        Equivalence equivalence = Equivalence.equals().pairwise().onResultOf(Table::cellSet);
        CollectorTester.of((Collector)collector, (BiPredicate)equivalence).expectCollects((Object)new ImmutableTable.Builder().put((Object)"one", (Object)"uno", (Object)1).put((Object)"two", (Object)"dos", (Object)6).put((Object)"three", (Object)"tres", (Object)3).build(), (Object[])new Table.Cell[]{Tables.immutableCell((Object)"one", (Object)"uno", (Object)1), Tables.immutableCell((Object)"two", (Object)"dos", (Object)2), Tables.immutableCell((Object)"three", (Object)"tres", (Object)3), Tables.immutableCell((Object)"two", (Object)"dos", (Object)4)});
    }

    @GwtIncompatible
    public void testImmutableEntrySerialization() {
        Table.Cell entry = Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        SerializableTester.reserializeAndAssert((Object)entry);
    }

    public void testImmutableEntryToString() {
        Table.Cell entry = Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        TablesTest.assertEquals((String)"(foo,1)=a", (String)entry.toString());
        Table.Cell nullEntry = Tables.immutableCell(null, null, null);
        TablesTest.assertEquals((String)"(null,null)=null", (String)nullEntry.toString());
    }

    public void testEntryEquals() {
        Table.Cell entry = Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'));
        new EqualsTester().addEqualityGroup(new Object[]{entry, Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"bar", (Object)1, (Object)Character.valueOf('a'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"foo", (Object)2, (Object)Character.valueOf('a'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('b'))}).addEqualityGroup(new Object[]{Tables.immutableCell(null, null, null)}).testEquals();
    }

    public void testEntryEqualsNull() {
        Table.Cell entry = Tables.immutableCell(null, null, null);
        new EqualsTester().addEqualityGroup(new Object[]{entry, Tables.immutableCell(null, null, null)}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"bar", null, null)}).addEqualityGroup(new Object[]{Tables.immutableCell(null, (Object)2, null)}).addEqualityGroup(new Object[]{Tables.immutableCell(null, null, (Object)Character.valueOf('b'))}).addEqualityGroup(new Object[]{Tables.immutableCell((Object)"foo", (Object)1, (Object)Character.valueOf('a'))}).testEquals();
    }
}

