/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.TopKSelector;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import com.google.common.truth.Truth;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import junit.framework.TestCase;

public class TopKSelectorTest
extends TestCase {
    public void testNegativeK() {
        try {
            TopKSelector.least((int)-1);
            TopKSelectorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TopKSelector.greatest((int)-1);
            TopKSelectorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TopKSelector.least((int)-1, (Comparator)Ordering.natural());
            TopKSelectorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            TopKSelector.greatest((int)-1, (Comparator)Ordering.natural());
            TopKSelectorTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testZeroK() {
        TopKSelector top = TopKSelector.least((int)0);
        for (int i = 0; i < 10; ++i) {
            top.offer((Object)i);
        }
        Truth.assertThat((Iterable)top.topK()).isEmpty();
    }

    public void testNoElementsOffered() {
        TopKSelector top = TopKSelector.least((int)10);
        Truth.assertThat((Iterable)top.topK()).isEmpty();
    }

    public void testOfferedFewerThanK() {
        TopKSelector top = TopKSelector.least((int)10);
        top.offer((Object)3);
        top.offer((Object)5);
        top.offer((Object)2);
        Truth.assertThat((Iterable)top.topK()).containsExactly(new Object[]{2, 3, 5}).inOrder();
    }

    public void testOfferedKPlusOne() {
        for (List list : Collections2.permutations((Collection)Ints.asList((int[])new int[]{1, 2, 3, 4, 5}))) {
            TopKSelector top = TopKSelector.least((int)4);
            top.offerAll((Iterable)list);
            Truth.assertThat((Iterable)top.topK()).containsExactly(new Object[]{1, 2, 3, 4}).inOrder();
        }
    }

    public void testOfferedThreeK() {
        for (List list : Collections2.permutations((Collection)Ints.asList((int[])new int[]{1, 2, 3, 4, 5, 6}))) {
            TopKSelector top = TopKSelector.least((int)2);
            top.offerAll((Iterable)list);
            Truth.assertThat((Iterable)top.topK()).containsExactly(new Object[]{1, 2}).inOrder();
        }
    }

    public void testDifferentComparator() {
        TopKSelector top = TopKSelector.least((int)3, (Comparator)String.CASE_INSENSITIVE_ORDER);
        top.offerAll((Iterable)ImmutableList.of((Object)"a", (Object)"B", (Object)"c", (Object)"D", (Object)"e", (Object)"F"));
        Truth.assertThat((Iterable)top.topK()).containsExactly(new Object[]{"a", "B", "c"}).inOrder();
    }

    public void testWorstCase() {
        int n = 2000000;
        int k = 200000;
        final long[] compareCalls = new long[]{0L};
        Comparator<Integer> cmp = new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                compareCalls[0] = compareCalls[0] + 1L;
                return o1.compareTo(o2);
            }
        };
        TopKSelector top = TopKSelector.least((int)k, (Comparator)cmp);
        top.offer((Object)1);
        for (int i = 1; i < n; ++i) {
            top.offer((Object)0);
        }
        Truth.assertThat((Iterable)top.topK()).containsExactlyElementsIn(Collections.nCopies(k, 0));
        Truth.assertThat((Long)compareCalls[0]).isAtMost((Comparable)Long.valueOf(10L * (long)n * (long)IntMath.log2((int)k, (RoundingMode)RoundingMode.CEILING)));
    }
}

