/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractTableTest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.SortedMapInterfaceTest;
import com.google.common.collect.testing.SortedMapTestSuiteBuilder;
import com.google.common.collect.testing.TestSortedMapGenerator;
import com.google.common.collect.testing.TestStringSortedMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.testing.SerializableTester;
import com.google.common.truth.Truth;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import junit.framework.Test;
import junit.framework.TestSuite;

@GwtCompatible(emulated=true)
public class TreeBasedTableTest
extends AbstractTableTest {
    private TreeBasedTable<String, Integer, Character> sortedTable;

    @GwtIncompatible
    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TreeBasedTableTest.class);
        suite.addTestSuite(TreeRowTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)SortedMapTestSuiteBuilder.using((TestSortedMapGenerator)new TestStringSortedMapGenerator(){

            protected SortedMap<String, String> create(Map.Entry<String, String>[] entries) {
                TreeBasedTable table = TreeBasedTable.create();
                table.put((Object)"a", (Object)"b", (Object)"c");
                table.put((Object)"c", (Object)"b", (Object)"a");
                table.put((Object)"a", (Object)"a", (Object)"d");
                for (Map.Entry<String, String> entry : entries) {
                    table.put((Object)"b", (Object)entry.getKey(), (Object)entry.getValue());
                }
                return table.row((Object)"b");
            }
        }).withFeatures(new Feature[]{MapFeature.GENERAL_PURPOSE, CollectionFeature.SUPPORTS_ITERATOR_REMOVE, CollectionSize.ANY})).named("RowMapTestSuite")).createTestSuite());
        return suite;
    }

    protected TreeBasedTable<String, Integer, Character> create(Comparator<? super String> rowComparator, Comparator<? super Integer> columnComparator, Object ... data) {
        TreeBasedTable table = TreeBasedTable.create(rowComparator, columnComparator);
        table.put((Object)"foo", (Object)4, (Object)Character.valueOf('a'));
        table.put((Object)"cat", (Object)1, (Object)Character.valueOf('b'));
        table.clear();
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    protected TreeBasedTable<String, Integer, Character> create(Object ... data) {
        TreeBasedTable table = TreeBasedTable.create();
        table.put((Object)"foo", (Object)4, (Object)Character.valueOf('a'));
        table.put((Object)"cat", (Object)1, (Object)Character.valueOf('b'));
        table.clear();
        this.populate((Table<String, Integer, Character>)table, data);
        return table;
    }

    public void testCreateExplicitComparators() {
        this.table = TreeBasedTable.create(Collections.reverseOrder(), (Comparator)Ordering.usingToString());
        this.table.put((Object)"foo", (Object)3, (Object)Character.valueOf('a'));
        this.table.put((Object)"foo", (Object)12, (Object)Character.valueOf('b'));
        this.table.put((Object)"bar", (Object)5, (Object)Character.valueOf('c'));
        this.table.put((Object)"cat", (Object)8, (Object)Character.valueOf('d'));
        Truth.assertThat((Iterable)this.table.rowKeySet()).containsExactly(new Object[]{"foo", "cat", "bar"}).inOrder();
        Truth.assertThat(this.table.row((Object)"foo").keySet()).containsExactly(new Object[]{12, 3}).inOrder();
    }

    public void testCreateCopy() {
        TreeBasedTable original = TreeBasedTable.create(Collections.reverseOrder(), (Comparator)Ordering.usingToString());
        original.put((Object)"foo", (Object)3, (Object)Character.valueOf('a'));
        original.put((Object)"foo", (Object)12, (Object)Character.valueOf('b'));
        original.put((Object)"bar", (Object)5, (Object)Character.valueOf('c'));
        original.put((Object)"cat", (Object)8, (Object)Character.valueOf('d'));
        this.table = TreeBasedTable.create((TreeBasedTable)original);
        Truth.assertThat((Iterable)this.table.rowKeySet()).containsExactly(new Object[]{"foo", "cat", "bar"}).inOrder();
        Truth.assertThat(this.table.row((Object)"foo").keySet()).containsExactly(new Object[]{12, 3}).inOrder();
        TreeBasedTableTest.assertEquals((Object)original, (Object)this.table);
    }

    @GwtIncompatible
    public void testSerialization() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SerializableTester.reserializeAndAssert((Object)this.table);
    }

    public void testToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertEquals((String)"{bar={1=b}, foo={1=a, 3=c}}", (String)this.table.toString());
        TreeBasedTableTest.assertEquals((String)"{bar={1=b}, foo={1=a, 3=c}}", (String)this.table.rowMap().toString());
    }

    public void testCellSetToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertEquals((String)"[(bar,1)=b, (foo,1)=a, (foo,3)=c]", (String)this.table.cellSet().toString());
    }

    public void testRowKeySetToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertEquals((String)"[bar, foo]", (String)this.table.rowKeySet().toString());
    }

    public void testValuesToString_ordered() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertEquals((String)"[b, a, c]", (String)this.table.values().toString());
    }

    public void testRowComparator() {
        this.sortedTable = TreeBasedTable.create();
        TreeBasedTableTest.assertSame((Object)Ordering.natural(), (Object)this.sortedTable.rowComparator());
        this.sortedTable = TreeBasedTable.create(Collections.reverseOrder(), (Comparator)Ordering.usingToString());
        TreeBasedTableTest.assertSame(Collections.reverseOrder(), (Object)this.sortedTable.rowComparator());
    }

    public void testColumnComparator() {
        this.sortedTable = TreeBasedTable.create();
        this.sortedTable.put((Object)"", (Object)42, (Object)Character.valueOf('x'));
        TreeBasedTableTest.assertSame((Object)Ordering.natural(), (Object)this.sortedTable.columnComparator());
        TreeBasedTableTest.assertSame((Object)Ordering.natural(), ((SortedMap)this.sortedTable.rowMap().values().iterator().next()).comparator());
        this.sortedTable = TreeBasedTable.create(Collections.reverseOrder(), (Comparator)Ordering.usingToString());
        this.sortedTable.put((Object)"", (Object)42, (Object)Character.valueOf('x'));
        TreeBasedTableTest.assertSame((Object)Ordering.usingToString(), (Object)this.sortedTable.columnComparator());
        TreeBasedTableTest.assertSame((Object)Ordering.usingToString(), ((SortedMap)this.sortedTable.rowMap().values().iterator().next()).comparator());
    }

    public void testRowKeySetComparator() {
        this.sortedTable = TreeBasedTable.create();
        TreeBasedTableTest.assertSame((Object)Ordering.natural(), this.sortedTable.rowKeySet().comparator());
        this.sortedTable = TreeBasedTable.create(Collections.reverseOrder(), (Comparator)Ordering.usingToString());
        TreeBasedTableTest.assertSame(Collections.reverseOrder(), this.sortedTable.rowKeySet().comparator());
    }

    public void testRowKeySetFirst() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertSame((Object)"bar", this.sortedTable.rowKeySet().first());
    }

    public void testRowKeySetLast() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertSame((Object)"foo", this.sortedTable.rowKeySet().last());
    }

    public void testRowKeySetHeadSet() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SortedSet<String> set = this.sortedTable.rowKeySet().headSet("cat");
        TreeBasedTableTest.assertEquals(Collections.singleton("bar"), set);
        set.clear();
        TreeBasedTableTest.assertTrue((boolean)set.isEmpty());
        TreeBasedTableTest.assertEquals(Collections.singleton("foo"), (Object)this.sortedTable.rowKeySet());
    }

    public void testRowKeySetTailSet() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SortedSet<String> set = this.sortedTable.rowKeySet().tailSet("cat");
        TreeBasedTableTest.assertEquals(Collections.singleton("foo"), set);
        set.clear();
        TreeBasedTableTest.assertTrue((boolean)set.isEmpty());
        TreeBasedTableTest.assertEquals(Collections.singleton("bar"), (Object)this.sortedTable.rowKeySet());
    }

    public void testRowKeySetSubSet() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'), "dog", 2, Character.valueOf('d'));
        SortedSet<String> set = this.sortedTable.rowKeySet().subSet("cat", "egg");
        TreeBasedTableTest.assertEquals(Collections.singleton("dog"), set);
        set.clear();
        TreeBasedTableTest.assertTrue((boolean)set.isEmpty());
        TreeBasedTableTest.assertEquals((Object)ImmutableSet.of((Object)"bar", (Object)"foo"), (Object)this.sortedTable.rowKeySet());
    }

    public void testRowMapComparator() {
        this.sortedTable = TreeBasedTable.create();
        TreeBasedTableTest.assertSame((Object)Ordering.natural(), this.sortedTable.rowMap().comparator());
        this.sortedTable = TreeBasedTable.create(Collections.reverseOrder(), (Comparator)Ordering.usingToString());
        TreeBasedTableTest.assertSame(Collections.reverseOrder(), this.sortedTable.rowMap().comparator());
    }

    public void testRowMapFirstKey() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertSame((Object)"bar", this.sortedTable.rowMap().firstKey());
    }

    public void testRowMapLastKey() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        TreeBasedTableTest.assertSame((Object)"foo", this.sortedTable.rowMap().lastKey());
    }

    public void testRowKeyMapHeadMap() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SortedMap map = this.sortedTable.rowMap().headMap("cat");
        TreeBasedTableTest.assertEquals((int)1, (int)map.size());
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('b')), map.get("bar"));
        map.clear();
        TreeBasedTableTest.assertTrue((boolean)map.isEmpty());
        TreeBasedTableTest.assertEquals(Collections.singleton("foo"), (Object)this.sortedTable.rowKeySet());
    }

    public void testRowKeyMapTailMap() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SortedMap map = this.sortedTable.rowMap().tailMap("cat");
        TreeBasedTableTest.assertEquals((int)1, (int)map.size());
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('a'), (Object)3, (Object)Character.valueOf('c')), map.get("foo"));
        map.clear();
        TreeBasedTableTest.assertTrue((boolean)map.isEmpty());
        TreeBasedTableTest.assertEquals(Collections.singleton("bar"), (Object)this.sortedTable.rowKeySet());
    }

    public void testRowKeyMapSubMap() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'), "dog", 2, Character.valueOf('d'));
        SortedMap map = this.sortedTable.rowMap().subMap("cat", "egg");
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)Character.valueOf('d')), map.get("dog"));
        map.clear();
        TreeBasedTableTest.assertTrue((boolean)map.isEmpty());
        TreeBasedTableTest.assertEquals((Object)ImmutableSet.of((Object)"bar", (Object)"foo"), (Object)this.sortedTable.rowKeySet());
    }

    public void testRowMapValuesAreSorted() {
        this.sortedTable = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'), "dog", 2, Character.valueOf('d'));
        TreeBasedTableTest.assertTrue((boolean)(this.sortedTable.rowMap().get("foo") instanceof SortedMap));
    }

    public void testColumnKeySet_isSorted() {
        this.table = this.create("a", 2, Character.valueOf('X'), "a", 2, Character.valueOf('X'), "b", 3, Character.valueOf('X'), "b", 2, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 20, Character.valueOf('X'), "d", 15, Character.valueOf('X'), "d", 20, Character.valueOf('X'), "d", 1, Character.valueOf('X'), "e", 5, Character.valueOf('X'));
        TreeBasedTableTest.assertEquals((String)"[1, 2, 3, 5, 10, 15, 20]", (String)this.table.columnKeySet().toString());
    }

    public void testColumnKeySet_isSortedWithRealComparator() {
        this.table = this.create(String.CASE_INSENSITIVE_ORDER, (Comparator<? super Integer>)Ordering.natural().reverse(), "a", 2, Character.valueOf('X'), "a", 2, Character.valueOf('X'), "b", 3, Character.valueOf('X'), "b", 2, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 20, Character.valueOf('X'), "d", 15, Character.valueOf('X'), "d", 20, Character.valueOf('X'), "d", 1, Character.valueOf('X'), "e", 5, Character.valueOf('X'));
        TreeBasedTableTest.assertEquals((String)"[20, 15, 10, 5, 3, 2, 1]", (String)this.table.columnKeySet().toString());
    }

    public void testColumnKeySet_empty() {
        this.table = this.create(new Object[0]);
        TreeBasedTableTest.assertEquals((String)"[]", (String)this.table.columnKeySet().toString());
    }

    public void testColumnKeySet_oneRow() {
        this.table = this.create("a", 2, Character.valueOf('X'), "a", 1, Character.valueOf('X'));
        TreeBasedTableTest.assertEquals((String)"[1, 2]", (String)this.table.columnKeySet().toString());
    }

    public void testColumnKeySet_oneColumn() {
        this.table = this.create("a", 1, Character.valueOf('X'), "b", 1, Character.valueOf('X'));
        TreeBasedTableTest.assertEquals((String)"[1]", (String)this.table.columnKeySet().toString());
    }

    public void testColumnKeySet_oneEntry() {
        this.table = this.create("a", 1, Character.valueOf('X'));
        TreeBasedTableTest.assertEquals((String)"[1]", (String)this.table.columnKeySet().toString());
    }

    public void testRowEntrySetContains() {
        this.sortedTable = this.create("a", 2, Character.valueOf('X'), "a", 2, Character.valueOf('X'), "b", 3, Character.valueOf('X'), "b", 2, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 20, Character.valueOf('X'), "d", 15, Character.valueOf('X'), "d", 20, Character.valueOf('X'), "d", 1, Character.valueOf('X'), "e", 5, Character.valueOf('X'));
        this.table = this.sortedTable;
        SortedMap row = this.sortedTable.row((Object)"c");
        Set entrySet = row.entrySet();
        TreeBasedTableTest.assertTrue((boolean)entrySet.contains(Maps.immutableEntry((Object)10, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertTrue((boolean)entrySet.contains(Maps.immutableEntry((Object)20, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertFalse((boolean)entrySet.contains(Maps.immutableEntry((Object)15, (Object)Character.valueOf('X'))));
        entrySet = row.tailMap(15).entrySet();
        TreeBasedTableTest.assertFalse((boolean)entrySet.contains(Maps.immutableEntry((Object)10, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertTrue((boolean)entrySet.contains(Maps.immutableEntry((Object)20, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertFalse((boolean)entrySet.contains(Maps.immutableEntry((Object)15, (Object)Character.valueOf('X'))));
    }

    public void testRowEntrySetRemove() {
        this.sortedTable = this.create("a", 2, Character.valueOf('X'), "a", 2, Character.valueOf('X'), "b", 3, Character.valueOf('X'), "b", 2, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 20, Character.valueOf('X'), "d", 15, Character.valueOf('X'), "d", 20, Character.valueOf('X'), "d", 1, Character.valueOf('X'), "e", 5, Character.valueOf('X'));
        this.table = this.sortedTable;
        SortedMap row = this.sortedTable.row((Object)"c");
        Set entrySet = row.tailMap(15).entrySet();
        TreeBasedTableTest.assertFalse((boolean)entrySet.remove(Maps.immutableEntry((Object)10, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertTrue((boolean)entrySet.remove(Maps.immutableEntry((Object)20, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertFalse((boolean)entrySet.remove(Maps.immutableEntry((Object)15, (Object)Character.valueOf('X'))));
        entrySet = row.entrySet();
        TreeBasedTableTest.assertTrue((boolean)entrySet.remove(Maps.immutableEntry((Object)10, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertFalse((boolean)entrySet.remove(Maps.immutableEntry((Object)20, (Object)Character.valueOf('X'))));
        TreeBasedTableTest.assertFalse((boolean)entrySet.remove(Maps.immutableEntry((Object)15, (Object)Character.valueOf('X'))));
    }

    public void testRowSize() {
        this.sortedTable = this.create("a", 2, Character.valueOf('X'), "a", 2, Character.valueOf('X'), "b", 3, Character.valueOf('X'), "b", 2, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 10, Character.valueOf('X'), "c", 20, Character.valueOf('X'), "d", 15, Character.valueOf('X'), "d", 20, Character.valueOf('X'), "d", 1, Character.valueOf('X'), "e", 5, Character.valueOf('X'));
        this.table = this.sortedTable;
        SortedMap row = this.sortedTable.row((Object)"c");
        TreeBasedTableTest.assertEquals((int)2, (int)row.size());
        TreeBasedTableTest.assertEquals((int)1, (int)row.tailMap(15).size());
    }

    public void testSubRowClearAndPut() {
        this.table = this.create("foo", 1, Character.valueOf('a'), "bar", 1, Character.valueOf('b'), "foo", 3, Character.valueOf('c'));
        SortedMap row = (SortedMap)this.table.row((Object)"foo");
        SortedMap subRow = row.tailMap(2);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('a'), (Object)3, (Object)Character.valueOf('c')), (Object)row);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)3, (Object)Character.valueOf('c')), subRow);
        this.table.remove((Object)"foo", (Object)3);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)1, (Object)Character.valueOf('a')), (Object)row);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of(), subRow);
        this.table.remove((Object)"foo", (Object)1);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of(), (Object)row);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of(), subRow);
        this.table.put((Object)"foo", (Object)2, (Object)Character.valueOf('b'));
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)Character.valueOf('b')), (Object)row);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)2, (Object)Character.valueOf('b')), subRow);
        row.clear();
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of(), (Object)row);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of(), subRow);
        this.table.put((Object)"foo", (Object)5, (Object)Character.valueOf('x'));
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)5, (Object)Character.valueOf('x')), (Object)row);
        TreeBasedTableTest.assertEquals((Object)ImmutableMap.of((Object)5, (Object)Character.valueOf('x')), subRow);
    }

    public static class TreeRowTest
    extends SortedMapInterfaceTest<String, String> {
        public TreeRowTest() {
            super(false, false, true, true, true);
        }

        protected SortedMap<String, String> makeEmptyMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"a", (Object)"b", (Object)"c");
            table.put((Object)"c", (Object)"b", (Object)"a");
            table.put((Object)"a", (Object)"a", (Object)"d");
            return table.row((Object)"b");
        }

        protected SortedMap<String, String> makePopulatedMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"a", (Object)"b", (Object)"c");
            table.put((Object)"c", (Object)"b", (Object)"a");
            table.put((Object)"b", (Object)"b", (Object)"x");
            table.put((Object)"b", (Object)"c", (Object)"y");
            table.put((Object)"b", (Object)"x", (Object)"n");
            table.put((Object)"a", (Object)"a", (Object)"d");
            return table.row((Object)"b");
        }

        protected String getKeyNotInPopulatedMap() {
            return "q";
        }

        protected String getValueNotInPopulatedMap() {
            return "p";
        }

        public void testClearSubMapOfRowMap() {
            TreeBasedTable table = TreeBasedTable.create();
            table.put((Object)"a", (Object)"b", (Object)"c");
            table.put((Object)"c", (Object)"b", (Object)"a");
            table.put((Object)"b", (Object)"b", (Object)"x");
            table.put((Object)"b", (Object)"c", (Object)"y");
            table.put((Object)"b", (Object)"x", (Object)"n");
            table.put((Object)"a", (Object)"a", (Object)"d");
            table.row((Object)"b").subMap("c", "x").clear();
            TreeRowTest.assertEquals((Object)table.row((Object)"b"), (Object)ImmutableMap.of((Object)"b", (Object)"x", (Object)"x", (Object)"n"));
            table.row((Object)"b").subMap("b", "y").clear();
            TreeRowTest.assertEquals((Object)table.row((Object)"b"), (Object)ImmutableMap.of());
            TreeRowTest.assertFalse((boolean)table.backingMap.containsKey("b"));
        }
    }
}

