/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.MapTestSuiteBuilder;
import com.google.common.collect.testing.SampleElements;
import com.google.common.collect.testing.TestMapGenerator;
import com.google.common.collect.testing.features.CollectionFeature;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.Feature;
import com.google.common.collect.testing.features.MapFeature;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

@GwtIncompatible
public class TreeRangeMapTest
extends TestCase {
    private static final ImmutableList<Range<Integer>> RANGES;
    private static final int MIN_BOUND = -2;
    private static final int MAX_BOUND = 2;

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTestSuite(TreeRangeMapTest.class);
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<Range<Integer>, String>(){

            public SampleElements<Map.Entry<Range<Integer>, String>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)Range.singleton((Comparable)Integer.valueOf(0)), (Object)"banana"), (Object)Helpers.mapEntry((Object)Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)"frisbee"), (Object)Helpers.mapEntry((Object)Range.atMost((Comparable)Integer.valueOf(-1)), (Object)"fruitcake"), (Object)Helpers.mapEntry((Object)Range.open((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)"elephant"), (Object)Helpers.mapEntry((Object)Range.closed((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(22)), (Object)"umbrella"));
            }

            public Map<Range<Integer>, String> create(Object ... elements) {
                TreeRangeMap rangeMap = TreeRangeMap.create();
                for (Object o : elements) {
                    Map.Entry entry = (Map.Entry)o;
                    rangeMap.put((Range)entry.getKey(), entry.getValue());
                }
                return rangeMap.asMapOfRanges();
            }

            public Map.Entry<Range<Integer>, String>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<Range<Integer>, String>> order(List<Map.Entry<Range<Integer>, String>> insertionOrder) {
                return Range.rangeLexOrdering().onKeys().sortedCopy(insertionOrder);
            }

            public Range<Integer>[] createKeyArray(int length) {
                return new Range[length];
            }

            public String[] createValueArray(int length) {
                return new String[length];
            }
        }).named("TreeRangeMap.asMapOfRanges")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<Range<Integer>, String>(){

            public SampleElements<Map.Entry<Range<Integer>, String>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)Range.singleton((Comparable)Integer.valueOf(0)), (Object)"banana"), (Object)Helpers.mapEntry((Object)Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)"frisbee"), (Object)Helpers.mapEntry((Object)Range.atMost((Comparable)Integer.valueOf(-1)), (Object)"fruitcake"), (Object)Helpers.mapEntry((Object)Range.open((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)"elephant"), (Object)Helpers.mapEntry((Object)Range.closed((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(22)), (Object)"umbrella"));
            }

            public Map<Range<Integer>, String> create(Object ... elements) {
                TreeRangeMap rangeMap = TreeRangeMap.create();
                for (Object o : elements) {
                    Map.Entry entry = (Map.Entry)o;
                    rangeMap.put((Range)entry.getKey(), entry.getValue());
                }
                return rangeMap.subRangeMap(Range.atMost((Comparable)Integer.valueOf(22))).asMapOfRanges();
            }

            public Map.Entry<Range<Integer>, String>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<Range<Integer>, String>> order(List<Map.Entry<Range<Integer>, String>> insertionOrder) {
                return Range.rangeLexOrdering().onKeys().sortedCopy(insertionOrder);
            }

            public Range<Integer>[] createKeyArray(int length) {
                return new Range[length];
            }

            public String[] createValueArray(int length) {
                return new String[length];
            }
        }).named("TreeRangeMap.subRangeMap.asMapOfRanges")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<Range<Integer>, String>(){

            public SampleElements<Map.Entry<Range<Integer>, String>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)Range.singleton((Comparable)Integer.valueOf(0)), (Object)"banana"), (Object)Helpers.mapEntry((Object)Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)"frisbee"), (Object)Helpers.mapEntry((Object)Range.atMost((Comparable)Integer.valueOf(-1)), (Object)"fruitcake"), (Object)Helpers.mapEntry((Object)Range.open((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)"elephant"), (Object)Helpers.mapEntry((Object)Range.closed((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(22)), (Object)"umbrella"));
            }

            public Map<Range<Integer>, String> create(Object ... elements) {
                TreeRangeMap rangeMap = TreeRangeMap.create();
                for (Object o : elements) {
                    Map.Entry entry = (Map.Entry)o;
                    rangeMap.put((Range)entry.getKey(), entry.getValue());
                }
                return rangeMap.asDescendingMapOfRanges();
            }

            public Map.Entry<Range<Integer>, String>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<Range<Integer>, String>> order(List<Map.Entry<Range<Integer>, String>> insertionOrder) {
                return Range.rangeLexOrdering().reverse().onKeys().sortedCopy(insertionOrder);
            }

            public Range<Integer>[] createKeyArray(int length) {
                return new Range[length];
            }

            public String[] createValueArray(int length) {
                return new String[length];
            }
        }).named("TreeRangeMap.asDescendingMapOfRanges")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER, CollectionFeature.SUPPORTS_ITERATOR_REMOVE})).createTestSuite());
        suite.addTest((Test)((MapTestSuiteBuilder)((MapTestSuiteBuilder)MapTestSuiteBuilder.using((TestMapGenerator)new TestMapGenerator<Range<Integer>, String>(){

            public SampleElements<Map.Entry<Range<Integer>, String>> samples() {
                return new SampleElements((Object)Helpers.mapEntry((Object)Range.singleton((Comparable)Integer.valueOf(0)), (Object)"banana"), (Object)Helpers.mapEntry((Object)Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)"frisbee"), (Object)Helpers.mapEntry((Object)Range.atMost((Comparable)Integer.valueOf(-1)), (Object)"fruitcake"), (Object)Helpers.mapEntry((Object)Range.open((Comparable)Integer.valueOf(10), (Comparable)Integer.valueOf(15)), (Object)"elephant"), (Object)Helpers.mapEntry((Object)Range.closed((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(22)), (Object)"umbrella"));
            }

            public Map<Range<Integer>, String> create(Object ... elements) {
                TreeRangeMap rangeMap = TreeRangeMap.create();
                for (Object o : elements) {
                    Map.Entry entry = (Map.Entry)o;
                    rangeMap.put((Range)entry.getKey(), entry.getValue());
                }
                return rangeMap.subRangeMap(Range.atMost((Comparable)Integer.valueOf(22))).asDescendingMapOfRanges();
            }

            public Map.Entry<Range<Integer>, String>[] createArray(int length) {
                return new Map.Entry[length];
            }

            public Iterable<Map.Entry<Range<Integer>, String>> order(List<Map.Entry<Range<Integer>, String>> insertionOrder) {
                return Range.rangeLexOrdering().reverse().onKeys().sortedCopy(insertionOrder);
            }

            public Range<Integer>[] createKeyArray(int length) {
                return new Range[length];
            }

            public String[] createValueArray(int length) {
                return new String[length];
            }
        }).named("TreeRangeMap.subRangeMap.asDescendingMapOfRanges")).withFeatures(new Feature[]{CollectionSize.ANY, MapFeature.SUPPORTS_REMOVE, MapFeature.ALLOWS_ANY_NULL_QUERIES, CollectionFeature.KNOWN_ORDER})).createTestSuite());
        return suite;
    }

    public void testSpanSingleRange() {
        for (Range range : RANGES) {
            TreeRangeMap rangeMap = TreeRangeMap.create();
            rangeMap.put(range, (Object)1);
            try {
                TreeRangeMapTest.assertEquals((Object)range, (Object)rangeMap.span());
                TreeRangeMapTest.assertFalse((boolean)range.isEmpty());
            }
            catch (NoSuchElementException e) {
                TreeRangeMapTest.assertTrue((boolean)range.isEmpty());
            }
        }
    }

    public void testSpanTwoRanges() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                TreeRangeMap rangeMap = TreeRangeMap.create();
                rangeMap.put(range1, (Object)1);
                rangeMap.put(range2, (Object)2);
                Range expected = range1.isEmpty() ? (range2.isEmpty() ? null : range2) : (range2.isEmpty() ? range1 : range1.span(range2));
                try {
                    TreeRangeMapTest.assertEquals((Object)expected, (Object)rangeMap.span());
                    TreeRangeMapTest.assertNotNull((Object)expected);
                }
                catch (NoSuchElementException e) {
                    TreeRangeMapTest.assertNull((Object)expected);
                }
            }
        }
    }

    public void testAllRangesAlone() {
        for (Range range : RANGES) {
            HashMap model = Maps.newHashMap();
            TreeRangeMapTest.putModel(model, (Range<Integer>)range, 1);
            TreeRangeMap test = TreeRangeMap.create();
            test.put(range, (Object)1);
            this.verify(model, (RangeMap<Integer, Integer>)test);
        }
    }

    public void testAllRangePairs() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                HashMap model = Maps.newHashMap();
                TreeRangeMapTest.putModel(model, (Range<Integer>)range1, 1);
                TreeRangeMapTest.putModel(model, (Range<Integer>)range2, 2);
                TreeRangeMap test = TreeRangeMap.create();
                test.put(range1, (Object)1);
                test.put(range2, (Object)2);
                this.verify(model, (RangeMap<Integer, Integer>)test);
            }
        }
    }

    public void testAllRangeTriples() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                for (Range range3 : RANGES) {
                    HashMap model = Maps.newHashMap();
                    TreeRangeMapTest.putModel(model, (Range<Integer>)range1, 1);
                    TreeRangeMapTest.putModel(model, (Range<Integer>)range2, 2);
                    TreeRangeMapTest.putModel(model, (Range<Integer>)range3, 3);
                    TreeRangeMap test = TreeRangeMap.create();
                    test.put(range1, (Object)1);
                    test.put(range2, (Object)2);
                    test.put(range3, (Object)3);
                    this.verify(model, (RangeMap<Integer, Integer>)test);
                }
            }
        }
    }

    public void testPutAll() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                for (Range range3 : RANGES) {
                    HashMap model = Maps.newHashMap();
                    TreeRangeMapTest.putModel(model, (Range<Integer>)range1, 1);
                    TreeRangeMapTest.putModel(model, (Range<Integer>)range2, 2);
                    TreeRangeMapTest.putModel(model, (Range<Integer>)range3, 3);
                    TreeRangeMap test = TreeRangeMap.create();
                    TreeRangeMap test2 = TreeRangeMap.create();
                    test.put(range1, (Object)1);
                    test2.put(range2, (Object)2);
                    test2.put(range3, (Object)3);
                    test.putAll((RangeMap)test2);
                    this.verify(model, (RangeMap<Integer, Integer>)test);
                }
            }
        }
    }

    public void testPutAndRemove() {
        for (Range rangeToPut : RANGES) {
            for (Range rangeToRemove : RANGES) {
                HashMap model = Maps.newHashMap();
                TreeRangeMapTest.putModel(model, (Range<Integer>)rangeToPut, 1);
                TreeRangeMapTest.removeModel(model, (Range<Integer>)rangeToRemove);
                TreeRangeMap test = TreeRangeMap.create();
                test.put(rangeToPut, (Object)1);
                test.remove(rangeToRemove);
                this.verify(model, (RangeMap<Integer, Integer>)test);
            }
        }
    }

    public void testPutTwoAndRemove() {
        for (Range rangeToPut1 : RANGES) {
            for (Range rangeToPut2 : RANGES) {
                for (Range rangeToRemove : RANGES) {
                    HashMap model = Maps.newHashMap();
                    TreeRangeMapTest.putModel(model, (Range<Integer>)rangeToPut1, 1);
                    TreeRangeMapTest.putModel(model, (Range<Integer>)rangeToPut2, 2);
                    TreeRangeMapTest.removeModel(model, (Range<Integer>)rangeToRemove);
                    TreeRangeMap test = TreeRangeMap.create();
                    test.put(rangeToPut1, (Object)1);
                    test.put(rangeToPut2, (Object)2);
                    test.remove(rangeToRemove);
                    this.verify(model, (RangeMap<Integer, Integer>)test);
                }
            }
        }
    }

    public void testPutCoalescingTwoAndRemove() {
        for (Range rangeToPut1 : RANGES) {
            for (Range rangeToPut2 : RANGES) {
                for (Range rangeToRemove : RANGES) {
                    HashMap model = Maps.newHashMap();
                    TreeRangeMapTest.putModel(model, (Range<Integer>)rangeToPut1, 1);
                    TreeRangeMapTest.putModel(model, (Range<Integer>)rangeToPut2, 2);
                    TreeRangeMapTest.removeModel(model, (Range<Integer>)rangeToRemove);
                    TreeRangeMap test = TreeRangeMap.create();
                    test.putCoalescing(rangeToPut1, (Object)1);
                    test.putCoalescing(rangeToPut2, (Object)2);
                    test.remove(rangeToRemove);
                    this.verify(model, (RangeMap<Integer, Integer>)test);
                }
            }
        }
    }

    public void testPutCoalescing() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), (Object)1);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), (Object)1);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), (Object)2);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2)), (Object)1, (Object)Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(3)), (Object)2), (Object)rangeMap.asMapOfRanges());
    }

    public void testPutCoalescingEmpty() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), (Object)1);
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), (Object)1);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), (Object)1, (Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(2)), (Object)1), (Object)rangeMap.asMapOfRanges());
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(1)), (Object)1);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(2)), (Object)1), (Object)rangeMap.asMapOfRanges());
    }

    public void testPutCoalescingComplex() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), (Object)1);
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(3)), (Object)1);
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)1);
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(10)), (Object)2);
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(15)), (Object)2);
        rangeMap.put(Range.closedOpen((Comparable)Integer.valueOf(18), (Comparable)Integer.valueOf(19)), (Object)3);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(-5), (Comparable)Integer.valueOf(-4)), (Object)0);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(-6), (Comparable)Integer.valueOf(-5)), (Object)0);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(2), (Comparable)Integer.valueOf(4)), (Object)1);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14)), (Object)0);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(17), (Comparable)Integer.valueOf(20)), (Object)3);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(22), (Comparable)Integer.valueOf(23)), (Object)4);
        rangeMap.putCoalescing(Range.closedOpen((Comparable)Integer.valueOf(23), (Comparable)Integer.valueOf(25)), (Object)4);
        TreeRangeMapTest.assertEquals((Object)new ImmutableMap.Builder().put((Object)Range.closedOpen((Comparable)Integer.valueOf(-6), (Comparable)Integer.valueOf(-4)), (Object)0).put((Object)Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1)), (Object)1).put((Object)Range.closedOpen((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(5)), (Object)1).put((Object)Range.closedOpen((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)), (Object)2).put((Object)Range.closedOpen((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(14)), (Object)0).put((Object)Range.closedOpen((Comparable)Integer.valueOf(14), (Comparable)Integer.valueOf(15)), (Object)2).put((Object)Range.closedOpen((Comparable)Integer.valueOf(17), (Comparable)Integer.valueOf(20)), (Object)3).put((Object)Range.closedOpen((Comparable)Integer.valueOf(22), (Comparable)Integer.valueOf(25)), (Object)4).build(), (Object)rangeMap.asMapOfRanges());
    }

    public void testSubRangeMapExhaustive() {
        for (Range range1 : RANGES) {
            for (Range range2 : RANGES) {
                TreeRangeMap rangeMap = TreeRangeMap.create();
                rangeMap.put(range1, (Object)1);
                rangeMap.put(range2, (Object)2);
                for (Range subRange : RANGES) {
                    TreeRangeMap expected = TreeRangeMap.create();
                    for (Map.Entry entry : rangeMap.asMapOfRanges().entrySet()) {
                        if (!((Range)entry.getKey()).isConnected(subRange)) continue;
                        expected.put(((Range)entry.getKey()).intersection(subRange), entry.getValue());
                    }
                    RangeMap subRangeMap = rangeMap.subRangeMap(subRange);
                    TreeRangeMapTest.assertEquals((Object)expected, (Object)subRangeMap);
                    TreeRangeMapTest.assertEquals((Object)expected.asMapOfRanges(), (Object)subRangeMap.asMapOfRanges());
                    TreeRangeMapTest.assertEquals((Object)expected.asDescendingMapOfRanges(), (Object)subRangeMap.asDescendingMapOfRanges());
                    TreeRangeMapTest.assertEquals((Object)ImmutableList.copyOf(subRangeMap.asMapOfRanges().entrySet()).reverse(), (Object)ImmutableList.copyOf(subRangeMap.asDescendingMapOfRanges().entrySet()));
                    if (!expected.asMapOfRanges().isEmpty()) {
                        TreeRangeMapTest.assertEquals((Object)expected.span(), (Object)subRangeMap.span());
                    }
                    for (int i = -2; i <= 2; ++i) {
                        TreeRangeMapTest.assertEquals((Object)expected.get((Comparable)Integer.valueOf(i)), (Object)subRangeMap.get((Comparable)Integer.valueOf(i)));
                    }
                    for (Range query : RANGES) {
                        TreeRangeMapTest.assertEquals(expected.asMapOfRanges().get(query), subRangeMap.asMapOfRanges().get(query));
                    }
                }
            }
        }
    }

    public void testSubSubRangeMap() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3);
        RangeMap sub1 = rangeMap.subRangeMap(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub1.asMapOfRanges());
        RangeMap sub2 = sub1.subRangeMap(Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(15)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(6), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub2.asMapOfRanges());
    }

    public void testSubRangeMapPut() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3);
        RangeMap sub = rangeMap.subRangeMap(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        sub.put(Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)), (Object)4);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)), (Object)4, (Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)), (Object)4, (Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
        try {
            sub.put(Range.open((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(12)), (Object)5);
            TreeRangeMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        sub = sub.subRangeMap(Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(5)));
        sub.put(Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(5)), (Object)6);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)), (Object)4, (Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
    }

    public void testSubRangeMapPutCoalescing() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3);
        RangeMap sub = rangeMap.subRangeMap(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        sub.putCoalescing(Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)), (Object)2);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(10)), (Object)2, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
        sub.putCoalescing(Range.singleton((Comparable)Integer.valueOf(7)), (Object)1);
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.openClosed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.openClosed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(10)), (Object)2, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
        try {
            sub.putCoalescing(Range.open((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(12)), (Object)5);
            TreeRangeMapTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSubRangeMapRemove() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3);
        RangeMap sub = rangeMap.subRangeMap(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        sub.remove(Range.closed((Comparable)Integer.valueOf(7), (Comparable)Integer.valueOf(9)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.closedOpen((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1, (Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
        sub.remove(Range.closed((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(9)));
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2), (Object)sub.asMapOfRanges());
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)1, (Object)Range.openClosed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
    }

    public void testSubRangeMapClear() {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        rangeMap.put(Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(7)), (Object)1);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(9), (Comparable)Integer.valueOf(10)), (Object)2);
        rangeMap.put(Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3);
        RangeMap sub = rangeMap.subRangeMap(Range.closed((Comparable)Integer.valueOf(5), (Comparable)Integer.valueOf(11)));
        sub.clear();
        TreeRangeMapTest.assertEquals((Object)ImmutableMap.of((Object)Range.open((Comparable)Integer.valueOf(3), (Comparable)Integer.valueOf(5)), (Object)1, (Object)Range.closed((Comparable)Integer.valueOf(12), (Comparable)Integer.valueOf(16)), (Object)3), (Object)rangeMap.asMapOfRanges());
    }

    private void verify(Map<Integer, Integer> model, RangeMap<Integer, Integer> test) {
        for (int i = -3; i <= 3; ++i) {
            TreeRangeMapTest.assertEquals((Object)model.get(i), (Object)test.get((Comparable)Integer.valueOf(i)));
            Map.Entry entry = test.getEntry((Comparable)Integer.valueOf(i));
            TreeRangeMapTest.assertEquals((boolean)model.containsKey(i), (entry != null ? 1 : 0) != 0);
            if (entry == null) continue;
            TreeRangeMapTest.assertTrue((boolean)test.asMapOfRanges().entrySet().contains(entry));
        }
        for (Range range : test.asMapOfRanges().keySet()) {
            TreeRangeMapTest.assertFalse((boolean)range.isEmpty());
        }
    }

    private static void putModel(Map<Integer, Integer> model, Range<Integer> range, int value) {
        for (int i = -3; i <= 3; ++i) {
            if (!range.contains((Comparable)Integer.valueOf(i))) continue;
            model.put(i, value);
        }
    }

    private static void removeModel(Map<Integer, Integer> model, Range<Integer> range) {
        for (int i = -3; i <= 3; ++i) {
            if (!range.contains((Comparable)Integer.valueOf(i))) continue;
            model.remove(i);
        }
    }

    static {
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)Range.all());
        for (i = -2; i <= 2; ++i) {
            for (BoundType type : BoundType.values()) {
                builder.add((Object)Range.upTo((Comparable)Integer.valueOf(i), (BoundType)type));
                builder.add((Object)Range.downTo((Comparable)Integer.valueOf(i), (BoundType)type));
            }
        }
        for (i = -2; i <= 2; ++i) {
            for (int j = i; j <= 2; ++j) {
                for (BoundType lowerType : BoundType.values()) {
                    for (BoundType upperType : BoundType.values()) {
                        if (i == j & lowerType == BoundType.OPEN & upperType == BoundType.OPEN) continue;
                        builder.add((Object)Range.range((Comparable)Integer.valueOf(i), (BoundType)lowerType, (Comparable)Integer.valueOf(j), (BoundType)upperType));
                    }
                }
            }
        }
        RANGES = builder.build();
    }
}

