/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.BinaryTreeTraverser;
import com.google.common.collect.TreeTraverser;
import com.google.common.testing.NullPointerTester;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import junit.framework.TestCase;

@GwtCompatible(emulated=true)
public class TreeTraverserTest
extends TestCase {
    private static final TreeTraverser<Tree> ADAPTER = new TreeTraverser<Tree>(){

        public Iterable<Tree> children(Tree node) {
            return node.children;
        }
    };
    private static final TreeTraverser<Tree> ADAPTER_USING_USING = TreeTraverser.using((Function)new Function<Tree, Iterable<Tree>>(){

        public Iterable<Tree> apply(Tree node) {
            return node.children;
        }
    });
    private static final BinaryTreeTraverser<BinaryTree> BIN_ADAPTER = new BinaryTreeTraverser<BinaryTree>(){

        public Optional<BinaryTree> leftChild(BinaryTree node) {
            return Optional.fromNullable((Object)node.left);
        }

        public Optional<BinaryTree> rightChild(BinaryTree node) {
            return Optional.fromNullable((Object)node.right);
        }
    };
    static final Tree a = new Tree('a', new Tree[0]);
    static final Tree b = new Tree('b', new Tree[0]);
    static final Tree c = new Tree('c', new Tree[0]);
    static final Tree d = new Tree('d', a, b, c);
    static final Tree e = new Tree('e', new Tree[0]);
    static final Tree f = new Tree('f', new Tree[0]);
    static final Tree g = new Tree('g', f);
    static final Tree h = new Tree('h', d, e, g);
    static final BinaryTree ba = new BinaryTree('a', null, null);
    static final BinaryTree bc = new BinaryTree('c', null, null);
    static final BinaryTree bb = new BinaryTree('b', ba, bc);
    static final BinaryTree bg = new BinaryTree('g', null, null);
    static final BinaryTree bf = new BinaryTree('f', bg, null);
    static final BinaryTree be = new BinaryTree('e', null, bf);
    static final BinaryTree bd = new BinaryTree('d', bb, be);

    static String iterationOrder(Iterable<? extends Node> iterable) {
        StringBuilder builder = new StringBuilder();
        for (Node node : iterable) {
            builder.append(node.value);
        }
        StringBuilder forEachBuilder = new StringBuilder();
        iterable.forEach(t -> forEachBuilder.append(t.value));
        TreeTraverserTest.assertTrue((String)("Iterator content was " + builder + " but forEach content was " + forEachBuilder), (boolean)builder.toString().contentEquals(forEachBuilder));
        return builder.toString();
    }

    public void testPreOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)ADAPTER.preOrderTraversal((Object)h))).isEqualTo((Object)"hdabcegf");
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)BIN_ADAPTER.preOrderTraversal((Object)bd))).isEqualTo((Object)"dbacefg");
    }

    public void testPostOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)ADAPTER.postOrderTraversal((Object)h))).isEqualTo((Object)"abcdefgh");
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)BIN_ADAPTER.postOrderTraversal((Object)bd))).isEqualTo((Object)"acbgfed");
    }

    public void testBreadthOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)ADAPTER.breadthFirstTraversal((Object)h))).isEqualTo((Object)"hdegabcf");
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)BIN_ADAPTER.breadthFirstTraversal((Object)bd))).isEqualTo((Object)"dbeacfg");
    }

    public void testInOrder() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)BIN_ADAPTER.inOrderTraversal((Object)bd))).isEqualTo((Object)"abcdegf");
    }

    public void testUsing() {
        Truth.assertThat((String)TreeTraverserTest.iterationOrder((Iterable<? extends Node>)ADAPTER_USING_USING.preOrderTraversal((Object)h))).isEqualTo((Object)"hdabcegf");
    }

    @GwtIncompatible
    public void testNulls() {
        NullPointerTester tester = new NullPointerTester();
        tester.testAllPublicInstanceMethods(ADAPTER);
        tester.testAllPublicInstanceMethods(BIN_ADAPTER);
    }

    private static final class BinaryTree
    extends Node {
        @Nullable
        final BinaryTree left;
        @Nullable
        final BinaryTree right;

        private BinaryTree(char value, BinaryTree left, BinaryTree right) {
            super(value);
            this.left = left;
            this.right = right;
        }
    }

    private static final class Tree
    extends Node {
        final List<Tree> children;

        public Tree(char value, Tree ... children) {
            super(value);
            this.children = Arrays.asList(children);
        }
    }

    private static class Node {
        final char value;

        Node(char value) {
            this.value = value;
        }
    }
}

