/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.WellBehavedMap;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import junit.framework.TestCase;

@GwtCompatible
public class WellBehavedMapTest
extends TestCase {
    public void testEntrySet_contain() {
        WellBehavedMap map = WellBehavedMap.wrap(new EnumMap(Foo.class));
        map.putAll((Map)ImmutableMap.of((Object)((Object)Foo.X), (Object)1, (Object)((Object)Foo.Y), (Object)2, (Object)((Object)Foo.Z), (Object)3));
        WellBehavedMapTest.assertTrue((boolean)map.entrySet().contains(Maps.immutableEntry((Object)((Object)Foo.X), (Object)1)));
        WellBehavedMapTest.assertTrue((boolean)map.entrySet().contains(Maps.immutableEntry((Object)((Object)Foo.Y), (Object)new Integer(2))));
        WellBehavedMapTest.assertFalse((boolean)map.entrySet().contains(Maps.immutableEntry((Object)((Object)Foo.X), (Object)5)));
        WellBehavedMapTest.assertFalse((boolean)map.entrySet().contains(Maps.immutableEntry((Object)((Object)Foo.T), (Object)0)));
    }

    public void testEntry_setValue() {
        WellBehavedMap map = WellBehavedMap.wrap(new EnumMap(Foo.class));
        map.putAll((Map)ImmutableMap.of((Object)((Object)Foo.X), (Object)1, (Object)((Object)Foo.Y), (Object)2, (Object)((Object)Foo.Z), (Object)3));
        for (Map.Entry entry : map.entrySet()) {
            entry.setValue((Integer)entry.getValue() + 5);
        }
        WellBehavedMapTest.assertEquals((Object)ImmutableMap.of((Object)((Object)Foo.X), (Object)6, (Object)((Object)Foo.Y), (Object)7, (Object)((Object)Foo.Z), (Object)8), (Object)map);
    }

    public void testEntriesAreMutableAndConsistent() {
        WellBehavedMap map = WellBehavedMap.wrap(new EnumMap(Foo.class));
        map.putAll((Map)ImmutableMap.of((Object)((Object)Foo.X), (Object)1));
        Map.Entry entry1 = (Map.Entry)Iterables.getOnlyElement((Iterable)map.entrySet());
        Map.Entry entry2 = (Map.Entry)Iterables.getOnlyElement((Iterable)map.entrySet());
        WellBehavedMapTest.assertNotSame((Object)entry1, (Object)entry2);
        Set entrySet = map.entrySet();
        WellBehavedMapTest.assertTrue((boolean)entrySet.contains(entry1));
        WellBehavedMapTest.assertTrue((boolean)entrySet.contains(entry2));
        entry1.setValue(2);
        WellBehavedMapTest.assertEquals(entry1.getValue(), entry2.getValue());
        WellBehavedMapTest.assertTrue((boolean)entrySet.contains(entry1));
        WellBehavedMapTest.assertTrue((boolean)entrySet.contains(entry2));
    }

    public void testEntrySet_remove() {
        WellBehavedMap map = WellBehavedMap.wrap(new EnumMap(Foo.class));
        map.putAll((Map)ImmutableMap.of((Object)((Object)Foo.X), (Object)1, (Object)((Object)Foo.Y), (Object)2, (Object)((Object)Foo.Z), (Object)3));
        Set entrySet = map.entrySet();
        Map.Entry entry = Maps.immutableEntry((Object)((Object)Foo.Y), (Object)2);
        WellBehavedMapTest.assertTrue((boolean)entrySet.remove(entry));
        WellBehavedMapTest.assertFalse((boolean)map.containsKey((Object)Foo.Y));
        WellBehavedMapTest.assertNull((Object)map.get((Object)Foo.Y));
        WellBehavedMapTest.assertFalse((boolean)entrySet.contains(entry));
        WellBehavedMapTest.assertFalse((boolean)entrySet.remove(Maps.immutableEntry((Object)((Object)Foo.T), (Object)4)));
        WellBehavedMapTest.assertFalse((boolean)entrySet.remove(Maps.immutableEntry((Object)((Object)Foo.Z), (Object)5)));
    }

    static enum Foo {
        X,
        Y,
        Z,
        T;

    }
}

