/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.escape;

import com.google.common.annotations.GwtCompatible;
import com.google.common.escape.Escaper;
import com.google.common.escape.UnicodeEscaper;
import junit.framework.TestCase;

@GwtCompatible
public class UnicodeEscaperTest
extends TestCase {
    private static final String SMALLEST_SURROGATE = "\ud800\udc00";
    private static final String LARGEST_SURROGATE = "\udbff\udfff";
    private static final String TEST_STRING = "\u0000abyz\u0080\u0100\u0800\u1000ABYZ\uffff\ud800\udc000189\udbff\udfff";
    private static final UnicodeEscaper NOP_ESCAPER = new UnicodeEscaper(){

        protected char[] escape(int c) {
            return null;
        }
    };
    private static final UnicodeEscaper SIMPLE_ESCAPER = new UnicodeEscaper(){

        protected char[] escape(int cp) {
            return 97 <= cp && cp <= 122 || 65 <= cp && cp <= 90 || 48 <= cp && cp <= 57 ? null : ("[" + String.valueOf(cp) + "]").toCharArray();
        }
    };

    public void testNopEscaper() {
        UnicodeEscaper e = NOP_ESCAPER;
        UnicodeEscaperTest.assertEquals((String)TEST_STRING, (String)UnicodeEscaperTest.escapeAsString((Escaper)e, TEST_STRING));
    }

    public void testSimpleEscaper() {
        UnicodeEscaper e = SIMPLE_ESCAPER;
        String expected = "[0]abyz[128][256][2048][4096]ABYZ[65535][65536]0189[1114111]";
        UnicodeEscaperTest.assertEquals((String)expected, (String)UnicodeEscaperTest.escapeAsString((Escaper)e, TEST_STRING));
    }

    public void testGrowBuffer() {
        StringBuilder input = new StringBuilder();
        StringBuilder expected = new StringBuilder();
        for (int i = 256; i < 1024; ++i) {
            input.append((char)i);
            expected.append("[" + i + "]");
        }
        UnicodeEscaperTest.assertEquals((String)expected.toString(), (String)SIMPLE_ESCAPER.escape(input.toString()));
    }

    public void testSurrogatePairs() {
        UnicodeEscaper e = SIMPLE_ESCAPER;
        int min = 65536;
        int max = 0x10FFFF;
        int range = 1048575;
        int s1 = 327679;
        int s2 = 589823;
        int s3 = 851967;
        char[] dst = new char[12];
        dst[0] = 120;
        Character.toChars(65536, dst, 1);
        Character.toChars(327679, dst, 3);
        Character.toChars(589823, dst, 5);
        Character.toChars(851967, dst, 7);
        Character.toChars(0x10FFFF, dst, 9);
        dst[11] = 120;
        String test = new String(dst);
        String expected = "x[65536][327679][589823][851967][1114111]x";
        UnicodeEscaperTest.assertEquals((String)expected, (String)UnicodeEscaperTest.escapeAsString((Escaper)e, test));
    }

    public void testTrailingHighSurrogate() {
        String test = "abc\ud800";
        try {
            UnicodeEscaperTest.escapeAsString((Escaper)NOP_ESCAPER, test);
            UnicodeEscaperTest.fail((String)"Trailing high surrogate should cause exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            UnicodeEscaperTest.escapeAsString((Escaper)SIMPLE_ESCAPER, test);
            UnicodeEscaperTest.fail((String)"Trailing high surrogate should cause exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNullInput() {
        UnicodeEscaper e = SIMPLE_ESCAPER;
        try {
            e.escape((String)null);
            UnicodeEscaperTest.fail((String)"Null string should cause exception");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testBadStrings() {
        String[] BAD_STRINGS;
        UnicodeEscaper e = SIMPLE_ESCAPER;
        for (String s : BAD_STRINGS = new String[]{String.valueOf('\udc00'), "\udc00xyz", "abc\udc00", "abc\udc00xyz", String.valueOf('\udfff'), "\udfffxyz", "abc\udfff", "abc\udfffxyz"}) {
            try {
                UnicodeEscaperTest.escapeAsString((Escaper)e, s);
                UnicodeEscaperTest.fail((String)("Isolated low surrogate should cause exception [" + s + "]"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public void testFalsePositivesForNextEscapedIndex() {
        UnicodeEscaper e = new UnicodeEscaper(){

            protected char[] escape(int cp) {
                char[] cArray;
                if (97 <= cp && cp <= 122) {
                    char[] cArray2 = new char[1];
                    cArray = cArray2;
                    cArray2[0] = Character.toUpperCase((char)cp);
                } else {
                    cArray = null;
                }
                return cArray;
            }

            protected int nextEscapeIndex(CharSequence csq, int index, int end) {
                while (index < end && !Character.isLetter(csq.charAt(index))) {
                    ++index;
                }
                return index;
            }
        };
        UnicodeEscaperTest.assertEquals((String)"\u0000HELLO \ud800\udc00 WORLD!\n", (String)e.escape("\u0000HeLLo \ud800\udc00 WorlD!\n"));
    }

    public void testCodePointAt_IndexOutOfBoundsException() {
        try {
            UnicodeEscaper.codePointAt((CharSequence)"Testing...", (int)4, (int)2);
            UnicodeEscaperTest.fail();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static String escapeAsString(Escaper e, String s) {
        return e.escape(s);
    }
}

