/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractDirectedNetworkTest;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ConfigurableSimpleDirectedNetworkTest
extends AbstractDirectedNetworkTest {
    @Override
    public MutableNetwork<Integer, String> createGraph() {
        return NetworkBuilder.directed().allowsParallelEdges(false).allowsSelfLoops(false).build();
    }

    @Override
    @Test
    public void nodes_checkReturnedSetMutability() {
        Set nodes = this.network.nodes();
        try {
            nodes.add(N2);
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addNode(N1);
            Truth.assertThat((Iterable)this.network.nodes()).containsExactlyElementsIn((Iterable)nodes);
        }
    }

    @Override
    @Test
    public void edges_checkReturnedSetMutability() {
        Set edges = this.network.edges();
        try {
            edges.add("1-2");
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.edges()).containsExactlyElementsIn((Iterable)edges);
        }
    }

    @Override
    @Test
    public void incidentEdges_checkReturnedSetMutability() {
        this.addNode(N1);
        Set incidentEdges = this.network.incidentEdges((Object)N1);
        try {
            incidentEdges.add("1-2");
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.incidentEdges((Object)N1)).containsExactlyElementsIn((Iterable)incidentEdges);
        }
    }

    @Override
    @Test
    public void adjacentNodes_checkReturnedSetMutability() {
        this.addNode(N1);
        Set adjacentNodes = this.network.adjacentNodes((Object)N1);
        try {
            adjacentNodes.add(N2);
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.adjacentNodes((Object)N1)).containsExactlyElementsIn((Iterable)adjacentNodes);
        }
    }

    @Override
    public void adjacentEdges_checkReturnedSetMutability() {
        this.addEdge(N1, N2, "1-2");
        Set adjacentEdges = this.network.adjacentEdges((Object)"1-2");
        try {
            adjacentEdges.add("2-3");
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N2, N3, "2-3");
            Truth.assertThat((Iterable)this.network.adjacentEdges((Object)"1-2")).containsExactlyElementsIn((Iterable)adjacentEdges);
        }
    }

    @Override
    @Test
    public void edgesConnecting_checkReturnedSetMutability() {
        this.addNode(N1);
        this.addNode(N2);
        Set edgesConnecting = this.network.edgesConnecting((Object)N1, (Object)N2);
        try {
            edgesConnecting.add("2-3");
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N2)).containsExactlyElementsIn((Iterable)edgesConnecting);
        }
    }

    @Override
    @Test
    public void inEdges_checkReturnedSetMutability() {
        this.addNode(N2);
        Set inEdges = this.network.inEdges((Object)N2);
        try {
            inEdges.add("1-2");
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.inEdges((Object)N2)).containsExactlyElementsIn((Iterable)inEdges);
        }
    }

    @Override
    @Test
    public void outEdges_checkReturnedSetMutability() {
        this.addNode(N1);
        Set outEdges = this.network.outEdges((Object)N1);
        try {
            outEdges.add("1-2");
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.outEdges((Object)N1)).containsExactlyElementsIn((Iterable)outEdges);
        }
    }

    @Override
    @Test
    public void predecessors_checkReturnedSetMutability() {
        this.addNode(N2);
        Set predecessors = this.network.predecessors((Object)N2);
        try {
            predecessors.add(N1);
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)this.network.predecessors((Object)N2)).containsExactlyElementsIn((Iterable)predecessors);
        }
    }

    @Override
    @Test
    public void successors_checkReturnedSetMutability() {
        this.addNode(N1);
        Set successors = this.network.successors((Object)N1);
        try {
            successors.add(N2);
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.addEdge(N1, N2, "1-2");
            Truth.assertThat((Iterable)successors).containsExactlyElementsIn((Iterable)this.network.successors((Object)N1));
        }
    }

    @Test
    public void addEdge_selfLoop() {
        try {
            this.addEdge(N1, N1, "1-1");
            Assert.fail((String)"Should not be allowed to add a self-loop edge.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)"self-loops are not allowed");
        }
    }

    @Test
    public void addEdge_nodesNotInGraph() {
        this.network.addNode((Object)N1);
        Assert.assertTrue((boolean)this.network.addEdge((Object)N1, (Object)N5, (Object)"1-5"));
        Assert.assertTrue((boolean)this.network.addEdge((Object)N4, (Object)N1, (Object)"4-1"));
        Assert.assertTrue((boolean)this.network.addEdge((Object)N2, (Object)N3, (Object)"2-3"));
        Truth.assertThat((Iterable)this.network.nodes()).containsExactly(new Object[]{N1, N5, N4, N2, N3}).inOrder();
        Truth.assertThat((Iterable)this.network.edges()).containsExactly(new Object[]{"1-5", "4-1", "2-3"}).inOrder();
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N5)).containsExactly(new Object[]{"1-5"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N4, (Object)N1)).containsExactly(new Object[]{"4-1"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N2, (Object)N3)).containsExactly(new Object[]{"2-3"});
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N3, (Object)N2)).isEmpty();
    }
}

