/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AbstractNetwork;
import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.EndpointPair;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.TestUtil;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class DefaultNetworkImplementationsTest {
    private MutableNetwork<Integer, String> network;
    private NetworkForTest<Integer, String> networkForTest;
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer NODE_NOT_IN_GRAPH = 1000;
    private static final String E11 = "1-1";
    private static final String E11_A = "1-1a";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E21 = "2-1";
    private static final String E23 = "2-3";
    private final TestUtil.EdgeType edgeType;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({TestUtil.EdgeType.UNDIRECTED}, {TestUtil.EdgeType.DIRECTED});
    }

    public DefaultNetworkImplementationsTest(TestUtil.EdgeType edgeType) {
        this.edgeType = edgeType;
    }

    @Before
    public void setUp() throws Exception {
        NetworkBuilder builder = this.edgeType == TestUtil.EdgeType.DIRECTED ? NetworkBuilder.directed() : NetworkBuilder.undirected();
        this.network = builder.allowsSelfLoops(true).allowsParallelEdges(true).build();
        this.networkForTest = NetworkForTest.from(this.network);
    }

    @Test
    public void edgesConnecting_disconnectedNodes() {
        this.network.addNode((Object)N1);
        this.network.addNode((Object)N2);
        Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N2)).isEmpty();
    }

    @Test
    public void edgesConnecting_nodesNotInGraph() {
        this.network.addNode((Object)N1);
        this.network.addNode((Object)N2);
        try {
            this.networkForTest.edgesConnecting(N1, NODE_NOT_IN_GRAPH);
            Assert.fail((String)"Should not be allowed to pass a node that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            TestUtil.assertNodeNotInGraphErrorMessage(e);
        }
        try {
            this.networkForTest.edgesConnecting(NODE_NOT_IN_GRAPH, N2);
            Assert.fail((String)"Should not be allowed to pass a node that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            TestUtil.assertNodeNotInGraphErrorMessage(e);
        }
        try {
            this.networkForTest.edgesConnecting(NODE_NOT_IN_GRAPH, NODE_NOT_IN_GRAPH);
            Assert.fail((String)"Should not be allowed to pass a node that is not an element of the graph.");
        }
        catch (IllegalArgumentException e) {
            TestUtil.assertNodeNotInGraphErrorMessage(e);
        }
    }

    @Test
    public void edgesConnecting_checkReturnedSetMutability() {
        this.network.addNode((Object)N1);
        this.network.addNode((Object)N2);
        Set edgesConnecting = this.network.edgesConnecting((Object)N1, (Object)N2);
        try {
            edgesConnecting.add(E23);
            Assert.fail((String)"Collection returned is unexpectedly modifiable");
        }
        catch (UnsupportedOperationException e) {
            this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N2)).containsExactlyElementsIn((Iterable)edgesConnecting);
        }
    }

    @Test
    public void edgesConnecting_oneEdge() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N2)).containsExactly(new Object[]{E12});
        if (this.edgeType == TestUtil.EdgeType.DIRECTED) {
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N2, N1)).isEmpty();
        } else {
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N2, N1)).containsExactly(new Object[]{E12});
        }
    }

    @Test
    public void edgesConnecting_selfLoop() {
        this.network.addEdge((Object)N1, (Object)N1, (Object)E11);
        Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N1)).containsExactly(new Object[]{E11});
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N2)).containsExactly(new Object[]{E12});
        Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N1)).containsExactly(new Object[]{E11});
    }

    @Test
    public void edgesConnecting_parallelEdges() {
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12);
        this.network.addEdge((Object)N1, (Object)N2, (Object)E12_A);
        this.network.addEdge((Object)N2, (Object)N1, (Object)E21);
        if (this.edgeType == TestUtil.EdgeType.DIRECTED) {
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N2)).containsExactly(new Object[]{E12, E12_A});
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N2, N1)).containsExactly(new Object[]{E21});
        } else {
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N1, N2)).containsExactly(new Object[]{E12, E12_A, E21});
            Truth.assertThat((Iterable)this.networkForTest.edgesConnecting(N2, N1)).containsExactly(new Object[]{E12, E12_A, E21});
        }
    }

    @Test
    public void edgesConnecting_parallelSelfLoopEdges() {
        this.network.addEdge((Object)N1, (Object)N1, (Object)E11);
        this.network.addEdge((Object)N1, (Object)N1, (Object)E11_A);
        Truth.assertThat((Iterable)this.network.edgesConnecting((Object)N1, (Object)N1)).containsExactly(new Object[]{E11, E11_A});
    }

    private static class NetworkForTest<N, E>
    extends AbstractNetwork<N, E> {
        private final Network<N, E> network;

        NetworkForTest(Network<N, E> network) {
            this.network = network;
        }

        static <N, E> NetworkForTest<N, E> from(Network<N, E> network) {
            return new NetworkForTest<N, E>(network);
        }

        public Set<N> nodes() {
            return this.network.nodes();
        }

        public Set<E> edges() {
            return this.network.edges();
        }

        public boolean isDirected() {
            return this.network.isDirected();
        }

        public boolean allowsParallelEdges() {
            return this.network.allowsParallelEdges();
        }

        public boolean allowsSelfLoops() {
            return this.network.allowsSelfLoops();
        }

        public ElementOrder<N> nodeOrder() {
            return this.network.nodeOrder();
        }

        public ElementOrder<E> edgeOrder() {
            return this.network.edgeOrder();
        }

        public Set<N> adjacentNodes(N node) {
            return this.network.adjacentNodes(node);
        }

        public Set<N> predecessors(N node) {
            return this.network.predecessors(node);
        }

        public Set<N> successors(N node) {
            return this.network.successors(node);
        }

        public Set<E> incidentEdges(N node) {
            return this.network.incidentEdges(node);
        }

        public Set<E> inEdges(N node) {
            return this.network.inEdges(node);
        }

        public Set<E> outEdges(N node) {
            return this.network.outEdges(node);
        }

        public EndpointPair<N> incidentNodes(E edge) {
            return this.network.incidentNodes(edge);
        }

        public Set<E> adjacentEdges(E edge) {
            return this.network.adjacentEdges(edge);
        }
    }
}

