/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.base.Preconditions;
import com.google.common.collect.Ordering;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import java.util.Comparator;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public final class ElementOrderTest {
    @Test
    public void nodeOrder_none() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.unordered()).build();
        Truth.assertThat((Object)graph.nodeOrder()).isEqualTo((Object)ElementOrder.unordered());
    }

    @Test
    public void nodeOrder_insertion() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.insertion()).build();
        ElementOrderTest.addNodes((MutableGraph<Integer>)graph);
        Truth.assertThat((Object)graph.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
        Truth.assertThat((Iterable)graph.nodes()).containsExactly(new Object[]{3, 1, 4}).inOrder();
    }

    @Test
    public void nodeOrder_default() {
        MutableGraph graph = GraphBuilder.directed().build();
        ElementOrderTest.addNodes((MutableGraph<Integer>)graph);
        Truth.assertThat((Object)graph.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
        Truth.assertThat((Iterable)graph.nodes()).containsExactly(new Object[]{3, 1, 4}).inOrder();
    }

    @Test
    public void nodeOrder_natural() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.natural()).build();
        ElementOrderTest.addNodes((MutableGraph<Integer>)graph);
        Truth.assertThat((Object)graph.nodeOrder()).isEqualTo((Object)ElementOrder.sorted((Comparator)Ordering.natural()));
        Truth.assertThat((Iterable)graph.nodes()).containsExactly(new Object[]{1, 3, 4}).inOrder();
    }

    @Test
    public void nodeOrder_sorted() {
        MutableGraph graph = GraphBuilder.directed().nodeOrder(ElementOrder.sorted((Comparator)Ordering.natural().reverse())).build();
        ElementOrderTest.addNodes((MutableGraph<Integer>)graph);
        Truth.assertThat((Object)graph.nodeOrder()).isEqualTo((Object)ElementOrder.sorted((Comparator)Ordering.natural().reverse()));
        Truth.assertThat((Iterable)graph.nodes()).containsExactly(new Object[]{4, 3, 1}).inOrder();
    }

    @Test
    public void edgeOrder_none() {
        MutableNetwork network = NetworkBuilder.directed().edgeOrder(ElementOrder.unordered()).build();
        Truth.assertThat((Object)network.edgeOrder()).isEqualTo((Object)ElementOrder.unordered());
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
    }

    @Test
    public void edgeOrder_insertion() {
        MutableNetwork network = NetworkBuilder.directed().edgeOrder(ElementOrder.insertion()).build();
        ElementOrderTest.addEdges((MutableNetwork<Integer, String>)network);
        Truth.assertThat((Object)network.edgeOrder()).isEqualTo((Object)ElementOrder.insertion());
        Truth.assertThat((Iterable)network.edges()).containsExactly(new Object[]{"i", "e", "p"}).inOrder();
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
    }

    @Test
    public void edgeOrder_default() {
        MutableNetwork network = NetworkBuilder.directed().build();
        ElementOrderTest.addEdges((MutableNetwork<Integer, String>)network);
        Truth.assertThat((Object)network.edgeOrder()).isEqualTo((Object)ElementOrder.insertion());
        Truth.assertThat((Iterable)network.edges()).containsExactly(new Object[]{"i", "e", "p"}).inOrder();
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
    }

    @Test
    public void edgeOrder_natural() {
        MutableNetwork network = NetworkBuilder.directed().edgeOrder(ElementOrder.natural()).build();
        ElementOrderTest.addEdges((MutableNetwork<Integer, String>)network);
        Truth.assertThat((Object)network.edgeOrder()).isEqualTo((Object)ElementOrder.sorted((Comparator)Ordering.natural()));
        Truth.assertThat((Iterable)network.edges()).containsExactly(new Object[]{"e", "i", "p"}).inOrder();
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
    }

    @Test
    public void edgeOrder_sorted() {
        MutableNetwork network = NetworkBuilder.directed().edgeOrder(ElementOrder.sorted((Comparator)Ordering.natural().reverse())).build();
        ElementOrderTest.addEdges((MutableNetwork<Integer, String>)network);
        Truth.assertThat((Object)network.edgeOrder()).isEqualTo((Object)ElementOrder.sorted((Comparator)Ordering.natural().reverse()));
        Truth.assertThat((Iterable)network.edges()).containsExactly(new Object[]{"p", "i", "e"}).inOrder();
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)ElementOrder.insertion());
    }

    @Test
    public void nodeOrderUnorderedandEdgesSorted() {
        MutableNetwork network = NetworkBuilder.directed().nodeOrder(ElementOrder.unordered()).edgeOrder(ElementOrder.sorted((Comparator)Ordering.natural().reverse())).build();
        ElementOrderTest.addEdges((MutableNetwork<Integer, String>)network);
        Truth.assertThat((Object)network.edgeOrder()).isEqualTo((Object)ElementOrder.sorted((Comparator)Ordering.natural().reverse()));
        Truth.assertThat((Iterable)network.edges()).containsExactly(new Object[]{"p", "i", "e"}).inOrder();
        Truth.assertThat((Object)network.nodeOrder()).isEqualTo((Object)ElementOrder.unordered());
        Truth.assertThat((Iterable)network.nodes()).containsExactly(new Object[]{4, 1, 3});
    }

    @Test
    public void customComparator() {
        Comparator<NonComparableSuperClass> comparator = new Comparator<NonComparableSuperClass>(){

            @Override
            public int compare(NonComparableSuperClass left, NonComparableSuperClass right) {
                return left.value.compareTo(right.value);
            }
        };
        MutableGraph graph = GraphBuilder.undirected().nodeOrder(ElementOrder.sorted((Comparator)comparator)).build();
        NonComparableSuperClass node1 = new NonComparableSuperClass(1);
        NonComparableSuperClass node3 = new NonComparableSuperClass(3);
        NonComparableSuperClass node5 = new NonComparableSuperClass(5);
        NonComparableSuperClass node7 = new NonComparableSuperClass(7);
        graph.addNode((Object)node1);
        graph.addNode((Object)node7);
        graph.addNode((Object)node5);
        graph.addNode((Object)node3);
        Truth.assertThat((Object)graph.nodeOrder().comparator()).isEqualTo((Object)comparator);
        Truth.assertThat((Iterable)graph.nodes()).containsExactly(new Object[]{node1, node3, node5, node7}).inOrder();
    }

    @Test
    public void customComparable() {
        MutableGraph graph = GraphBuilder.undirected().nodeOrder(ElementOrder.natural()).build();
        ComparableSubClass node2 = new ComparableSubClass(2);
        ComparableSubClass node4 = new ComparableSubClass(4);
        ComparableSubClass node6 = new ComparableSubClass(6);
        ComparableSubClass node8 = new ComparableSubClass(8);
        graph.addNode((Object)node4);
        graph.addNode((Object)node2);
        graph.addNode((Object)node6);
        graph.addNode((Object)node8);
        Truth.assertThat((Object)graph.nodeOrder().comparator()).isEqualTo((Object)Ordering.natural());
        Truth.assertThat((Iterable)graph.nodes()).containsExactly(new Object[]{node2, node4, node6, node8}).inOrder();
    }

    private static void addNodes(MutableGraph<Integer> graph) {
        graph.addNode((Object)3);
        graph.addNode((Object)1);
        graph.addNode((Object)4);
    }

    private static void addEdges(MutableNetwork<Integer, String> network) {
        network.addEdge((Object)3, (Object)1, (Object)"i");
        network.addEdge((Object)1, (Object)4, (Object)"e");
        network.addEdge((Object)4, (Object)3, (Object)"p");
    }

    private static class ComparableSubClass
    extends NonComparableSuperClass
    implements Comparable<NonComparableSuperClass> {
        ComparableSubClass(Integer value) {
            super(value);
        }

        @Override
        public int compareTo(NonComparableSuperClass other) {
            return this.value.compareTo(other.value);
        }
    }

    private static class NonComparableSuperClass {
        final Integer value;

        NonComparableSuperClass(Integer value) {
            this.value = (Integer)Preconditions.checkNotNull((Object)value);
        }

        public String toString() {
            return "value=" + this.value;
        }
    }
}

