/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.AndroidIncompatible;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.TestUtil;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collection;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@AndroidIncompatible
public final class GraphEquivalenceTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private final TestUtil.EdgeType edgeType;
    private final MutableGraph<Integer> graph;

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return Arrays.asList({TestUtil.EdgeType.UNDIRECTED}, {TestUtil.EdgeType.DIRECTED});
    }

    public GraphEquivalenceTest(TestUtil.EdgeType edgeType) {
        this.edgeType = edgeType;
        this.graph = GraphEquivalenceTest.createGraph(edgeType);
    }

    private static MutableGraph<Integer> createGraph(TestUtil.EdgeType edgeType) {
        switch (edgeType) {
            case UNDIRECTED: {
                return GraphBuilder.undirected().allowsSelfLoops(true).build();
            }
            case DIRECTED: {
                return GraphBuilder.directed().allowsSelfLoops(true).build();
            }
        }
        throw new IllegalStateException("Unexpected edge type: " + (Object)((Object)edgeType));
    }

    private static TestUtil.EdgeType oppositeType(TestUtil.EdgeType edgeType) {
        switch (edgeType) {
            case UNDIRECTED: {
                return TestUtil.EdgeType.DIRECTED;
            }
            case DIRECTED: {
                return TestUtil.EdgeType.UNDIRECTED;
            }
        }
        throw new IllegalStateException("Unexpected edge type: " + (Object)((Object)edgeType));
    }

    @Test
    public void equivalent_nodeSetsDiffer() {
        this.graph.addNode((Object)N1);
        MutableGraph<Integer> g2 = GraphEquivalenceTest.createGraph(this.edgeType);
        g2.addNode((Object)N2);
        Truth.assertThat(this.graph).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_directedVsUndirected() {
        this.graph.putEdge((Object)N1, (Object)N2);
        MutableGraph<Integer> g2 = GraphEquivalenceTest.createGraph(GraphEquivalenceTest.oppositeType(this.edgeType));
        g2.putEdge((Object)N1, (Object)N2);
        Truth.assertThat(this.graph).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_selfLoop_directedVsUndirected() {
        this.graph.putEdge((Object)N1, (Object)N1);
        MutableGraph<Integer> g2 = GraphEquivalenceTest.createGraph(GraphEquivalenceTest.oppositeType(this.edgeType));
        g2.putEdge((Object)N1, (Object)N1);
        Truth.assertThat(this.graph).isNotEqualTo(g2);
    }

    @Test
    public void equivalent_propertiesDiffer() {
        this.graph.putEdge((Object)N1, (Object)N2);
        MutableGraph g2 = GraphBuilder.from(this.graph).allowsSelfLoops(!this.graph.allowsSelfLoops()).build();
        g2.putEdge((Object)N1, (Object)N2);
        Truth.assertThat(this.graph).isEqualTo((Object)g2);
    }

    @Test
    public void equivalent_edgeAddOrdersDiffer() {
        GraphBuilder builder = GraphBuilder.from(this.graph);
        MutableGraph g1 = builder.build();
        MutableGraph g2 = builder.build();
        g1.putEdge((Object)N1, (Object)N2);
        g1.putEdge((Object)N3, (Object)N1);
        g2.putEdge((Object)N3, (Object)N1);
        g2.putEdge((Object)N1, (Object)N2);
        Truth.assertThat((Object)g1).isEqualTo((Object)g2);
    }

    @Test
    public void equivalent_edgeDirectionsDiffer() {
        this.graph.putEdge((Object)N1, (Object)N2);
        MutableGraph<Integer> g2 = GraphEquivalenceTest.createGraph(this.edgeType);
        g2.putEdge((Object)N2, (Object)N1);
        switch (this.edgeType) {
            case UNDIRECTED: {
                Truth.assertThat(this.graph).isEqualTo(g2);
                break;
            }
            case DIRECTED: {
                Truth.assertThat(this.graph).isNotEqualTo(g2);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected edge type: " + (Object)((Object)this.edgeType));
            }
        }
    }
}

