/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.collect.ImmutableSet;
import com.google.common.graph.AbstractGraphTest;
import com.google.common.graph.AbstractNetworkTest;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.Graphs;
import com.google.common.graph.MutableGraph;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.MutableValueGraph;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.graph.ValueGraph;
import com.google.common.graph.ValueGraphBuilder;
import com.google.common.truth.Truth;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class GraphsTest {
    private static final Integer N1 = 1;
    private static final Integer N2 = 2;
    private static final Integer N3 = 3;
    private static final Integer N4 = 4;
    private static final String E11 = "1-1";
    private static final String E11_A = "1-1a";
    private static final String E12 = "1-2";
    private static final String E12_A = "1-2a";
    private static final String E12_B = "1-2b";
    private static final String E21 = "2-1";
    private static final String E13 = "1-3";
    private static final String E31 = "3-1";
    private static final String E34 = "3-4";
    private static final String E44 = "4-4";
    private static final int NODE_COUNT = 20;
    private static final int EDGE_COUNT = 20;
    private static final String ERROR_PARALLEL_EDGE = "connected by a different edge";
    private static final String ERROR_NEGATIVE_COUNT = "is non-negative";
    private static final String ERROR_ADDED_PARALLEL_EDGE = "Should not be allowed to add a parallel edge.";
    private static final String ERROR_ADDED_SELF_LOOP = "Should not be allowed to add a self-loop edge.";
    static final String ERROR_SELF_LOOP = "self-loops are not allowed";

    @Test
    public void transitiveClosure_directedGraph() {
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N1, (Object)N3);
        directedGraph.putEdge((Object)N2, (Object)N3);
        directedGraph.addNode((Object)N4);
        MutableGraph expectedClosure = GraphBuilder.directed().allowsSelfLoops(true).build();
        expectedClosure.putEdge((Object)N1, (Object)N1);
        expectedClosure.putEdge((Object)N1, (Object)N2);
        expectedClosure.putEdge((Object)N1, (Object)N3);
        expectedClosure.putEdge((Object)N2, (Object)N2);
        expectedClosure.putEdge((Object)N2, (Object)N3);
        expectedClosure.putEdge((Object)N3, (Object)N3);
        expectedClosure.putEdge((Object)N4, (Object)N4);
        GraphsTest.checkTransitiveClosure(directedGraph, expectedClosure);
    }

    @Test
    public void transitiveClosure_undirectedGraph() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().allowsSelfLoops(false).build();
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        undirectedGraph.putEdge((Object)N1, (Object)N3);
        undirectedGraph.putEdge((Object)N2, (Object)N3);
        undirectedGraph.addNode((Object)N4);
        MutableGraph expectedClosure = GraphBuilder.undirected().allowsSelfLoops(true).build();
        expectedClosure.putEdge((Object)N1, (Object)N1);
        expectedClosure.putEdge((Object)N1, (Object)N2);
        expectedClosure.putEdge((Object)N1, (Object)N3);
        expectedClosure.putEdge((Object)N2, (Object)N2);
        expectedClosure.putEdge((Object)N2, (Object)N3);
        expectedClosure.putEdge((Object)N3, (Object)N3);
        expectedClosure.putEdge((Object)N4, (Object)N4);
        GraphsTest.checkTransitiveClosure(undirectedGraph, expectedClosure);
    }

    @Test
    public void transitiveClosure_directedPathGraph() {
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N2, (Object)N3);
        directedGraph.putEdge((Object)N3, (Object)N4);
        MutableGraph expectedClosure = GraphBuilder.directed().allowsSelfLoops(true).build();
        expectedClosure.putEdge((Object)N1, (Object)N1);
        expectedClosure.putEdge((Object)N1, (Object)N2);
        expectedClosure.putEdge((Object)N1, (Object)N3);
        expectedClosure.putEdge((Object)N1, (Object)N4);
        expectedClosure.putEdge((Object)N2, (Object)N2);
        expectedClosure.putEdge((Object)N2, (Object)N3);
        expectedClosure.putEdge((Object)N2, (Object)N4);
        expectedClosure.putEdge((Object)N3, (Object)N3);
        expectedClosure.putEdge((Object)N3, (Object)N4);
        expectedClosure.putEdge((Object)N4, (Object)N4);
        GraphsTest.checkTransitiveClosure(directedGraph, expectedClosure);
    }

    @Test
    public void transitiveClosure_undirectedPathGraph() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().allowsSelfLoops(false).build();
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        undirectedGraph.putEdge((Object)N2, (Object)N3);
        undirectedGraph.putEdge((Object)N3, (Object)N4);
        MutableGraph expectedClosure = GraphBuilder.undirected().allowsSelfLoops(true).build();
        expectedClosure.putEdge((Object)N1, (Object)N1);
        expectedClosure.putEdge((Object)N1, (Object)N2);
        expectedClosure.putEdge((Object)N1, (Object)N3);
        expectedClosure.putEdge((Object)N1, (Object)N4);
        expectedClosure.putEdge((Object)N2, (Object)N2);
        expectedClosure.putEdge((Object)N2, (Object)N3);
        expectedClosure.putEdge((Object)N2, (Object)N4);
        expectedClosure.putEdge((Object)N3, (Object)N3);
        expectedClosure.putEdge((Object)N3, (Object)N4);
        expectedClosure.putEdge((Object)N4, (Object)N4);
        GraphsTest.checkTransitiveClosure(undirectedGraph, expectedClosure);
    }

    @Test
    public void transitiveClosure_directedCycleGraph() {
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(false).build();
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N2, (Object)N3);
        directedGraph.putEdge((Object)N3, (Object)N4);
        directedGraph.putEdge((Object)N4, (Object)N1);
        MutableGraph expectedClosure = GraphBuilder.directed().allowsSelfLoops(true).build();
        expectedClosure.putEdge((Object)N1, (Object)N1);
        expectedClosure.putEdge((Object)N1, (Object)N2);
        expectedClosure.putEdge((Object)N1, (Object)N3);
        expectedClosure.putEdge((Object)N1, (Object)N4);
        expectedClosure.putEdge((Object)N2, (Object)N1);
        expectedClosure.putEdge((Object)N2, (Object)N2);
        expectedClosure.putEdge((Object)N2, (Object)N3);
        expectedClosure.putEdge((Object)N2, (Object)N4);
        expectedClosure.putEdge((Object)N3, (Object)N1);
        expectedClosure.putEdge((Object)N3, (Object)N2);
        expectedClosure.putEdge((Object)N3, (Object)N3);
        expectedClosure.putEdge((Object)N3, (Object)N4);
        expectedClosure.putEdge((Object)N4, (Object)N1);
        expectedClosure.putEdge((Object)N4, (Object)N2);
        expectedClosure.putEdge((Object)N4, (Object)N3);
        expectedClosure.putEdge((Object)N4, (Object)N4);
        GraphsTest.checkTransitiveClosure(directedGraph, expectedClosure);
    }

    @Test
    public void transitiveClosure_undirectedCycleGraph() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().allowsSelfLoops(false).build();
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        undirectedGraph.putEdge((Object)N2, (Object)N3);
        undirectedGraph.putEdge((Object)N3, (Object)N4);
        undirectedGraph.putEdge((Object)N4, (Object)N1);
        MutableGraph expectedClosure = GraphBuilder.undirected().allowsSelfLoops(true).build();
        expectedClosure.putEdge((Object)N1, (Object)N1);
        expectedClosure.putEdge((Object)N1, (Object)N2);
        expectedClosure.putEdge((Object)N1, (Object)N3);
        expectedClosure.putEdge((Object)N1, (Object)N4);
        expectedClosure.putEdge((Object)N2, (Object)N2);
        expectedClosure.putEdge((Object)N2, (Object)N3);
        expectedClosure.putEdge((Object)N2, (Object)N4);
        expectedClosure.putEdge((Object)N3, (Object)N3);
        expectedClosure.putEdge((Object)N3, (Object)N4);
        expectedClosure.putEdge((Object)N4, (Object)N4);
        GraphsTest.checkTransitiveClosure(undirectedGraph, expectedClosure);
    }

    @Test
    public void transpose_undirectedGraph() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().build();
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        Truth.assertThat((Object)Graphs.transpose((Graph)undirectedGraph)).isSameAs((Object)undirectedGraph);
    }

    @Test
    public void transpose_directedGraph() {
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.putEdge((Object)N1, (Object)N3);
        directedGraph.putEdge((Object)N3, (Object)N1);
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N1, (Object)N1);
        directedGraph.putEdge((Object)N3, (Object)N4);
        MutableGraph expectedTranspose = GraphBuilder.directed().allowsSelfLoops(true).build();
        expectedTranspose.putEdge((Object)N3, (Object)N1);
        expectedTranspose.putEdge((Object)N1, (Object)N3);
        expectedTranspose.putEdge((Object)N2, (Object)N1);
        expectedTranspose.putEdge((Object)N1, (Object)N1);
        expectedTranspose.putEdge((Object)N4, (Object)N3);
        Graph transpose = Graphs.transpose((Graph)directedGraph);
        Truth.assertThat((Object)transpose).isEqualTo((Object)expectedTranspose);
        Truth.assertThat((Object)Graphs.transpose((Graph)transpose)).isSameAs((Object)directedGraph);
        AbstractGraphTest.validateGraph(transpose);
        for (Integer node : directedGraph.nodes()) {
            Truth.assertThat((Integer)directedGraph.inDegree((Object)node)).isSameAs((Object)transpose.outDegree((Object)node));
            Truth.assertThat((Integer)directedGraph.outDegree((Object)node)).isSameAs((Object)transpose.inDegree((Object)node));
        }
        Truth.assertThat((Iterable)transpose.successors((Object)N1)).doesNotContain((Object)N2);
        directedGraph.putEdge((Object)N2, (Object)N1);
        Truth.assertThat((Iterable)transpose.successors((Object)N1)).contains((Object)N2);
        AbstractGraphTest.validateGraph(transpose);
    }

    @Test
    public void transpose_undirectedValueGraph() {
        MutableValueGraph undirectedGraph = ValueGraphBuilder.undirected().build();
        undirectedGraph.putEdgeValue((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat((Object)Graphs.transpose((ValueGraph)undirectedGraph)).isSameAs((Object)undirectedGraph);
    }

    @Test
    public void transpose_directedValueGraph() {
        MutableValueGraph directedGraph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.putEdgeValue((Object)N1, (Object)N3, (Object)E13);
        directedGraph.putEdgeValue((Object)N3, (Object)N1, (Object)E31);
        directedGraph.putEdgeValue((Object)N1, (Object)N2, (Object)E12);
        directedGraph.putEdgeValue((Object)N1, (Object)N1, (Object)E11);
        directedGraph.putEdgeValue((Object)N3, (Object)N4, (Object)E34);
        MutableValueGraph expectedTranspose = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        expectedTranspose.putEdgeValue((Object)N3, (Object)N1, (Object)E13);
        expectedTranspose.putEdgeValue((Object)N1, (Object)N3, (Object)E31);
        expectedTranspose.putEdgeValue((Object)N2, (Object)N1, (Object)E12);
        expectedTranspose.putEdgeValue((Object)N1, (Object)N1, (Object)E11);
        expectedTranspose.putEdgeValue((Object)N4, (Object)N3, (Object)E34);
        ValueGraph transpose = Graphs.transpose((ValueGraph)directedGraph);
        Truth.assertThat((Object)transpose).isEqualTo((Object)expectedTranspose);
        Truth.assertThat((Object)Graphs.transpose((ValueGraph)transpose)).isSameAs((Object)directedGraph);
        AbstractGraphTest.validateGraph(transpose.asGraph());
        Truth.assertThat((String)((String)transpose.edgeValueOrDefault((Object)N1, (Object)N2, null))).isNull();
        for (Integer node : directedGraph.nodes()) {
            Truth.assertThat((Integer)directedGraph.inDegree((Object)node)).isSameAs((Object)transpose.outDegree((Object)node));
            Truth.assertThat((Integer)directedGraph.outDegree((Object)node)).isSameAs((Object)transpose.inDegree((Object)node));
        }
        directedGraph.putEdgeValue((Object)N2, (Object)N1, (Object)E21);
        Truth.assertThat((String)((String)transpose.edgeValueOrDefault((Object)N1, (Object)N2, null))).isEqualTo((Object)E21);
        AbstractGraphTest.validateGraph(transpose.asGraph());
    }

    @Test
    public void transpose_undirectedNetwork() {
        MutableNetwork undirectedGraph = NetworkBuilder.undirected().build();
        undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12);
        Truth.assertThat((Object)Graphs.transpose((Network)undirectedGraph)).isSameAs((Object)undirectedGraph);
    }

    @Test
    public void transpose_directedNetwork() {
        MutableNetwork directedGraph = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        directedGraph.addEdge((Object)N1, (Object)N3, (Object)E13);
        directedGraph.addEdge((Object)N3, (Object)N1, (Object)E31);
        directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12);
        directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12_A);
        directedGraph.addEdge((Object)N1, (Object)N1, (Object)E11);
        directedGraph.addEdge((Object)N3, (Object)N4, (Object)E34);
        MutableNetwork expectedTranspose = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        expectedTranspose.addEdge((Object)N3, (Object)N1, (Object)E13);
        expectedTranspose.addEdge((Object)N1, (Object)N3, (Object)E31);
        expectedTranspose.addEdge((Object)N2, (Object)N1, (Object)E12);
        expectedTranspose.addEdge((Object)N2, (Object)N1, (Object)E12_A);
        expectedTranspose.addEdge((Object)N1, (Object)N1, (Object)E11);
        expectedTranspose.addEdge((Object)N4, (Object)N3, (Object)E34);
        Network transpose = Graphs.transpose((Network)directedGraph);
        Truth.assertThat((Object)transpose).isEqualTo((Object)expectedTranspose);
        Truth.assertThat((Object)Graphs.transpose((Network)transpose)).isSameAs((Object)directedGraph);
        AbstractNetworkTest.validateNetwork(transpose);
        Truth.assertThat((Iterable)transpose.edgesConnecting((Object)N1, (Object)N2)).isEmpty();
        Truth.assertThat((Boolean)transpose.edgeConnecting((Object)N1, (Object)N2).isPresent()).isFalse();
        Truth.assertThat((String)((String)transpose.edgeConnectingOrNull((Object)N1, (Object)N2))).isNull();
        for (Integer node : directedGraph.nodes()) {
            Truth.assertThat((Integer)directedGraph.inDegree((Object)node)).isSameAs((Object)transpose.outDegree((Object)node));
            Truth.assertThat((Integer)directedGraph.outDegree((Object)node)).isSameAs((Object)transpose.inDegree((Object)node));
        }
        directedGraph.addEdge((Object)N2, (Object)N1, (Object)E21);
        Truth.assertThat((Iterable)transpose.edgesConnecting((Object)N1, (Object)N2)).containsExactly(new Object[]{E21});
        Truth.assertThat((String)((String)transpose.edgeConnecting((Object)N1, (Object)N2).get())).isEqualTo((Object)E21);
        Truth.assertThat((String)((String)transpose.edgeConnectingOrNull((Object)N1, (Object)N2))).isEqualTo((Object)E21);
        AbstractNetworkTest.validateNetwork(transpose);
    }

    @Test
    public void inducedSubgraph_graph() {
        ImmutableSet nodeSubset = ImmutableSet.of((Object)N1, (Object)N2, (Object)N4);
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N2, (Object)N1);
        directedGraph.putEdge((Object)N1, (Object)N3);
        directedGraph.putEdge((Object)N4, (Object)N4);
        directedGraph.putEdge((Object)5, (Object)6);
        MutableGraph expectedSubgraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        expectedSubgraph.putEdge((Object)N1, (Object)N2);
        expectedSubgraph.putEdge((Object)N2, (Object)N1);
        expectedSubgraph.putEdge((Object)N4, (Object)N4);
        Truth.assertThat((Object)Graphs.inducedSubgraph((Graph)directedGraph, (Iterable)nodeSubset)).isEqualTo((Object)expectedSubgraph);
    }

    @Test
    public void inducedSubgraph_valueGraph() {
        ImmutableSet nodeSubset = ImmutableSet.of((Object)N1, (Object)N2, (Object)N4);
        MutableValueGraph directedGraph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.putEdgeValue((Object)N1, (Object)N2, (Object)E12);
        directedGraph.putEdgeValue((Object)N2, (Object)N1, (Object)E21);
        directedGraph.putEdgeValue((Object)N1, (Object)N3, (Object)E13);
        directedGraph.putEdgeValue((Object)N4, (Object)N4, (Object)E44);
        directedGraph.putEdgeValue((Object)5, (Object)6, (Object)"5-6");
        MutableValueGraph expectedSubgraph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        expectedSubgraph.putEdgeValue((Object)N1, (Object)N2, (Object)E12);
        expectedSubgraph.putEdgeValue((Object)N2, (Object)N1, (Object)E21);
        expectedSubgraph.putEdgeValue((Object)N4, (Object)N4, (Object)E44);
        Truth.assertThat((Object)Graphs.inducedSubgraph((ValueGraph)directedGraph, (Iterable)nodeSubset)).isEqualTo((Object)expectedSubgraph);
    }

    @Test
    public void inducedSubgraph_network() {
        ImmutableSet nodeSubset = ImmutableSet.of((Object)N1, (Object)N2, (Object)N4);
        MutableNetwork directedGraph = NetworkBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12);
        directedGraph.addEdge((Object)N2, (Object)N1, (Object)E21);
        directedGraph.addEdge((Object)N1, (Object)N3, (Object)E13);
        directedGraph.addEdge((Object)N4, (Object)N4, (Object)E44);
        directedGraph.addEdge((Object)5, (Object)6, (Object)"5-6");
        MutableNetwork expectedSubgraph = NetworkBuilder.directed().allowsSelfLoops(true).build();
        expectedSubgraph.addEdge((Object)N1, (Object)N2, (Object)E12);
        expectedSubgraph.addEdge((Object)N2, (Object)N1, (Object)E21);
        expectedSubgraph.addEdge((Object)N4, (Object)N4, (Object)E44);
        Truth.assertThat((Object)Graphs.inducedSubgraph((Network)directedGraph, (Iterable)nodeSubset)).isEqualTo((Object)expectedSubgraph);
    }

    @Test
    public void inducedSubgraph_nodeNotInGraph() {
        MutableNetwork undirectedGraph = NetworkBuilder.undirected().build();
        try {
            Graphs.inducedSubgraph((Network)undirectedGraph, (Iterable)ImmutableSet.of((Object)N1));
            Assert.fail((String)"Should have rejected getting induced subgraph with node not in original graph.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void copyOf_nullArgument() {
        try {
            Graphs.copyOf((Graph)null);
            Assert.fail((String)"Should have rejected a null graph.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void copyOf_directedGraph() {
        MutableGraph<Integer> directedGraph = GraphsTest.buildDirectedGraph();
        MutableGraph copy = Graphs.copyOf(directedGraph);
        Truth.assertThat((Object)copy).isEqualTo(directedGraph);
    }

    @Test
    public void copyOf_undirectedGraph() {
        MutableGraph<Integer> undirectedGraph = GraphsTest.buildUndirectedGraph();
        MutableGraph copy = Graphs.copyOf(undirectedGraph);
        Truth.assertThat((Object)copy).isEqualTo(undirectedGraph);
    }

    @Test
    public void copyOf_directedValueGraph() {
        MutableValueGraph<Integer, String> directedGraph = GraphsTest.buildDirectedValueGraph();
        MutableValueGraph copy = Graphs.copyOf(directedGraph);
        Truth.assertThat((Object)copy).isEqualTo(directedGraph);
    }

    @Test
    public void copyOf_undirectedValueGraph() {
        MutableValueGraph<Integer, String> undirectedGraph = GraphsTest.buildUndirectedValueGraph();
        MutableValueGraph copy = Graphs.copyOf(undirectedGraph);
        Truth.assertThat((Object)copy).isEqualTo(undirectedGraph);
    }

    @Test
    public void copyOf_directedNetwork() {
        MutableNetwork<Integer, String> directedGraph = GraphsTest.buildDirectedNetwork();
        MutableNetwork copy = Graphs.copyOf(directedGraph);
        Truth.assertThat((Object)copy).isEqualTo(directedGraph);
    }

    @Test
    public void copyOf_undirectedNetwork() {
        MutableNetwork<Integer, String> undirectedGraph = GraphsTest.buildUndirectedNetwork();
        MutableNetwork copy = Graphs.copyOf(undirectedGraph);
        Truth.assertThat((Object)copy).isEqualTo(undirectedGraph);
    }

    @Test
    public void createDirected() {
        MutableNetwork directedGraph = NetworkBuilder.directed().build();
        Truth.assertThat((Iterable)directedGraph.nodes()).isEmpty();
        Truth.assertThat((Iterable)directedGraph.edges()).isEmpty();
        Truth.assertThat((Boolean)directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Iterable)directedGraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        Truth.assertThat((Iterable)directedGraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
        try {
            directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12_A);
            Assert.fail((String)ERROR_ADDED_PARALLEL_EDGE);
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_PARALLEL_EDGE);
        }
        try {
            directedGraph.addEdge((Object)N1, (Object)N1, (Object)E11);
            Assert.fail((String)ERROR_ADDED_SELF_LOOP);
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_SELF_LOOP);
        }
    }

    @Test
    public void createUndirected() {
        MutableNetwork undirectedGraph = NetworkBuilder.undirected().build();
        Truth.assertThat((Iterable)undirectedGraph.nodes()).isEmpty();
        Truth.assertThat((Iterable)undirectedGraph.edges()).isEmpty();
        Truth.assertThat((Boolean)undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Iterable)undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        Truth.assertThat((Iterable)undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        try {
            undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12_A);
            Assert.fail((String)ERROR_ADDED_PARALLEL_EDGE);
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_PARALLEL_EDGE);
        }
        try {
            undirectedGraph.addEdge((Object)N2, (Object)N1, (Object)E21);
            Assert.fail((String)ERROR_ADDED_PARALLEL_EDGE);
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_PARALLEL_EDGE);
        }
        try {
            undirectedGraph.addEdge((Object)N1, (Object)N1, (Object)E11);
            Assert.fail((String)ERROR_ADDED_SELF_LOOP);
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_SELF_LOOP);
        }
    }

    @Test
    public void createDirected_multigraph() {
        MutableNetwork directedMultigraph = NetworkBuilder.directed().allowsParallelEdges(true).build();
        Truth.assertThat((Boolean)directedMultigraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Boolean)directedMultigraph.addEdge((Object)N1, (Object)N2, (Object)E12_A)).isTrue();
        Truth.assertThat((Iterable)directedMultigraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12, (Object)E12_A));
        Truth.assertThat((Iterable)directedMultigraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void createUndirected_multigraph() {
        MutableNetwork undirectedMultigraph = NetworkBuilder.undirected().allowsParallelEdges(true).build();
        Truth.assertThat((Boolean)undirectedMultigraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Boolean)undirectedMultigraph.addEdge((Object)N1, (Object)N2, (Object)E12_A)).isTrue();
        Truth.assertThat((Boolean)undirectedMultigraph.addEdge((Object)N2, (Object)N1, (Object)E21)).isTrue();
        Truth.assertThat((Iterable)undirectedMultigraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12, (Object)E12_A, (Object)E21));
    }

    @Test
    public void createDirected_expectedNodeCount() {
        MutableNetwork directedGraph = NetworkBuilder.directed().expectedNodeCount(20).build();
        Truth.assertThat((Boolean)directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Iterable)directedGraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        Truth.assertThat((Iterable)directedGraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void createUndirected_expectedNodeCount() {
        MutableNetwork undirectedGraph = NetworkBuilder.undirected().expectedNodeCount(20).build();
        Truth.assertThat((Boolean)undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Iterable)undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        Truth.assertThat((Iterable)undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).isEqualTo((Object)ImmutableSet.of((Object)E12));
    }

    @Test
    public void builder_expectedNodeCount_negative() {
        try {
            NetworkBuilder.directed().expectedNodeCount(-1);
            Assert.fail((String)"Should have rejected negative expected node count.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_NEGATIVE_COUNT);
        }
    }

    @Test
    public void createDirected_expectedEdgeCount() {
        MutableNetwork directedGraph = NetworkBuilder.directed().expectedEdgeCount(20).build();
        Truth.assertThat((Boolean)directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Iterable)directedGraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        Truth.assertThat((Iterable)directedGraph.edgesConnecting((Object)N2, (Object)N1)).isEmpty();
    }

    @Test
    public void createUndirected_expectedEdgeCount() {
        MutableNetwork undirectedGraph = NetworkBuilder.undirected().expectedEdgeCount(20).build();
        Truth.assertThat((Boolean)undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12)).isTrue();
        Truth.assertThat((Iterable)undirectedGraph.edgesConnecting((Object)N1, (Object)N2)).isEqualTo((Object)ImmutableSet.of((Object)E12));
        Truth.assertThat((Iterable)undirectedGraph.edgesConnecting((Object)N2, (Object)N1)).isEqualTo((Object)ImmutableSet.of((Object)E12));
    }

    @Test
    public void builder_expectedEdgeCount_negative() {
        try {
            NetworkBuilder.directed().expectedEdgeCount(-1);
            Assert.fail((String)"Should have rejected negative expected edge count.");
        }
        catch (IllegalArgumentException e) {
            Truth.assertThat((String)e.getMessage()).contains((CharSequence)ERROR_NEGATIVE_COUNT);
        }
    }

    private static <N> void checkTransitiveClosure(Graph<N> originalGraph, Graph<N> expectedClosure) {
        for (Object node : originalGraph.nodes()) {
            Truth.assertThat((Iterable)Graphs.reachableNodes(originalGraph, node)).isEqualTo((Object)expectedClosure.successors(node));
        }
        Truth.assertThat((Object)Graphs.transitiveClosure(originalGraph)).isEqualTo(expectedClosure);
    }

    private static MutableGraph<Integer> buildDirectedGraph() {
        MutableGraph directedGraph = GraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.putEdge((Object)N1, (Object)N1);
        directedGraph.putEdge((Object)N1, (Object)N2);
        directedGraph.putEdge((Object)N2, (Object)N1);
        return directedGraph;
    }

    private static MutableGraph<Integer> buildUndirectedGraph() {
        MutableGraph undirectedGraph = GraphBuilder.undirected().allowsSelfLoops(true).build();
        undirectedGraph.putEdge((Object)N1, (Object)N1);
        undirectedGraph.putEdge((Object)N1, (Object)N2);
        undirectedGraph.putEdge((Object)N2, (Object)N1);
        return undirectedGraph;
    }

    private static MutableValueGraph<Integer, String> buildDirectedValueGraph() {
        MutableValueGraph directedGraph = ValueGraphBuilder.directed().allowsSelfLoops(true).build();
        directedGraph.putEdgeValue((Object)N1, (Object)N1, (Object)E11);
        directedGraph.putEdgeValue((Object)N1, (Object)N2, (Object)E12);
        directedGraph.putEdgeValue((Object)N2, (Object)N1, (Object)E21);
        return directedGraph;
    }

    private static MutableValueGraph<Integer, String> buildUndirectedValueGraph() {
        MutableValueGraph undirectedGraph = ValueGraphBuilder.undirected().allowsSelfLoops(true).build();
        undirectedGraph.putEdgeValue((Object)N1, (Object)N1, (Object)E11);
        undirectedGraph.putEdgeValue((Object)N1, (Object)N2, (Object)E12);
        undirectedGraph.putEdgeValue((Object)N2, (Object)N1, (Object)E21);
        return undirectedGraph;
    }

    private static MutableNetwork<Integer, String> buildDirectedNetwork() {
        MutableNetwork directedGraph = NetworkBuilder.directed().allowsParallelEdges(true).allowsSelfLoops(true).build();
        directedGraph.addEdge((Object)N1, (Object)N1, (Object)E11);
        directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12);
        directedGraph.addEdge((Object)N1, (Object)N1, (Object)E11_A);
        directedGraph.addEdge((Object)N1, (Object)N2, (Object)E12_A);
        directedGraph.addEdge((Object)N2, (Object)N1, (Object)E21);
        return directedGraph;
    }

    private static MutableNetwork<Integer, String> buildUndirectedNetwork() {
        MutableNetwork undirectedGraph = NetworkBuilder.undirected().allowsParallelEdges(true).allowsSelfLoops(true).build();
        undirectedGraph.addEdge((Object)N1, (Object)N1, (Object)E11);
        undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12);
        undirectedGraph.addEdge((Object)N1, (Object)N1, (Object)E11_A);
        undirectedGraph.addEdge((Object)N1, (Object)N2, (Object)E12_A);
        undirectedGraph.addEdge((Object)N2, (Object)N1, (Object)E21);
        return undirectedGraph;
    }
}

