/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.graph;

import com.google.common.graph.ImmutableGraph;
import com.google.common.graph.ImmutableNetwork;
import com.google.common.graph.MutableNetwork;
import com.google.common.graph.Network;
import com.google.common.graph.NetworkBuilder;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public class ImmutableNetworkTest {
    @Test
    public void immutableNetwork() {
        MutableNetwork mutableNetwork = NetworkBuilder.directed().build();
        mutableNetwork.addNode((Object)"A");
        ImmutableNetwork immutableNetwork = ImmutableNetwork.copyOf((Network)mutableNetwork);
        Truth.assertThat((Object)immutableNetwork.asGraph()).isInstanceOf(ImmutableGraph.class);
        Truth.assertThat((Object)immutableNetwork).isNotInstanceOf(MutableNetwork.class);
        Truth.assertThat((Object)immutableNetwork).isEqualTo((Object)mutableNetwork);
        mutableNetwork.addNode((Object)"B");
        Truth.assertThat((Object)immutableNetwork).isNotEqualTo((Object)mutableNetwork);
    }

    @Test
    public void copyOfImmutableNetwork_optimized() {
        ImmutableNetwork network1 = ImmutableNetwork.copyOf((Network)NetworkBuilder.directed().build());
        ImmutableNetwork network2 = ImmutableNetwork.copyOf((Network)network1);
        Truth.assertThat((Object)network2).isSameAs((Object)network1);
    }

    @Test
    public void edgesConnecting_directed() {
        MutableNetwork mutableNetwork = NetworkBuilder.directed().allowsSelfLoops(true).build();
        mutableNetwork.addEdge((Object)"A", (Object)"A", (Object)"AA");
        mutableNetwork.addEdge((Object)"A", (Object)"B", (Object)"AB");
        ImmutableNetwork network = ImmutableNetwork.copyOf((Network)mutableNetwork);
        Truth.assertThat((Iterable)network.edgesConnecting((Object)"A", (Object)"A")).containsExactly(new Object[]{"AA"});
        Truth.assertThat((Iterable)network.edgesConnecting((Object)"A", (Object)"B")).containsExactly(new Object[]{"AB"});
        Truth.assertThat((Iterable)network.edgesConnecting((Object)"B", (Object)"A")).isEmpty();
    }

    @Test
    public void edgesConnecting_undirected() {
        MutableNetwork mutableNetwork = NetworkBuilder.undirected().allowsSelfLoops(true).build();
        mutableNetwork.addEdge((Object)"A", (Object)"A", (Object)"AA");
        mutableNetwork.addEdge((Object)"A", (Object)"B", (Object)"AB");
        ImmutableNetwork network = ImmutableNetwork.copyOf((Network)mutableNetwork);
        Truth.assertThat((Iterable)network.edgesConnecting((Object)"A", (Object)"A")).containsExactly(new Object[]{"AA"});
        Truth.assertThat((Iterable)network.edgesConnecting((Object)"A", (Object)"B")).containsExactly(new Object[]{"AB"});
        Truth.assertThat((Iterable)network.edgesConnecting((Object)"B", (Object)"A")).containsExactly(new Object[]{"AB"});
    }
}

